/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.budget.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.budget.model.UpdateAlertRuleDetails;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class UpdateAlertRuleRequest
extends BmcRequest<UpdateAlertRuleDetails> {
    private String budgetId;
    private String alertRuleId;
    private UpdateAlertRuleDetails updateAlertRuleDetails;
    private String ifMatch;
    private String opcRequestId;

    public String getBudgetId() {
        return this.budgetId;
    }

    public String getAlertRuleId() {
        return this.alertRuleId;
    }

    public UpdateAlertRuleDetails getUpdateAlertRuleDetails() {
        return this.updateAlertRuleDetails;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    @InternalSdk
    public UpdateAlertRuleDetails getBody$() {
        return this.updateAlertRuleDetails;
    }

    public Builder toBuilder() {
        return new Builder().budgetId(this.budgetId).alertRuleId(this.alertRuleId).updateAlertRuleDetails(this.updateAlertRuleDetails).ifMatch(this.ifMatch).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",budgetId=").append(String.valueOf(this.budgetId));
        sb.append(",alertRuleId=").append(String.valueOf(this.alertRuleId));
        sb.append(",updateAlertRuleDetails=").append(String.valueOf((Object)this.updateAlertRuleDetails));
        sb.append(",ifMatch=").append(String.valueOf(this.ifMatch));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UpdateAlertRuleRequest)) {
            return false;
        }
        UpdateAlertRuleRequest other = (UpdateAlertRuleRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.budgetId, other.budgetId) && Objects.equals(this.alertRuleId, other.alertRuleId) && Objects.equals((Object)this.updateAlertRuleDetails, (Object)other.updateAlertRuleDetails) && Objects.equals(this.ifMatch, other.ifMatch) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.budgetId == null ? 43 : this.budgetId.hashCode());
        result = result * 59 + (this.alertRuleId == null ? 43 : this.alertRuleId.hashCode());
        result = result * 59 + (this.updateAlertRuleDetails == null ? 43 : this.updateAlertRuleDetails.hashCode());
        result = result * 59 + (this.ifMatch == null ? 43 : this.ifMatch.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<UpdateAlertRuleRequest, UpdateAlertRuleDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String budgetId = null;
        private String alertRuleId = null;
        private UpdateAlertRuleDetails updateAlertRuleDetails = null;
        private String ifMatch = null;
        private String opcRequestId = null;

        public Builder budgetId(String budgetId) {
            this.budgetId = budgetId;
            return this;
        }

        public Builder alertRuleId(String alertRuleId) {
            this.alertRuleId = alertRuleId;
            return this;
        }

        public Builder updateAlertRuleDetails(UpdateAlertRuleDetails updateAlertRuleDetails) {
            this.updateAlertRuleDetails = updateAlertRuleDetails;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(UpdateAlertRuleRequest o) {
            this.budgetId(o.getBudgetId());
            this.alertRuleId(o.getAlertRuleId());
            this.updateAlertRuleDetails(o.getUpdateAlertRuleDetails());
            this.ifMatch(o.getIfMatch());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public UpdateAlertRuleRequest build() {
            UpdateAlertRuleRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(UpdateAlertRuleDetails body) {
            this.updateAlertRuleDetails(body);
            return this;
        }

        public UpdateAlertRuleRequest buildWithoutInvocationCallback() {
            UpdateAlertRuleRequest request = new UpdateAlertRuleRequest();
            request.budgetId = this.budgetId;
            request.alertRuleId = this.alertRuleId;
            request.updateAlertRuleDetails = this.updateAlertRuleDetails;
            request.ifMatch = this.ifMatch;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

