/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.budget.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class GetAlertRuleRequest
extends BmcRequest<Void> {
    private String budgetId;
    private String alertRuleId;
    private String opcRequestId;

    public String getBudgetId() {
        return this.budgetId;
    }

    public String getAlertRuleId() {
        return this.alertRuleId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().budgetId(this.budgetId).alertRuleId(this.alertRuleId).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",budgetId=").append(String.valueOf(this.budgetId));
        sb.append(",alertRuleId=").append(String.valueOf(this.alertRuleId));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetAlertRuleRequest)) {
            return false;
        }
        GetAlertRuleRequest other = (GetAlertRuleRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.budgetId, other.budgetId) && Objects.equals(this.alertRuleId, other.alertRuleId) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.budgetId == null ? 43 : this.budgetId.hashCode());
        result = result * 59 + (this.alertRuleId == null ? 43 : this.alertRuleId.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<GetAlertRuleRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String budgetId = null;
        private String alertRuleId = null;
        private String opcRequestId = null;

        public Builder budgetId(String budgetId) {
            this.budgetId = budgetId;
            return this;
        }

        public Builder alertRuleId(String alertRuleId) {
            this.alertRuleId = alertRuleId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetAlertRuleRequest o) {
            this.budgetId(o.getBudgetId());
            this.alertRuleId(o.getAlertRuleId());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetAlertRuleRequest build() {
            GetAlertRuleRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public GetAlertRuleRequest buildWithoutInvocationCallback() {
            GetAlertRuleRequest request = new GetAlertRuleRequest();
            request.budgetId = this.budgetId;
            request.alertRuleId = this.alertRuleId;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

