/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.budget;

import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.budget.Budget;
import com.oracle.bmc.budget.BudgetAsyncClient;
import com.oracle.bmc.budget.BudgetPaginators;
import com.oracle.bmc.budget.BudgetWaiters;
import com.oracle.bmc.budget.model.AlertRule;
import com.oracle.bmc.budget.model.AlertRuleSummary;
import com.oracle.bmc.budget.model.BudgetSummary;
import com.oracle.bmc.budget.requests.CreateAlertRuleRequest;
import com.oracle.bmc.budget.requests.CreateBudgetRequest;
import com.oracle.bmc.budget.requests.DeleteAlertRuleRequest;
import com.oracle.bmc.budget.requests.DeleteBudgetRequest;
import com.oracle.bmc.budget.requests.GetAlertRuleRequest;
import com.oracle.bmc.budget.requests.GetBudgetRequest;
import com.oracle.bmc.budget.requests.ListAlertRulesRequest;
import com.oracle.bmc.budget.requests.ListBudgetsRequest;
import com.oracle.bmc.budget.requests.UpdateAlertRuleRequest;
import com.oracle.bmc.budget.requests.UpdateBudgetRequest;
import com.oracle.bmc.budget.responses.CreateAlertRuleResponse;
import com.oracle.bmc.budget.responses.CreateBudgetResponse;
import com.oracle.bmc.budget.responses.DeleteAlertRuleResponse;
import com.oracle.bmc.budget.responses.DeleteBudgetResponse;
import com.oracle.bmc.budget.responses.GetAlertRuleResponse;
import com.oracle.bmc.budget.responses.GetBudgetResponse;
import com.oracle.bmc.budget.responses.ListAlertRulesResponse;
import com.oracle.bmc.budget.responses.ListBudgetsResponse;
import com.oracle.bmc.budget.responses.UpdateAlertRuleResponse;
import com.oracle.bmc.budget.responses.UpdateBudgetResponse;
import com.oracle.bmc.common.ClientBuilderBase;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.client.Method;
import com.oracle.bmc.http.internal.BaseSyncClient;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.internal.ClientThreadFactory;
import com.oracle.bmc.util.CircuitBreakerUtils;
import com.oracle.bmc.util.internal.Validate;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BudgetClient
extends BaseSyncClient
implements Budget {
    public static final Service SERVICE = Services.serviceBuilder().serviceName("BUDGET").serviceEndpointPrefix("").serviceEndpointTemplate("https://usage.{region}.oci.{secondLevelDomain}").build();
    private static final Logger LOG = LoggerFactory.getLogger(BudgetAsyncClient.class);
    private final BudgetWaiters waiters;
    private final BudgetPaginators paginators;

    private BudgetClient(ClientBuilderBase<?, ?> builder, AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ExecutorService executorService) {
        super(builder, authenticationDetailsProvider, CircuitBreakerUtils.DEFAULT_CIRCUIT_BREAKER_CONFIGURATION);
        if (executorService == null) {
            ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(50, 50, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), (ThreadFactory)ClientThreadFactory.builder().isDaemon(true).nameFormat("Budget-waiters-%d").build());
            threadPoolExecutor.allowCoreThreadTimeOut(true);
            executorService = threadPoolExecutor;
        }
        this.waiters = new BudgetWaiters(executorService, this);
        this.paginators = new BudgetPaginators(this);
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setRegion(Region region) {
        super.setRegion(region);
    }

    @Override
    public void setRegion(String regionId) {
        super.setRegion(regionId);
    }

    @Override
    public CreateAlertRuleResponse createAlertRule(CreateAlertRuleRequest request) {
        Validate.notBlank((String)request.getBudgetId(), (String)"budgetId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getCreateAlertRuleDetails(), "createAlertRuleDetails is required");
        return (CreateAlertRuleResponse)this.clientCall(request, CreateAlertRuleResponse::builder).logger(LOG, "createAlertRule").serviceDetails("Budget", "CreateAlertRule", "https://docs.oracle.com/iaas/api/#/en/budgets/20190111/AlertRule/CreateAlertRule").method(Method.POST).requestBuilder(CreateAlertRuleRequest::builder).basePath("/20190111").appendPathParam("budgets").appendPathParam(request.getBudgetId()).appendPathParam("alertRules").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(AlertRule.class, CreateAlertRuleResponse.Builder::alertRule).handleResponseHeaderString("opc-request-id", CreateAlertRuleResponse.Builder::opcRequestId).handleResponseHeaderString("etag", CreateAlertRuleResponse.Builder::etag).callSync();
    }

    @Override
    public CreateBudgetResponse createBudget(CreateBudgetRequest request) {
        Objects.requireNonNull(request.getCreateBudgetDetails(), "createBudgetDetails is required");
        return (CreateBudgetResponse)this.clientCall(request, CreateBudgetResponse::builder).logger(LOG, "createBudget").serviceDetails("Budget", "CreateBudget", "https://docs.oracle.com/iaas/api/#/en/budgets/20190111/Budget/CreateBudget").method(Method.POST).requestBuilder(CreateBudgetRequest::builder).basePath("/20190111").appendPathParam("budgets").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(com.oracle.bmc.budget.model.Budget.class, CreateBudgetResponse.Builder::budget).handleResponseHeaderString("opc-request-id", CreateBudgetResponse.Builder::opcRequestId).handleResponseHeaderString("etag", CreateBudgetResponse.Builder::etag).callSync();
    }

    @Override
    public DeleteAlertRuleResponse deleteAlertRule(DeleteAlertRuleRequest request) {
        Validate.notBlank((String)request.getBudgetId(), (String)"budgetId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getAlertRuleId(), (String)"alertRuleId must not be blank", (Object[])new Object[0]);
        return (DeleteAlertRuleResponse)this.clientCall(request, DeleteAlertRuleResponse::builder).logger(LOG, "deleteAlertRule").serviceDetails("Budget", "DeleteAlertRule", "https://docs.oracle.com/iaas/api/#/en/budgets/20190111/AlertRule/DeleteAlertRule").method(Method.DELETE).requestBuilder(DeleteAlertRuleRequest::builder).basePath("/20190111").appendPathParam("budgets").appendPathParam(request.getBudgetId()).appendPathParam("alertRules").appendPathParam(request.getAlertRuleId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-request-id", DeleteAlertRuleResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public DeleteBudgetResponse deleteBudget(DeleteBudgetRequest request) {
        Validate.notBlank((String)request.getBudgetId(), (String)"budgetId must not be blank", (Object[])new Object[0]);
        return (DeleteBudgetResponse)this.clientCall(request, DeleteBudgetResponse::builder).logger(LOG, "deleteBudget").serviceDetails("Budget", "DeleteBudget", "https://docs.oracle.com/iaas/api/#/en/budgets/20190111/Budget/DeleteBudget").method(Method.DELETE).requestBuilder(DeleteBudgetRequest::builder).basePath("/20190111").appendPathParam("budgets").appendPathParam(request.getBudgetId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-request-id", DeleteBudgetResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetAlertRuleResponse getAlertRule(GetAlertRuleRequest request) {
        Validate.notBlank((String)request.getBudgetId(), (String)"budgetId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getAlertRuleId(), (String)"alertRuleId must not be blank", (Object[])new Object[0]);
        return (GetAlertRuleResponse)this.clientCall(request, GetAlertRuleResponse::builder).logger(LOG, "getAlertRule").serviceDetails("Budget", "GetAlertRule", "https://docs.oracle.com/iaas/api/#/en/budgets/20190111/AlertRule/GetAlertRule").method(Method.GET).requestBuilder(GetAlertRuleRequest::builder).basePath("/20190111").appendPathParam("budgets").appendPathParam(request.getBudgetId()).appendPathParam("alertRules").appendPathParam(request.getAlertRuleId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(AlertRule.class, GetAlertRuleResponse.Builder::alertRule).handleResponseHeaderString("etag", GetAlertRuleResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetAlertRuleResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetBudgetResponse getBudget(GetBudgetRequest request) {
        Validate.notBlank((String)request.getBudgetId(), (String)"budgetId must not be blank", (Object[])new Object[0]);
        return (GetBudgetResponse)this.clientCall(request, GetBudgetResponse::builder).logger(LOG, "getBudget").serviceDetails("Budget", "GetBudget", "https://docs.oracle.com/iaas/api/#/en/budgets/20190111/Budget/GetBudget").method(Method.GET).requestBuilder(GetBudgetRequest::builder).basePath("/20190111").appendPathParam("budgets").appendPathParam(request.getBudgetId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(com.oracle.bmc.budget.model.Budget.class, GetBudgetResponse.Builder::budget).handleResponseHeaderString("etag", GetBudgetResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetBudgetResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ListAlertRulesResponse listAlertRules(ListAlertRulesRequest request) {
        Validate.notBlank((String)request.getBudgetId(), (String)"budgetId must not be blank", (Object[])new Object[0]);
        return (ListAlertRulesResponse)this.clientCall(request, ListAlertRulesResponse::builder).logger(LOG, "listAlertRules").serviceDetails("Budget", "ListAlertRules", "https://docs.oracle.com/iaas/api/#/en/budgets/20190111/AlertRuleSummary/ListAlertRules").method(Method.GET).requestBuilder(ListAlertRulesRequest::builder).basePath("/20190111").appendPathParam("budgets").appendPathParam(request.getBudgetId()).appendPathParam("alertRules").appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendQueryParam("displayName", (Object)request.getDisplayName()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBodyList(AlertRuleSummary.class, ListAlertRulesResponse.Builder::items).handleResponseHeaderString("opc-request-id", ListAlertRulesResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListAlertRulesResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public ListBudgetsResponse listBudgets(ListBudgetsRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (ListBudgetsResponse)this.clientCall(request, ListBudgetsResponse::builder).logger(LOG, "listBudgets").serviceDetails("Budget", "ListBudgets", "https://docs.oracle.com/iaas/api/#/en/budgets/20190111/BudgetSummary/ListBudgets").method(Method.GET).requestBuilder(ListBudgetsRequest::builder).basePath("/20190111").appendPathParam("budgets").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendEnumQueryParam("targetType", (BmcEnum)request.getTargetType()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBodyList(BudgetSummary.class, ListBudgetsResponse.Builder::items).handleResponseHeaderString("opc-request-id", ListBudgetsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListBudgetsResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public UpdateAlertRuleResponse updateAlertRule(UpdateAlertRuleRequest request) {
        Validate.notBlank((String)request.getBudgetId(), (String)"budgetId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getAlertRuleId(), (String)"alertRuleId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateAlertRuleDetails(), "updateAlertRuleDetails is required");
        return (UpdateAlertRuleResponse)this.clientCall(request, UpdateAlertRuleResponse::builder).logger(LOG, "updateAlertRule").serviceDetails("Budget", "UpdateAlertRule", "https://docs.oracle.com/iaas/api/#/en/budgets/20190111/AlertRule/UpdateAlertRule").method(Method.PUT).requestBuilder(UpdateAlertRuleRequest::builder).basePath("/20190111").appendPathParam("budgets").appendPathParam(request.getBudgetId()).appendPathParam("alertRules").appendPathParam(request.getAlertRuleId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(AlertRule.class, UpdateAlertRuleResponse.Builder::alertRule).handleResponseHeaderString("opc-request-id", UpdateAlertRuleResponse.Builder::opcRequestId).handleResponseHeaderString("etag", UpdateAlertRuleResponse.Builder::etag).callSync();
    }

    @Override
    public UpdateBudgetResponse updateBudget(UpdateBudgetRequest request) {
        Validate.notBlank((String)request.getBudgetId(), (String)"budgetId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateBudgetDetails(), "updateBudgetDetails is required");
        return (UpdateBudgetResponse)this.clientCall(request, UpdateBudgetResponse::builder).logger(LOG, "updateBudget").serviceDetails("Budget", "UpdateBudget", "https://docs.oracle.com/iaas/api/#/en/budgets/20190111/Budget/UpdateBudget").method(Method.PUT).requestBuilder(UpdateBudgetRequest::builder).basePath("/20190111").appendPathParam("budgets").appendPathParam(request.getBudgetId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(com.oracle.bmc.budget.model.Budget.class, UpdateBudgetResponse.Builder::budget).handleResponseHeaderString("opc-request-id", UpdateBudgetResponse.Builder::opcRequestId).handleResponseHeaderString("etag", UpdateBudgetResponse.Builder::etag).callSync();
    }

    @Override
    public BudgetWaiters getWaiters() {
        return this.waiters;
    }

    @Override
    public BudgetPaginators getPaginators() {
        return this.paginators;
    }

    @Deprecated
    public BudgetClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this((ClientBuilderBase<?, ?>)BudgetClient.builder(), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public BudgetClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(BudgetClient.builder().configuration(configuration), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public BudgetClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this(((Builder)BudgetClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public BudgetClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(((Builder)((Builder)BudgetClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory), authenticationDetailsProvider, null);
    }

    @Deprecated
    public BudgetClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(((Builder)((Builder)((Builder)BudgetClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators), authenticationDetailsProvider, null);
    }

    @Deprecated
    public BudgetClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)BudgetClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint), authenticationDetailsProvider, null);
    }

    @Deprecated
    public BudgetClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)BudgetClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider, null);
    }

    @Deprecated
    public BudgetClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint, ExecutorService executorService) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)BudgetClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider, executorService);
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, BudgetClient> {
        private ExecutorService executorService;

        private Builder(Service service) {
            super(service);
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public Builder executorService(ExecutorService executorService) {
            this.executorService = executorService;
            return this;
        }

        public BudgetClient build(@Nonnull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            return new BudgetClient((ClientBuilderBase)this, authenticationDetailsProvider, this.executorService);
        }
    }
}

