/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.blockchain.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.blockchain.model.UpdatePeerDetails;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class UpdatePeerRequest
extends BmcRequest<UpdatePeerDetails> {
    private String blockchainPlatformId;
    private String peerId;
    private UpdatePeerDetails updatePeerDetails;
    private String ifMatch;
    private String opcRequestId;
    private String opcRetryToken;

    public String getBlockchainPlatformId() {
        return this.blockchainPlatformId;
    }

    public String getPeerId() {
        return this.peerId;
    }

    public UpdatePeerDetails getUpdatePeerDetails() {
        return this.updatePeerDetails;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getOpcRetryToken() {
        return this.opcRetryToken;
    }

    @InternalSdk
    public UpdatePeerDetails getBody$() {
        return this.updatePeerDetails;
    }

    public Builder toBuilder() {
        return new Builder().blockchainPlatformId(this.blockchainPlatformId).peerId(this.peerId).updatePeerDetails(this.updatePeerDetails).ifMatch(this.ifMatch).opcRequestId(this.opcRequestId).opcRetryToken(this.opcRetryToken);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",blockchainPlatformId=").append(String.valueOf(this.blockchainPlatformId));
        sb.append(",peerId=").append(String.valueOf(this.peerId));
        sb.append(",updatePeerDetails=").append(String.valueOf((Object)this.updatePeerDetails));
        sb.append(",ifMatch=").append(String.valueOf(this.ifMatch));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",opcRetryToken=").append(String.valueOf(this.opcRetryToken));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UpdatePeerRequest)) {
            return false;
        }
        UpdatePeerRequest other = (UpdatePeerRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.blockchainPlatformId, other.blockchainPlatformId) && Objects.equals(this.peerId, other.peerId) && Objects.equals((Object)this.updatePeerDetails, (Object)other.updatePeerDetails) && Objects.equals(this.ifMatch, other.ifMatch) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.opcRetryToken, other.opcRetryToken);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.blockchainPlatformId == null ? 43 : this.blockchainPlatformId.hashCode());
        result = result * 59 + (this.peerId == null ? 43 : this.peerId.hashCode());
        result = result * 59 + (this.updatePeerDetails == null ? 43 : this.updatePeerDetails.hashCode());
        result = result * 59 + (this.ifMatch == null ? 43 : this.ifMatch.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.opcRetryToken == null ? 43 : this.opcRetryToken.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<UpdatePeerRequest, UpdatePeerDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String blockchainPlatformId = null;
        private String peerId = null;
        private UpdatePeerDetails updatePeerDetails = null;
        private String ifMatch = null;
        private String opcRequestId = null;
        private String opcRetryToken = null;

        public Builder blockchainPlatformId(String blockchainPlatformId) {
            this.blockchainPlatformId = blockchainPlatformId;
            return this;
        }

        public Builder peerId(String peerId) {
            this.peerId = peerId;
            return this;
        }

        public Builder updatePeerDetails(UpdatePeerDetails updatePeerDetails) {
            this.updatePeerDetails = updatePeerDetails;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder opcRetryToken(String opcRetryToken) {
            this.opcRetryToken = opcRetryToken;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(UpdatePeerRequest o) {
            this.blockchainPlatformId(o.getBlockchainPlatformId());
            this.peerId(o.getPeerId());
            this.updatePeerDetails(o.getUpdatePeerDetails());
            this.ifMatch(o.getIfMatch());
            this.opcRequestId(o.getOpcRequestId());
            this.opcRetryToken(o.getOpcRetryToken());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public UpdatePeerRequest build() {
            UpdatePeerRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(UpdatePeerDetails body) {
            this.updatePeerDetails(body);
            return this;
        }

        public UpdatePeerRequest buildWithoutInvocationCallback() {
            UpdatePeerRequest request = new UpdatePeerRequest();
            request.blockchainPlatformId = this.blockchainPlatformId;
            request.peerId = this.peerId;
            request.updatePeerDetails = this.updatePeerDetails;
            request.ifMatch = this.ifMatch;
            request.opcRequestId = this.opcRequestId;
            request.opcRetryToken = this.opcRetryToken;
            return request;
        }
    }
}

