/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.blockchain.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.blockchain.model.ScaleBlockchainPlatformDetails;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class ScaleBlockchainPlatformRequest
extends BmcRequest<ScaleBlockchainPlatformDetails> {
    private String blockchainPlatformId;
    private ScaleBlockchainPlatformDetails scaleBlockchainPlatformDetails;
    private String ifMatch;
    private String opcRequestId;
    private String opcRetryToken;

    public String getBlockchainPlatformId() {
        return this.blockchainPlatformId;
    }

    public ScaleBlockchainPlatformDetails getScaleBlockchainPlatformDetails() {
        return this.scaleBlockchainPlatformDetails;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getOpcRetryToken() {
        return this.opcRetryToken;
    }

    @InternalSdk
    public ScaleBlockchainPlatformDetails getBody$() {
        return this.scaleBlockchainPlatformDetails;
    }

    public Builder toBuilder() {
        return new Builder().blockchainPlatformId(this.blockchainPlatformId).scaleBlockchainPlatformDetails(this.scaleBlockchainPlatformDetails).ifMatch(this.ifMatch).opcRequestId(this.opcRequestId).opcRetryToken(this.opcRetryToken);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",blockchainPlatformId=").append(String.valueOf(this.blockchainPlatformId));
        sb.append(",scaleBlockchainPlatformDetails=").append(String.valueOf((Object)this.scaleBlockchainPlatformDetails));
        sb.append(",ifMatch=").append(String.valueOf(this.ifMatch));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",opcRetryToken=").append(String.valueOf(this.opcRetryToken));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ScaleBlockchainPlatformRequest)) {
            return false;
        }
        ScaleBlockchainPlatformRequest other = (ScaleBlockchainPlatformRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.blockchainPlatformId, other.blockchainPlatformId) && Objects.equals((Object)this.scaleBlockchainPlatformDetails, (Object)other.scaleBlockchainPlatformDetails) && Objects.equals(this.ifMatch, other.ifMatch) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.opcRetryToken, other.opcRetryToken);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.blockchainPlatformId == null ? 43 : this.blockchainPlatformId.hashCode());
        result = result * 59 + (this.scaleBlockchainPlatformDetails == null ? 43 : this.scaleBlockchainPlatformDetails.hashCode());
        result = result * 59 + (this.ifMatch == null ? 43 : this.ifMatch.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.opcRetryToken == null ? 43 : this.opcRetryToken.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<ScaleBlockchainPlatformRequest, ScaleBlockchainPlatformDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String blockchainPlatformId = null;
        private ScaleBlockchainPlatformDetails scaleBlockchainPlatformDetails = null;
        private String ifMatch = null;
        private String opcRequestId = null;
        private String opcRetryToken = null;

        public Builder blockchainPlatformId(String blockchainPlatformId) {
            this.blockchainPlatformId = blockchainPlatformId;
            return this;
        }

        public Builder scaleBlockchainPlatformDetails(ScaleBlockchainPlatformDetails scaleBlockchainPlatformDetails) {
            this.scaleBlockchainPlatformDetails = scaleBlockchainPlatformDetails;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder opcRetryToken(String opcRetryToken) {
            this.opcRetryToken = opcRetryToken;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ScaleBlockchainPlatformRequest o) {
            this.blockchainPlatformId(o.getBlockchainPlatformId());
            this.scaleBlockchainPlatformDetails(o.getScaleBlockchainPlatformDetails());
            this.ifMatch(o.getIfMatch());
            this.opcRequestId(o.getOpcRequestId());
            this.opcRetryToken(o.getOpcRetryToken());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ScaleBlockchainPlatformRequest build() {
            ScaleBlockchainPlatformRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(ScaleBlockchainPlatformDetails body) {
            this.scaleBlockchainPlatformDetails(body);
            return this;
        }

        public ScaleBlockchainPlatformRequest buildWithoutInvocationCallback() {
            ScaleBlockchainPlatformRequest request = new ScaleBlockchainPlatformRequest();
            request.blockchainPlatformId = this.blockchainPlatformId;
            request.scaleBlockchainPlatformDetails = this.scaleBlockchainPlatformDetails;
            request.ifMatch = this.ifMatch;
            request.opcRequestId = this.opcRequestId;
            request.opcRetryToken = this.opcRetryToken;
            return request;
        }
    }
}

