/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.blockchain.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.blockchain.model.CreateBlockchainPlatformDetails;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class CreateBlockchainPlatformRequest
extends BmcRequest<CreateBlockchainPlatformDetails> {
    private CreateBlockchainPlatformDetails createBlockchainPlatformDetails;
    private String opcRetryToken;
    private String opcRequestId;

    public CreateBlockchainPlatformDetails getCreateBlockchainPlatformDetails() {
        return this.createBlockchainPlatformDetails;
    }

    public String getOpcRetryToken() {
        return this.opcRetryToken;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    @InternalSdk
    public CreateBlockchainPlatformDetails getBody$() {
        return this.createBlockchainPlatformDetails;
    }

    public Builder toBuilder() {
        return new Builder().createBlockchainPlatformDetails(this.createBlockchainPlatformDetails).opcRetryToken(this.opcRetryToken).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",createBlockchainPlatformDetails=").append(String.valueOf((Object)this.createBlockchainPlatformDetails));
        sb.append(",opcRetryToken=").append(String.valueOf(this.opcRetryToken));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CreateBlockchainPlatformRequest)) {
            return false;
        }
        CreateBlockchainPlatformRequest other = (CreateBlockchainPlatformRequest)((Object)o);
        return super.equals(o) && Objects.equals((Object)this.createBlockchainPlatformDetails, (Object)other.createBlockchainPlatformDetails) && Objects.equals(this.opcRetryToken, other.opcRetryToken) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.createBlockchainPlatformDetails == null ? 43 : this.createBlockchainPlatformDetails.hashCode());
        result = result * 59 + (this.opcRetryToken == null ? 43 : this.opcRetryToken.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<CreateBlockchainPlatformRequest, CreateBlockchainPlatformDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private CreateBlockchainPlatformDetails createBlockchainPlatformDetails = null;
        private String opcRetryToken = null;
        private String opcRequestId = null;

        public Builder createBlockchainPlatformDetails(CreateBlockchainPlatformDetails createBlockchainPlatformDetails) {
            this.createBlockchainPlatformDetails = createBlockchainPlatformDetails;
            return this;
        }

        public Builder opcRetryToken(String opcRetryToken) {
            this.opcRetryToken = opcRetryToken;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(CreateBlockchainPlatformRequest o) {
            this.createBlockchainPlatformDetails(o.getCreateBlockchainPlatformDetails());
            this.opcRetryToken(o.getOpcRetryToken());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public CreateBlockchainPlatformRequest build() {
            CreateBlockchainPlatformRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(CreateBlockchainPlatformDetails body) {
            this.createBlockchainPlatformDetails(body);
            return this;
        }

        public CreateBlockchainPlatformRequest buildWithoutInvocationCallback() {
            CreateBlockchainPlatformRequest request = new CreateBlockchainPlatformRequest();
            request.createBlockchainPlatformDetails = this.createBlockchainPlatformDetails;
            request.opcRetryToken = this.opcRetryToken;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

