/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.blockchain.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.blockchain.model.Peer;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class PeerSummary
extends ExplicitlySetBmcModel {
    @JsonProperty(value="peerKey")
    private final String peerKey;
    @JsonProperty(value="lifecycleState")
    private final Peer.LifecycleState lifecycleState;

    @Deprecated
    @ConstructorProperties(value={"peerKey", "lifecycleState"})
    public PeerSummary(String peerKey, Peer.LifecycleState lifecycleState) {
        this.peerKey = peerKey;
        this.lifecycleState = lifecycleState;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getPeerKey() {
        return this.peerKey;
    }

    public Peer.LifecycleState getLifecycleState() {
        return this.lifecycleState;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("PeerSummary(");
        sb.append("super=").append(super.toString());
        sb.append("peerKey=").append(String.valueOf(this.peerKey));
        sb.append(", lifecycleState=").append(String.valueOf((Object)this.lifecycleState));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PeerSummary)) {
            return false;
        }
        PeerSummary other = (PeerSummary)((Object)o);
        return Objects.equals(this.peerKey, other.peerKey) && Objects.equals((Object)this.lifecycleState, (Object)other.lifecycleState) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.peerKey == null ? 43 : this.peerKey.hashCode());
        result = result * 59 + (this.lifecycleState == null ? 43 : this.lifecycleState.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="peerKey")
        private String peerKey;
        @JsonProperty(value="lifecycleState")
        private Peer.LifecycleState lifecycleState;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder peerKey(String peerKey) {
            this.peerKey = peerKey;
            this.__explicitlySet__.add("peerKey");
            return this;
        }

        public Builder lifecycleState(Peer.LifecycleState lifecycleState) {
            this.lifecycleState = lifecycleState;
            this.__explicitlySet__.add("lifecycleState");
            return this;
        }

        public PeerSummary build() {
            PeerSummary model = new PeerSummary(this.peerKey, this.lifecycleState);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(PeerSummary model) {
            if (model.wasPropertyExplicitlySet("peerKey")) {
                this.peerKey(model.getPeerKey());
            }
            if (model.wasPropertyExplicitlySet("lifecycleState")) {
                this.lifecycleState(model.getLifecycleState());
            }
            return this;
        }
    }
}

