/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.blockchain.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.blockchain.model.AvailabilityDomain;
import com.oracle.bmc.blockchain.model.OcpuAllocationNumberParam;
import com.oracle.bmc.blockchain.model.PeerRole;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class Peer
extends ExplicitlySetBmcModel {
    @JsonProperty(value="peerKey")
    private final String peerKey;
    @JsonProperty(value="role")
    private final PeerRole.Role role;
    @JsonProperty(value="alias")
    private final String alias;
    @JsonProperty(value="ocpuAllocationParam")
    private final OcpuAllocationNumberParam ocpuAllocationParam;
    @JsonProperty(value="host")
    private final String host;
    @JsonProperty(value="ad")
    private final AvailabilityDomain.Ads ad;
    @JsonProperty(value="lifecycleState")
    private final LifecycleState lifecycleState;

    @Deprecated
    @ConstructorProperties(value={"peerKey", "role", "alias", "ocpuAllocationParam", "host", "ad", "lifecycleState"})
    public Peer(String peerKey, PeerRole.Role role, String alias, OcpuAllocationNumberParam ocpuAllocationParam, String host, AvailabilityDomain.Ads ad, LifecycleState lifecycleState) {
        this.peerKey = peerKey;
        this.role = role;
        this.alias = alias;
        this.ocpuAllocationParam = ocpuAllocationParam;
        this.host = host;
        this.ad = ad;
        this.lifecycleState = lifecycleState;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getPeerKey() {
        return this.peerKey;
    }

    public PeerRole.Role getRole() {
        return this.role;
    }

    public String getAlias() {
        return this.alias;
    }

    public OcpuAllocationNumberParam getOcpuAllocationParam() {
        return this.ocpuAllocationParam;
    }

    public String getHost() {
        return this.host;
    }

    public AvailabilityDomain.Ads getAd() {
        return this.ad;
    }

    public LifecycleState getLifecycleState() {
        return this.lifecycleState;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("Peer(");
        sb.append("super=").append(super.toString());
        sb.append("peerKey=").append(String.valueOf(this.peerKey));
        sb.append(", role=").append(String.valueOf((Object)this.role));
        sb.append(", alias=").append(String.valueOf(this.alias));
        sb.append(", ocpuAllocationParam=").append(String.valueOf((Object)this.ocpuAllocationParam));
        sb.append(", host=").append(String.valueOf(this.host));
        sb.append(", ad=").append(String.valueOf((Object)this.ad));
        sb.append(", lifecycleState=").append(String.valueOf((Object)this.lifecycleState));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Peer)) {
            return false;
        }
        Peer other = (Peer)((Object)o);
        return Objects.equals(this.peerKey, other.peerKey) && Objects.equals((Object)this.role, (Object)other.role) && Objects.equals(this.alias, other.alias) && Objects.equals((Object)this.ocpuAllocationParam, (Object)other.ocpuAllocationParam) && Objects.equals(this.host, other.host) && Objects.equals((Object)this.ad, (Object)other.ad) && Objects.equals((Object)this.lifecycleState, (Object)other.lifecycleState) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.peerKey == null ? 43 : this.peerKey.hashCode());
        result = result * 59 + (this.role == null ? 43 : this.role.hashCode());
        result = result * 59 + (this.alias == null ? 43 : this.alias.hashCode());
        result = result * 59 + (this.ocpuAllocationParam == null ? 43 : this.ocpuAllocationParam.hashCode());
        result = result * 59 + (this.host == null ? 43 : this.host.hashCode());
        result = result * 59 + (this.ad == null ? 43 : this.ad.hashCode());
        result = result * 59 + (this.lifecycleState == null ? 43 : this.lifecycleState.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum LifecycleState implements BmcEnum
    {
        Active("ACTIVE"),
        Inactive("INACTIVE"),
        Failed("FAILED"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, LifecycleState> map;

        private LifecycleState(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static LifecycleState create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'LifecycleState', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(LifecycleState.class);
            map = new HashMap<String, LifecycleState>();
            for (LifecycleState v : LifecycleState.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="peerKey")
        private String peerKey;
        @JsonProperty(value="role")
        private PeerRole.Role role;
        @JsonProperty(value="alias")
        private String alias;
        @JsonProperty(value="ocpuAllocationParam")
        private OcpuAllocationNumberParam ocpuAllocationParam;
        @JsonProperty(value="host")
        private String host;
        @JsonProperty(value="ad")
        private AvailabilityDomain.Ads ad;
        @JsonProperty(value="lifecycleState")
        private LifecycleState lifecycleState;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder peerKey(String peerKey) {
            this.peerKey = peerKey;
            this.__explicitlySet__.add("peerKey");
            return this;
        }

        public Builder role(PeerRole.Role role) {
            this.role = role;
            this.__explicitlySet__.add("role");
            return this;
        }

        public Builder alias(String alias) {
            this.alias = alias;
            this.__explicitlySet__.add("alias");
            return this;
        }

        public Builder ocpuAllocationParam(OcpuAllocationNumberParam ocpuAllocationParam) {
            this.ocpuAllocationParam = ocpuAllocationParam;
            this.__explicitlySet__.add("ocpuAllocationParam");
            return this;
        }

        public Builder host(String host) {
            this.host = host;
            this.__explicitlySet__.add("host");
            return this;
        }

        public Builder ad(AvailabilityDomain.Ads ad) {
            this.ad = ad;
            this.__explicitlySet__.add("ad");
            return this;
        }

        public Builder lifecycleState(LifecycleState lifecycleState) {
            this.lifecycleState = lifecycleState;
            this.__explicitlySet__.add("lifecycleState");
            return this;
        }

        public Peer build() {
            Peer model = new Peer(this.peerKey, this.role, this.alias, this.ocpuAllocationParam, this.host, this.ad, this.lifecycleState);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(Peer model) {
            if (model.wasPropertyExplicitlySet("peerKey")) {
                this.peerKey(model.getPeerKey());
            }
            if (model.wasPropertyExplicitlySet("role")) {
                this.role(model.getRole());
            }
            if (model.wasPropertyExplicitlySet("alias")) {
                this.alias(model.getAlias());
            }
            if (model.wasPropertyExplicitlySet("ocpuAllocationParam")) {
                this.ocpuAllocationParam(model.getOcpuAllocationParam());
            }
            if (model.wasPropertyExplicitlySet("host")) {
                this.host(model.getHost());
            }
            if (model.wasPropertyExplicitlySet("ad")) {
                this.ad(model.getAd());
            }
            if (model.wasPropertyExplicitlySet("lifecycleState")) {
                this.lifecycleState(model.getLifecycleState());
            }
            return this;
        }
    }
}

