/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.blockchain.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.blockchain.model.AvailabilityDomain;
import com.oracle.bmc.blockchain.model.OcpuAllocationNumberParam;
import com.oracle.bmc.blockchain.model.PeerRole;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class CreatePeerDetails
extends ExplicitlySetBmcModel {
    @JsonProperty(value="role")
    private final PeerRole.Role role;
    @JsonProperty(value="alias")
    private final String alias;
    @JsonProperty(value="ocpuAllocationParam")
    private final OcpuAllocationNumberParam ocpuAllocationParam;
    @JsonProperty(value="ad")
    private final AvailabilityDomain.Ads ad;

    @Deprecated
    @ConstructorProperties(value={"role", "alias", "ocpuAllocationParam", "ad"})
    public CreatePeerDetails(PeerRole.Role role, String alias, OcpuAllocationNumberParam ocpuAllocationParam, AvailabilityDomain.Ads ad) {
        this.role = role;
        this.alias = alias;
        this.ocpuAllocationParam = ocpuAllocationParam;
        this.ad = ad;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public PeerRole.Role getRole() {
        return this.role;
    }

    public String getAlias() {
        return this.alias;
    }

    public OcpuAllocationNumberParam getOcpuAllocationParam() {
        return this.ocpuAllocationParam;
    }

    public AvailabilityDomain.Ads getAd() {
        return this.ad;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("CreatePeerDetails(");
        sb.append("super=").append(super.toString());
        sb.append("role=").append(String.valueOf((Object)this.role));
        sb.append(", alias=").append(String.valueOf(this.alias));
        sb.append(", ocpuAllocationParam=").append(String.valueOf((Object)this.ocpuAllocationParam));
        sb.append(", ad=").append(String.valueOf((Object)this.ad));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CreatePeerDetails)) {
            return false;
        }
        CreatePeerDetails other = (CreatePeerDetails)((Object)o);
        return Objects.equals((Object)this.role, (Object)other.role) && Objects.equals(this.alias, other.alias) && Objects.equals((Object)this.ocpuAllocationParam, (Object)other.ocpuAllocationParam) && Objects.equals((Object)this.ad, (Object)other.ad) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.role == null ? 43 : this.role.hashCode());
        result = result * 59 + (this.alias == null ? 43 : this.alias.hashCode());
        result = result * 59 + (this.ocpuAllocationParam == null ? 43 : this.ocpuAllocationParam.hashCode());
        result = result * 59 + (this.ad == null ? 43 : this.ad.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="role")
        private PeerRole.Role role;
        @JsonProperty(value="alias")
        private String alias;
        @JsonProperty(value="ocpuAllocationParam")
        private OcpuAllocationNumberParam ocpuAllocationParam;
        @JsonProperty(value="ad")
        private AvailabilityDomain.Ads ad;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder role(PeerRole.Role role) {
            this.role = role;
            this.__explicitlySet__.add("role");
            return this;
        }

        public Builder alias(String alias) {
            this.alias = alias;
            this.__explicitlySet__.add("alias");
            return this;
        }

        public Builder ocpuAllocationParam(OcpuAllocationNumberParam ocpuAllocationParam) {
            this.ocpuAllocationParam = ocpuAllocationParam;
            this.__explicitlySet__.add("ocpuAllocationParam");
            return this;
        }

        public Builder ad(AvailabilityDomain.Ads ad) {
            this.ad = ad;
            this.__explicitlySet__.add("ad");
            return this;
        }

        public CreatePeerDetails build() {
            CreatePeerDetails model = new CreatePeerDetails(this.role, this.alias, this.ocpuAllocationParam, this.ad);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(CreatePeerDetails model) {
            if (model.wasPropertyExplicitlySet("role")) {
                this.role(model.getRole());
            }
            if (model.wasPropertyExplicitlySet("alias")) {
                this.alias(model.getAlias());
            }
            if (model.wasPropertyExplicitlySet("ocpuAllocationParam")) {
                this.ocpuAllocationParam(model.getOcpuAllocationParam());
            }
            if (model.wasPropertyExplicitlySet("ad")) {
                this.ad(model.getAd());
            }
            return this;
        }
    }
}

