/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.blockchain.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.blockchain.model.BlockchainPlatform;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class CreateBlockchainPlatformDetails
extends ExplicitlySetBmcModel {
    @JsonProperty(value="displayName")
    private final String displayName;
    @JsonProperty(value="compartmentId")
    private final String compartmentId;
    @JsonProperty(value="description")
    private final String description;
    @JsonProperty(value="platformRole")
    private final BlockchainPlatform.PlatformRole platformRole;
    @JsonProperty(value="computeShape")
    private final BlockchainPlatform.ComputeShape computeShape;
    @JsonProperty(value="isByol")
    private final Boolean isByol;
    @JsonProperty(value="platformVersion")
    private final String platformVersion;
    @JsonProperty(value="idcsAccessToken")
    private final String idcsAccessToken;
    @JsonProperty(value="federatedUserId")
    private final String federatedUserId;
    @JsonProperty(value="caCertArchiveText")
    private final String caCertArchiveText;
    @JsonProperty(value="freeformTags")
    private final Map<String, String> freeformTags;
    @JsonProperty(value="definedTags")
    private final Map<String, Map<String, Object>> definedTags;

    @Deprecated
    @ConstructorProperties(value={"displayName", "compartmentId", "description", "platformRole", "computeShape", "isByol", "platformVersion", "idcsAccessToken", "federatedUserId", "caCertArchiveText", "freeformTags", "definedTags"})
    public CreateBlockchainPlatformDetails(String displayName, String compartmentId, String description, BlockchainPlatform.PlatformRole platformRole, BlockchainPlatform.ComputeShape computeShape, Boolean isByol, String platformVersion, String idcsAccessToken, String federatedUserId, String caCertArchiveText, Map<String, String> freeformTags, Map<String, Map<String, Object>> definedTags) {
        this.displayName = displayName;
        this.compartmentId = compartmentId;
        this.description = description;
        this.platformRole = platformRole;
        this.computeShape = computeShape;
        this.isByol = isByol;
        this.platformVersion = platformVersion;
        this.idcsAccessToken = idcsAccessToken;
        this.federatedUserId = federatedUserId;
        this.caCertArchiveText = caCertArchiveText;
        this.freeformTags = freeformTags;
        this.definedTags = definedTags;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public String getDescription() {
        return this.description;
    }

    public BlockchainPlatform.PlatformRole getPlatformRole() {
        return this.platformRole;
    }

    public BlockchainPlatform.ComputeShape getComputeShape() {
        return this.computeShape;
    }

    public Boolean getIsByol() {
        return this.isByol;
    }

    public String getPlatformVersion() {
        return this.platformVersion;
    }

    public String getIdcsAccessToken() {
        return this.idcsAccessToken;
    }

    public String getFederatedUserId() {
        return this.federatedUserId;
    }

    public String getCaCertArchiveText() {
        return this.caCertArchiveText;
    }

    public Map<String, String> getFreeformTags() {
        return this.freeformTags;
    }

    public Map<String, Map<String, Object>> getDefinedTags() {
        return this.definedTags;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("CreateBlockchainPlatformDetails(");
        sb.append("super=").append(super.toString());
        sb.append("displayName=").append(String.valueOf(this.displayName));
        sb.append(", compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(", description=").append(String.valueOf(this.description));
        sb.append(", platformRole=").append(String.valueOf((Object)this.platformRole));
        sb.append(", computeShape=").append(String.valueOf((Object)this.computeShape));
        sb.append(", isByol=").append(String.valueOf(this.isByol));
        sb.append(", platformVersion=").append(String.valueOf(this.platformVersion));
        sb.append(", idcsAccessToken=").append(String.valueOf(this.idcsAccessToken));
        sb.append(", federatedUserId=").append(String.valueOf(this.federatedUserId));
        sb.append(", caCertArchiveText=").append(String.valueOf(this.caCertArchiveText));
        sb.append(", freeformTags=").append(String.valueOf(this.freeformTags));
        sb.append(", definedTags=").append(String.valueOf(this.definedTags));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CreateBlockchainPlatformDetails)) {
            return false;
        }
        CreateBlockchainPlatformDetails other = (CreateBlockchainPlatformDetails)((Object)o);
        return Objects.equals(this.displayName, other.displayName) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals(this.description, other.description) && Objects.equals((Object)this.platformRole, (Object)other.platformRole) && Objects.equals((Object)this.computeShape, (Object)other.computeShape) && Objects.equals(this.isByol, other.isByol) && Objects.equals(this.platformVersion, other.platformVersion) && Objects.equals(this.idcsAccessToken, other.idcsAccessToken) && Objects.equals(this.federatedUserId, other.federatedUserId) && Objects.equals(this.caCertArchiveText, other.caCertArchiveText) && Objects.equals(this.freeformTags, other.freeformTags) && Objects.equals(this.definedTags, other.definedTags) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.displayName == null ? 43 : this.displayName.hashCode());
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.description == null ? 43 : this.description.hashCode());
        result = result * 59 + (this.platformRole == null ? 43 : this.platformRole.hashCode());
        result = result * 59 + (this.computeShape == null ? 43 : this.computeShape.hashCode());
        result = result * 59 + (this.isByol == null ? 43 : this.isByol.hashCode());
        result = result * 59 + (this.platformVersion == null ? 43 : this.platformVersion.hashCode());
        result = result * 59 + (this.idcsAccessToken == null ? 43 : this.idcsAccessToken.hashCode());
        result = result * 59 + (this.federatedUserId == null ? 43 : this.federatedUserId.hashCode());
        result = result * 59 + (this.caCertArchiveText == null ? 43 : this.caCertArchiveText.hashCode());
        result = result * 59 + (this.freeformTags == null ? 43 : this.freeformTags.hashCode());
        result = result * 59 + (this.definedTags == null ? 43 : this.definedTags.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="displayName")
        private String displayName;
        @JsonProperty(value="compartmentId")
        private String compartmentId;
        @JsonProperty(value="description")
        private String description;
        @JsonProperty(value="platformRole")
        private BlockchainPlatform.PlatformRole platformRole;
        @JsonProperty(value="computeShape")
        private BlockchainPlatform.ComputeShape computeShape;
        @JsonProperty(value="isByol")
        private Boolean isByol;
        @JsonProperty(value="platformVersion")
        private String platformVersion;
        @JsonProperty(value="idcsAccessToken")
        private String idcsAccessToken;
        @JsonProperty(value="federatedUserId")
        private String federatedUserId;
        @JsonProperty(value="caCertArchiveText")
        private String caCertArchiveText;
        @JsonProperty(value="freeformTags")
        private Map<String, String> freeformTags;
        @JsonProperty(value="definedTags")
        private Map<String, Map<String, Object>> definedTags;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.__explicitlySet__.add("displayName");
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            this.__explicitlySet__.add("compartmentId");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.__explicitlySet__.add("description");
            return this;
        }

        public Builder platformRole(BlockchainPlatform.PlatformRole platformRole) {
            this.platformRole = platformRole;
            this.__explicitlySet__.add("platformRole");
            return this;
        }

        public Builder computeShape(BlockchainPlatform.ComputeShape computeShape) {
            this.computeShape = computeShape;
            this.__explicitlySet__.add("computeShape");
            return this;
        }

        public Builder isByol(Boolean isByol) {
            this.isByol = isByol;
            this.__explicitlySet__.add("isByol");
            return this;
        }

        public Builder platformVersion(String platformVersion) {
            this.platformVersion = platformVersion;
            this.__explicitlySet__.add("platformVersion");
            return this;
        }

        public Builder idcsAccessToken(String idcsAccessToken) {
            this.idcsAccessToken = idcsAccessToken;
            this.__explicitlySet__.add("idcsAccessToken");
            return this;
        }

        public Builder federatedUserId(String federatedUserId) {
            this.federatedUserId = federatedUserId;
            this.__explicitlySet__.add("federatedUserId");
            return this;
        }

        public Builder caCertArchiveText(String caCertArchiveText) {
            this.caCertArchiveText = caCertArchiveText;
            this.__explicitlySet__.add("caCertArchiveText");
            return this;
        }

        public Builder freeformTags(Map<String, String> freeformTags) {
            this.freeformTags = freeformTags;
            this.__explicitlySet__.add("freeformTags");
            return this;
        }

        public Builder definedTags(Map<String, Map<String, Object>> definedTags) {
            this.definedTags = definedTags;
            this.__explicitlySet__.add("definedTags");
            return this;
        }

        public CreateBlockchainPlatformDetails build() {
            CreateBlockchainPlatformDetails model = new CreateBlockchainPlatformDetails(this.displayName, this.compartmentId, this.description, this.platformRole, this.computeShape, this.isByol, this.platformVersion, this.idcsAccessToken, this.federatedUserId, this.caCertArchiveText, this.freeformTags, this.definedTags);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(CreateBlockchainPlatformDetails model) {
            if (model.wasPropertyExplicitlySet("displayName")) {
                this.displayName(model.getDisplayName());
            }
            if (model.wasPropertyExplicitlySet("compartmentId")) {
                this.compartmentId(model.getCompartmentId());
            }
            if (model.wasPropertyExplicitlySet("description")) {
                this.description(model.getDescription());
            }
            if (model.wasPropertyExplicitlySet("platformRole")) {
                this.platformRole(model.getPlatformRole());
            }
            if (model.wasPropertyExplicitlySet("computeShape")) {
                this.computeShape(model.getComputeShape());
            }
            if (model.wasPropertyExplicitlySet("isByol")) {
                this.isByol(model.getIsByol());
            }
            if (model.wasPropertyExplicitlySet("platformVersion")) {
                this.platformVersion(model.getPlatformVersion());
            }
            if (model.wasPropertyExplicitlySet("idcsAccessToken")) {
                this.idcsAccessToken(model.getIdcsAccessToken());
            }
            if (model.wasPropertyExplicitlySet("federatedUserId")) {
                this.federatedUserId(model.getFederatedUserId());
            }
            if (model.wasPropertyExplicitlySet("caCertArchiveText")) {
                this.caCertArchiveText(model.getCaCertArchiveText());
            }
            if (model.wasPropertyExplicitlySet("freeformTags")) {
                this.freeformTags(model.getFreeformTags());
            }
            if (model.wasPropertyExplicitlySet("definedTags")) {
                this.definedTags(model.getDefinedTags());
            }
            return this;
        }
    }
}

