/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.blockchain.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class BlockchainPlatformPatchSummary
extends ExplicitlySetBmcModel {
    @JsonProperty(value="id")
    private final String id;
    @JsonProperty(value="serviceVersion")
    private final String serviceVersion;
    @JsonProperty(value="patchInfoUrl")
    private final String patchInfoUrl;
    @JsonProperty(value="timePatchDue")
    private final Date timePatchDue;

    @Deprecated
    @ConstructorProperties(value={"id", "serviceVersion", "patchInfoUrl", "timePatchDue"})
    public BlockchainPlatformPatchSummary(String id, String serviceVersion, String patchInfoUrl, Date timePatchDue) {
        this.id = id;
        this.serviceVersion = serviceVersion;
        this.patchInfoUrl = patchInfoUrl;
        this.timePatchDue = timePatchDue;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getId() {
        return this.id;
    }

    public String getServiceVersion() {
        return this.serviceVersion;
    }

    public String getPatchInfoUrl() {
        return this.patchInfoUrl;
    }

    public Date getTimePatchDue() {
        return this.timePatchDue;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("BlockchainPlatformPatchSummary(");
        sb.append("super=").append(super.toString());
        sb.append("id=").append(String.valueOf(this.id));
        sb.append(", serviceVersion=").append(String.valueOf(this.serviceVersion));
        sb.append(", patchInfoUrl=").append(String.valueOf(this.patchInfoUrl));
        sb.append(", timePatchDue=").append(String.valueOf(this.timePatchDue));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BlockchainPlatformPatchSummary)) {
            return false;
        }
        BlockchainPlatformPatchSummary other = (BlockchainPlatformPatchSummary)((Object)o);
        return Objects.equals(this.id, other.id) && Objects.equals(this.serviceVersion, other.serviceVersion) && Objects.equals(this.patchInfoUrl, other.patchInfoUrl) && Objects.equals(this.timePatchDue, other.timePatchDue) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.id == null ? 43 : this.id.hashCode());
        result = result * 59 + (this.serviceVersion == null ? 43 : this.serviceVersion.hashCode());
        result = result * 59 + (this.patchInfoUrl == null ? 43 : this.patchInfoUrl.hashCode());
        result = result * 59 + (this.timePatchDue == null ? 43 : this.timePatchDue.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="id")
        private String id;
        @JsonProperty(value="serviceVersion")
        private String serviceVersion;
        @JsonProperty(value="patchInfoUrl")
        private String patchInfoUrl;
        @JsonProperty(value="timePatchDue")
        private Date timePatchDue;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder id(String id) {
            this.id = id;
            this.__explicitlySet__.add("id");
            return this;
        }

        public Builder serviceVersion(String serviceVersion) {
            this.serviceVersion = serviceVersion;
            this.__explicitlySet__.add("serviceVersion");
            return this;
        }

        public Builder patchInfoUrl(String patchInfoUrl) {
            this.patchInfoUrl = patchInfoUrl;
            this.__explicitlySet__.add("patchInfoUrl");
            return this;
        }

        public Builder timePatchDue(Date timePatchDue) {
            this.timePatchDue = timePatchDue;
            this.__explicitlySet__.add("timePatchDue");
            return this;
        }

        public BlockchainPlatformPatchSummary build() {
            BlockchainPlatformPatchSummary model = new BlockchainPlatformPatchSummary(this.id, this.serviceVersion, this.patchInfoUrl, this.timePatchDue);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(BlockchainPlatformPatchSummary model) {
            if (model.wasPropertyExplicitlySet("id")) {
                this.id(model.getId());
            }
            if (model.wasPropertyExplicitlySet("serviceVersion")) {
                this.serviceVersion(model.getServiceVersion());
            }
            if (model.wasPropertyExplicitlySet("patchInfoUrl")) {
                this.patchInfoUrl(model.getPatchInfoUrl());
            }
            if (model.wasPropertyExplicitlySet("timePatchDue")) {
                this.timePatchDue(model.getTimePatchDue());
            }
            return this;
        }
    }
}

