/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.bds.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.bds.model.TestBdsObjectStorageConnectionDetails;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class TestBdsObjectStorageConnectionRequest
extends BmcRequest<TestBdsObjectStorageConnectionDetails> {
    private String bdsInstanceId;
    private String apiKeyId;
    private TestBdsObjectStorageConnectionDetails testBdsObjectStorageConnectionDetails;
    private String opcRequestId;

    public String getBdsInstanceId() {
        return this.bdsInstanceId;
    }

    public String getApiKeyId() {
        return this.apiKeyId;
    }

    public TestBdsObjectStorageConnectionDetails getTestBdsObjectStorageConnectionDetails() {
        return this.testBdsObjectStorageConnectionDetails;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    @InternalSdk
    public TestBdsObjectStorageConnectionDetails getBody$() {
        return this.testBdsObjectStorageConnectionDetails;
    }

    public Builder toBuilder() {
        return new Builder().bdsInstanceId(this.bdsInstanceId).apiKeyId(this.apiKeyId).testBdsObjectStorageConnectionDetails(this.testBdsObjectStorageConnectionDetails).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",bdsInstanceId=").append(String.valueOf(this.bdsInstanceId));
        sb.append(",apiKeyId=").append(String.valueOf(this.apiKeyId));
        sb.append(",testBdsObjectStorageConnectionDetails=").append(String.valueOf((Object)this.testBdsObjectStorageConnectionDetails));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TestBdsObjectStorageConnectionRequest)) {
            return false;
        }
        TestBdsObjectStorageConnectionRequest other = (TestBdsObjectStorageConnectionRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.bdsInstanceId, other.bdsInstanceId) && Objects.equals(this.apiKeyId, other.apiKeyId) && Objects.equals((Object)this.testBdsObjectStorageConnectionDetails, (Object)other.testBdsObjectStorageConnectionDetails) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.bdsInstanceId == null ? 43 : this.bdsInstanceId.hashCode());
        result = result * 59 + (this.apiKeyId == null ? 43 : this.apiKeyId.hashCode());
        result = result * 59 + (this.testBdsObjectStorageConnectionDetails == null ? 43 : this.testBdsObjectStorageConnectionDetails.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<TestBdsObjectStorageConnectionRequest, TestBdsObjectStorageConnectionDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String bdsInstanceId = null;
        private String apiKeyId = null;
        private TestBdsObjectStorageConnectionDetails testBdsObjectStorageConnectionDetails = null;
        private String opcRequestId = null;

        public Builder bdsInstanceId(String bdsInstanceId) {
            this.bdsInstanceId = bdsInstanceId;
            return this;
        }

        public Builder apiKeyId(String apiKeyId) {
            this.apiKeyId = apiKeyId;
            return this;
        }

        public Builder testBdsObjectStorageConnectionDetails(TestBdsObjectStorageConnectionDetails testBdsObjectStorageConnectionDetails) {
            this.testBdsObjectStorageConnectionDetails = testBdsObjectStorageConnectionDetails;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(TestBdsObjectStorageConnectionRequest o) {
            this.bdsInstanceId(o.getBdsInstanceId());
            this.apiKeyId(o.getApiKeyId());
            this.testBdsObjectStorageConnectionDetails(o.getTestBdsObjectStorageConnectionDetails());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public TestBdsObjectStorageConnectionRequest build() {
            TestBdsObjectStorageConnectionRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(TestBdsObjectStorageConnectionDetails body) {
            this.testBdsObjectStorageConnectionDetails(body);
            return this;
        }

        public TestBdsObjectStorageConnectionRequest buildWithoutInvocationCallback() {
            TestBdsObjectStorageConnectionRequest request = new TestBdsObjectStorageConnectionRequest();
            request.bdsInstanceId = this.bdsInstanceId;
            request.apiKeyId = this.apiKeyId;
            request.testBdsObjectStorageConnectionDetails = this.testBdsObjectStorageConnectionDetails;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

