/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.bds.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.bds.model.StopBdsInstanceDetails;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class StopBdsInstanceRequest
extends BmcRequest<StopBdsInstanceDetails> {
    private String bdsInstanceId;
    private StopBdsInstanceDetails stopBdsInstanceDetails;
    private String opcRequestId;
    private String ifMatch;

    public String getBdsInstanceId() {
        return this.bdsInstanceId;
    }

    public StopBdsInstanceDetails getStopBdsInstanceDetails() {
        return this.stopBdsInstanceDetails;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    @InternalSdk
    public StopBdsInstanceDetails getBody$() {
        return this.stopBdsInstanceDetails;
    }

    public Builder toBuilder() {
        return new Builder().bdsInstanceId(this.bdsInstanceId).stopBdsInstanceDetails(this.stopBdsInstanceDetails).opcRequestId(this.opcRequestId).ifMatch(this.ifMatch);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",bdsInstanceId=").append(String.valueOf(this.bdsInstanceId));
        sb.append(",stopBdsInstanceDetails=").append(String.valueOf((Object)this.stopBdsInstanceDetails));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",ifMatch=").append(String.valueOf(this.ifMatch));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof StopBdsInstanceRequest)) {
            return false;
        }
        StopBdsInstanceRequest other = (StopBdsInstanceRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.bdsInstanceId, other.bdsInstanceId) && Objects.equals((Object)this.stopBdsInstanceDetails, (Object)other.stopBdsInstanceDetails) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.ifMatch, other.ifMatch);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.bdsInstanceId == null ? 43 : this.bdsInstanceId.hashCode());
        result = result * 59 + (this.stopBdsInstanceDetails == null ? 43 : this.stopBdsInstanceDetails.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.ifMatch == null ? 43 : this.ifMatch.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<StopBdsInstanceRequest, StopBdsInstanceDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String bdsInstanceId = null;
        private StopBdsInstanceDetails stopBdsInstanceDetails = null;
        private String opcRequestId = null;
        private String ifMatch = null;

        public Builder bdsInstanceId(String bdsInstanceId) {
            this.bdsInstanceId = bdsInstanceId;
            return this;
        }

        public Builder stopBdsInstanceDetails(StopBdsInstanceDetails stopBdsInstanceDetails) {
            this.stopBdsInstanceDetails = stopBdsInstanceDetails;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(StopBdsInstanceRequest o) {
            this.bdsInstanceId(o.getBdsInstanceId());
            this.stopBdsInstanceDetails(o.getStopBdsInstanceDetails());
            this.opcRequestId(o.getOpcRequestId());
            this.ifMatch(o.getIfMatch());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public StopBdsInstanceRequest build() {
            StopBdsInstanceRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(StopBdsInstanceDetails body) {
            this.stopBdsInstanceDetails(body);
            return this;
        }

        public StopBdsInstanceRequest buildWithoutInvocationCallback() {
            StopBdsInstanceRequest request = new StopBdsInstanceRequest();
            request.bdsInstanceId = this.bdsInstanceId;
            request.stopBdsInstanceDetails = this.stopBdsInstanceDetails;
            request.opcRequestId = this.opcRequestId;
            request.ifMatch = this.ifMatch;
            return request;
        }
    }
}

