/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.bds.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class GetBdsMetastoreConfigurationRequest
extends BmcRequest<Void> {
    private String bdsInstanceId;
    private String metastoreConfigId;
    private String opcRequestId;

    public String getBdsInstanceId() {
        return this.bdsInstanceId;
    }

    public String getMetastoreConfigId() {
        return this.metastoreConfigId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().bdsInstanceId(this.bdsInstanceId).metastoreConfigId(this.metastoreConfigId).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",bdsInstanceId=").append(String.valueOf(this.bdsInstanceId));
        sb.append(",metastoreConfigId=").append(String.valueOf(this.metastoreConfigId));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetBdsMetastoreConfigurationRequest)) {
            return false;
        }
        GetBdsMetastoreConfigurationRequest other = (GetBdsMetastoreConfigurationRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.bdsInstanceId, other.bdsInstanceId) && Objects.equals(this.metastoreConfigId, other.metastoreConfigId) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.bdsInstanceId == null ? 43 : this.bdsInstanceId.hashCode());
        result = result * 59 + (this.metastoreConfigId == null ? 43 : this.metastoreConfigId.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<GetBdsMetastoreConfigurationRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String bdsInstanceId = null;
        private String metastoreConfigId = null;
        private String opcRequestId = null;

        public Builder bdsInstanceId(String bdsInstanceId) {
            this.bdsInstanceId = bdsInstanceId;
            return this;
        }

        public Builder metastoreConfigId(String metastoreConfigId) {
            this.metastoreConfigId = metastoreConfigId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetBdsMetastoreConfigurationRequest o) {
            this.bdsInstanceId(o.getBdsInstanceId());
            this.metastoreConfigId(o.getMetastoreConfigId());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetBdsMetastoreConfigurationRequest build() {
            GetBdsMetastoreConfigurationRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public GetBdsMetastoreConfigurationRequest buildWithoutInvocationCallback() {
            GetBdsMetastoreConfigurationRequest request = new GetBdsMetastoreConfigurationRequest();
            request.bdsInstanceId = this.bdsInstanceId;
            request.metastoreConfigId = this.metastoreConfigId;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

