/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.bds.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.bds.model.AutoScalePolicyMetricRule;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class MetricBasedVerticalScaleUpConfig
extends ExplicitlySetBmcModel {
    @JsonProperty(value="metric")
    private final AutoScalePolicyMetricRule metric;
    @JsonProperty(value="maxOcpusPerNode")
    private final Integer maxOcpusPerNode;
    @JsonProperty(value="maxMemoryPerNode")
    private final Integer maxMemoryPerNode;
    @JsonProperty(value="ocpuStepSize")
    private final Integer ocpuStepSize;
    @JsonProperty(value="memoryStepSize")
    private final Integer memoryStepSize;

    @Deprecated
    @ConstructorProperties(value={"metric", "maxOcpusPerNode", "maxMemoryPerNode", "ocpuStepSize", "memoryStepSize"})
    public MetricBasedVerticalScaleUpConfig(AutoScalePolicyMetricRule metric, Integer maxOcpusPerNode, Integer maxMemoryPerNode, Integer ocpuStepSize, Integer memoryStepSize) {
        this.metric = metric;
        this.maxOcpusPerNode = maxOcpusPerNode;
        this.maxMemoryPerNode = maxMemoryPerNode;
        this.ocpuStepSize = ocpuStepSize;
        this.memoryStepSize = memoryStepSize;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public AutoScalePolicyMetricRule getMetric() {
        return this.metric;
    }

    public Integer getMaxOcpusPerNode() {
        return this.maxOcpusPerNode;
    }

    public Integer getMaxMemoryPerNode() {
        return this.maxMemoryPerNode;
    }

    public Integer getOcpuStepSize() {
        return this.ocpuStepSize;
    }

    public Integer getMemoryStepSize() {
        return this.memoryStepSize;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("MetricBasedVerticalScaleUpConfig(");
        sb.append("super=").append(super.toString());
        sb.append("metric=").append(String.valueOf((Object)this.metric));
        sb.append(", maxOcpusPerNode=").append(String.valueOf(this.maxOcpusPerNode));
        sb.append(", maxMemoryPerNode=").append(String.valueOf(this.maxMemoryPerNode));
        sb.append(", ocpuStepSize=").append(String.valueOf(this.ocpuStepSize));
        sb.append(", memoryStepSize=").append(String.valueOf(this.memoryStepSize));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MetricBasedVerticalScaleUpConfig)) {
            return false;
        }
        MetricBasedVerticalScaleUpConfig other = (MetricBasedVerticalScaleUpConfig)((Object)o);
        return Objects.equals((Object)this.metric, (Object)other.metric) && Objects.equals(this.maxOcpusPerNode, other.maxOcpusPerNode) && Objects.equals(this.maxMemoryPerNode, other.maxMemoryPerNode) && Objects.equals(this.ocpuStepSize, other.ocpuStepSize) && Objects.equals(this.memoryStepSize, other.memoryStepSize) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.metric == null ? 43 : this.metric.hashCode());
        result = result * 59 + (this.maxOcpusPerNode == null ? 43 : this.maxOcpusPerNode.hashCode());
        result = result * 59 + (this.maxMemoryPerNode == null ? 43 : this.maxMemoryPerNode.hashCode());
        result = result * 59 + (this.ocpuStepSize == null ? 43 : this.ocpuStepSize.hashCode());
        result = result * 59 + (this.memoryStepSize == null ? 43 : this.memoryStepSize.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="metric")
        private AutoScalePolicyMetricRule metric;
        @JsonProperty(value="maxOcpusPerNode")
        private Integer maxOcpusPerNode;
        @JsonProperty(value="maxMemoryPerNode")
        private Integer maxMemoryPerNode;
        @JsonProperty(value="ocpuStepSize")
        private Integer ocpuStepSize;
        @JsonProperty(value="memoryStepSize")
        private Integer memoryStepSize;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder metric(AutoScalePolicyMetricRule metric) {
            this.metric = metric;
            this.__explicitlySet__.add("metric");
            return this;
        }

        public Builder maxOcpusPerNode(Integer maxOcpusPerNode) {
            this.maxOcpusPerNode = maxOcpusPerNode;
            this.__explicitlySet__.add("maxOcpusPerNode");
            return this;
        }

        public Builder maxMemoryPerNode(Integer maxMemoryPerNode) {
            this.maxMemoryPerNode = maxMemoryPerNode;
            this.__explicitlySet__.add("maxMemoryPerNode");
            return this;
        }

        public Builder ocpuStepSize(Integer ocpuStepSize) {
            this.ocpuStepSize = ocpuStepSize;
            this.__explicitlySet__.add("ocpuStepSize");
            return this;
        }

        public Builder memoryStepSize(Integer memoryStepSize) {
            this.memoryStepSize = memoryStepSize;
            this.__explicitlySet__.add("memoryStepSize");
            return this;
        }

        public MetricBasedVerticalScaleUpConfig build() {
            MetricBasedVerticalScaleUpConfig model = new MetricBasedVerticalScaleUpConfig(this.metric, this.maxOcpusPerNode, this.maxMemoryPerNode, this.ocpuStepSize, this.memoryStepSize);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(MetricBasedVerticalScaleUpConfig model) {
            if (model.wasPropertyExplicitlySet("metric")) {
                this.metric(model.getMetric());
            }
            if (model.wasPropertyExplicitlySet("maxOcpusPerNode")) {
                this.maxOcpusPerNode(model.getMaxOcpusPerNode());
            }
            if (model.wasPropertyExplicitlySet("maxMemoryPerNode")) {
                this.maxMemoryPerNode(model.getMaxMemoryPerNode());
            }
            if (model.wasPropertyExplicitlySet("ocpuStepSize")) {
                this.ocpuStepSize(model.getOcpuStepSize());
            }
            if (model.wasPropertyExplicitlySet("memoryStepSize")) {
                this.memoryStepSize(model.getMemoryStepSize());
            }
            return this;
        }
    }
}

