/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.bds.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class BdsApiKey
extends ExplicitlySetBmcModel {
    @JsonProperty(value="id")
    private final String id;
    @JsonProperty(value="userId")
    private final String userId;
    @JsonProperty(value="keyAlias")
    private final String keyAlias;
    @JsonProperty(value="defaultRegion")
    private final String defaultRegion;
    @JsonProperty(value="tenantId")
    private final String tenantId;
    @JsonProperty(value="fingerprint")
    private final String fingerprint;
    @JsonProperty(value="pemfilepath")
    private final String pemfilepath;
    @JsonProperty(value="timeCreated")
    private final Date timeCreated;
    @JsonProperty(value="lifecycleState")
    private final LifecycleState lifecycleState;

    @Deprecated
    @ConstructorProperties(value={"id", "userId", "keyAlias", "defaultRegion", "tenantId", "fingerprint", "pemfilepath", "timeCreated", "lifecycleState"})
    public BdsApiKey(String id, String userId, String keyAlias, String defaultRegion, String tenantId, String fingerprint, String pemfilepath, Date timeCreated, LifecycleState lifecycleState) {
        this.id = id;
        this.userId = userId;
        this.keyAlias = keyAlias;
        this.defaultRegion = defaultRegion;
        this.tenantId = tenantId;
        this.fingerprint = fingerprint;
        this.pemfilepath = pemfilepath;
        this.timeCreated = timeCreated;
        this.lifecycleState = lifecycleState;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getId() {
        return this.id;
    }

    public String getUserId() {
        return this.userId;
    }

    public String getKeyAlias() {
        return this.keyAlias;
    }

    public String getDefaultRegion() {
        return this.defaultRegion;
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public String getFingerprint() {
        return this.fingerprint;
    }

    public String getPemfilepath() {
        return this.pemfilepath;
    }

    public Date getTimeCreated() {
        return this.timeCreated;
    }

    public LifecycleState getLifecycleState() {
        return this.lifecycleState;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("BdsApiKey(");
        sb.append("super=").append(super.toString());
        sb.append("id=").append(String.valueOf(this.id));
        sb.append(", userId=").append(String.valueOf(this.userId));
        sb.append(", keyAlias=").append(String.valueOf(this.keyAlias));
        sb.append(", defaultRegion=").append(String.valueOf(this.defaultRegion));
        sb.append(", tenantId=").append(String.valueOf(this.tenantId));
        sb.append(", fingerprint=").append(String.valueOf(this.fingerprint));
        sb.append(", pemfilepath=").append(String.valueOf(this.pemfilepath));
        sb.append(", timeCreated=").append(String.valueOf(this.timeCreated));
        sb.append(", lifecycleState=").append(String.valueOf((Object)this.lifecycleState));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BdsApiKey)) {
            return false;
        }
        BdsApiKey other = (BdsApiKey)((Object)o);
        return Objects.equals(this.id, other.id) && Objects.equals(this.userId, other.userId) && Objects.equals(this.keyAlias, other.keyAlias) && Objects.equals(this.defaultRegion, other.defaultRegion) && Objects.equals(this.tenantId, other.tenantId) && Objects.equals(this.fingerprint, other.fingerprint) && Objects.equals(this.pemfilepath, other.pemfilepath) && Objects.equals(this.timeCreated, other.timeCreated) && Objects.equals((Object)this.lifecycleState, (Object)other.lifecycleState) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.id == null ? 43 : this.id.hashCode());
        result = result * 59 + (this.userId == null ? 43 : this.userId.hashCode());
        result = result * 59 + (this.keyAlias == null ? 43 : this.keyAlias.hashCode());
        result = result * 59 + (this.defaultRegion == null ? 43 : this.defaultRegion.hashCode());
        result = result * 59 + (this.tenantId == null ? 43 : this.tenantId.hashCode());
        result = result * 59 + (this.fingerprint == null ? 43 : this.fingerprint.hashCode());
        result = result * 59 + (this.pemfilepath == null ? 43 : this.pemfilepath.hashCode());
        result = result * 59 + (this.timeCreated == null ? 43 : this.timeCreated.hashCode());
        result = result * 59 + (this.lifecycleState == null ? 43 : this.lifecycleState.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum LifecycleState implements BmcEnum
    {
        Creating("CREATING"),
        Active("ACTIVE"),
        Deleting("DELETING"),
        Deleted("DELETED"),
        Failed("FAILED"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, LifecycleState> map;

        private LifecycleState(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static LifecycleState create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'LifecycleState', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(LifecycleState.class);
            map = new HashMap<String, LifecycleState>();
            for (LifecycleState v : LifecycleState.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="id")
        private String id;
        @JsonProperty(value="userId")
        private String userId;
        @JsonProperty(value="keyAlias")
        private String keyAlias;
        @JsonProperty(value="defaultRegion")
        private String defaultRegion;
        @JsonProperty(value="tenantId")
        private String tenantId;
        @JsonProperty(value="fingerprint")
        private String fingerprint;
        @JsonProperty(value="pemfilepath")
        private String pemfilepath;
        @JsonProperty(value="timeCreated")
        private Date timeCreated;
        @JsonProperty(value="lifecycleState")
        private LifecycleState lifecycleState;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder id(String id) {
            this.id = id;
            this.__explicitlySet__.add("id");
            return this;
        }

        public Builder userId(String userId) {
            this.userId = userId;
            this.__explicitlySet__.add("userId");
            return this;
        }

        public Builder keyAlias(String keyAlias) {
            this.keyAlias = keyAlias;
            this.__explicitlySet__.add("keyAlias");
            return this;
        }

        public Builder defaultRegion(String defaultRegion) {
            this.defaultRegion = defaultRegion;
            this.__explicitlySet__.add("defaultRegion");
            return this;
        }

        public Builder tenantId(String tenantId) {
            this.tenantId = tenantId;
            this.__explicitlySet__.add("tenantId");
            return this;
        }

        public Builder fingerprint(String fingerprint) {
            this.fingerprint = fingerprint;
            this.__explicitlySet__.add("fingerprint");
            return this;
        }

        public Builder pemfilepath(String pemfilepath) {
            this.pemfilepath = pemfilepath;
            this.__explicitlySet__.add("pemfilepath");
            return this;
        }

        public Builder timeCreated(Date timeCreated) {
            this.timeCreated = timeCreated;
            this.__explicitlySet__.add("timeCreated");
            return this;
        }

        public Builder lifecycleState(LifecycleState lifecycleState) {
            this.lifecycleState = lifecycleState;
            this.__explicitlySet__.add("lifecycleState");
            return this;
        }

        public BdsApiKey build() {
            BdsApiKey model = new BdsApiKey(this.id, this.userId, this.keyAlias, this.defaultRegion, this.tenantId, this.fingerprint, this.pemfilepath, this.timeCreated, this.lifecycleState);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(BdsApiKey model) {
            if (model.wasPropertyExplicitlySet("id")) {
                this.id(model.getId());
            }
            if (model.wasPropertyExplicitlySet("userId")) {
                this.userId(model.getUserId());
            }
            if (model.wasPropertyExplicitlySet("keyAlias")) {
                this.keyAlias(model.getKeyAlias());
            }
            if (model.wasPropertyExplicitlySet("defaultRegion")) {
                this.defaultRegion(model.getDefaultRegion());
            }
            if (model.wasPropertyExplicitlySet("tenantId")) {
                this.tenantId(model.getTenantId());
            }
            if (model.wasPropertyExplicitlySet("fingerprint")) {
                this.fingerprint(model.getFingerprint());
            }
            if (model.wasPropertyExplicitlySet("pemfilepath")) {
                this.pemfilepath(model.getPemfilepath());
            }
            if (model.wasPropertyExplicitlySet("timeCreated")) {
                this.timeCreated(model.getTimeCreated());
            }
            if (model.wasPropertyExplicitlySet("lifecycleState")) {
                this.lifecycleState(model.getLifecycleState());
            }
            return this;
        }
    }
}

