/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.bds.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.bds.model.AutoScalePolicyMetricRule;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class AutoScalePolicyRule
extends ExplicitlySetBmcModel {
    @JsonProperty(value="action")
    private final Action action;
    @JsonProperty(value="metric")
    private final AutoScalePolicyMetricRule metric;

    @Deprecated
    @ConstructorProperties(value={"action", "metric"})
    public AutoScalePolicyRule(Action action, AutoScalePolicyMetricRule metric) {
        this.action = action;
        this.metric = metric;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public Action getAction() {
        return this.action;
    }

    public AutoScalePolicyMetricRule getMetric() {
        return this.metric;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("AutoScalePolicyRule(");
        sb.append("super=").append(super.toString());
        sb.append("action=").append(String.valueOf((Object)this.action));
        sb.append(", metric=").append(String.valueOf((Object)this.metric));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AutoScalePolicyRule)) {
            return false;
        }
        AutoScalePolicyRule other = (AutoScalePolicyRule)((Object)o);
        return Objects.equals((Object)this.action, (Object)other.action) && Objects.equals((Object)this.metric, (Object)other.metric) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.action == null ? 43 : this.action.hashCode());
        result = result * 59 + (this.metric == null ? 43 : this.metric.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum Action implements BmcEnum
    {
        ChangeShapeScaleUp("CHANGE_SHAPE_SCALE_UP"),
        ChangeShapeScaleDown("CHANGE_SHAPE_SCALE_DOWN"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, Action> map;

        private Action(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Action create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'Action', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(Action.class);
            map = new HashMap<String, Action>();
            for (Action v : Action.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="action")
        private Action action;
        @JsonProperty(value="metric")
        private AutoScalePolicyMetricRule metric;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder action(Action action) {
            this.action = action;
            this.__explicitlySet__.add("action");
            return this;
        }

        public Builder metric(AutoScalePolicyMetricRule metric) {
            this.metric = metric;
            this.__explicitlySet__.add("metric");
            return this;
        }

        public AutoScalePolicyRule build() {
            AutoScalePolicyRule model = new AutoScalePolicyRule(this.action, this.metric);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(AutoScalePolicyRule model) {
            if (model.wasPropertyExplicitlySet("action")) {
                this.action(model.getAction());
            }
            if (model.wasPropertyExplicitlySet("metric")) {
                this.metric(model.getMetric());
            }
            return this;
        }
    }
}

