/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.bds.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.bds.model.ShapeConfigDetails;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class AddCloudSqlDetails
extends ExplicitlySetBmcModel {
    @JsonProperty(value="shape")
    private final String shape;
    @JsonProperty(value="shapeConfig")
    private final ShapeConfigDetails shapeConfig;
    @JsonProperty(value="blockVolumeSizeInGBs")
    private final Long blockVolumeSizeInGBs;
    @JsonProperty(value="clusterAdminPassword")
    private final String clusterAdminPassword;

    @Deprecated
    @ConstructorProperties(value={"shape", "shapeConfig", "blockVolumeSizeInGBs", "clusterAdminPassword"})
    public AddCloudSqlDetails(String shape, ShapeConfigDetails shapeConfig, Long blockVolumeSizeInGBs, String clusterAdminPassword) {
        this.shape = shape;
        this.shapeConfig = shapeConfig;
        this.blockVolumeSizeInGBs = blockVolumeSizeInGBs;
        this.clusterAdminPassword = clusterAdminPassword;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getShape() {
        return this.shape;
    }

    public ShapeConfigDetails getShapeConfig() {
        return this.shapeConfig;
    }

    public Long getBlockVolumeSizeInGBs() {
        return this.blockVolumeSizeInGBs;
    }

    public String getClusterAdminPassword() {
        return this.clusterAdminPassword;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("AddCloudSqlDetails(");
        sb.append("super=").append(super.toString());
        sb.append("shape=").append(String.valueOf(this.shape));
        sb.append(", shapeConfig=").append(String.valueOf((Object)this.shapeConfig));
        sb.append(", blockVolumeSizeInGBs=").append(String.valueOf(this.blockVolumeSizeInGBs));
        sb.append(", clusterAdminPassword=").append("<redacted>");
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AddCloudSqlDetails)) {
            return false;
        }
        AddCloudSqlDetails other = (AddCloudSqlDetails)((Object)o);
        return Objects.equals(this.shape, other.shape) && Objects.equals((Object)this.shapeConfig, (Object)other.shapeConfig) && Objects.equals(this.blockVolumeSizeInGBs, other.blockVolumeSizeInGBs) && Objects.equals(this.clusterAdminPassword, other.clusterAdminPassword) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.shape == null ? 43 : this.shape.hashCode());
        result = result * 59 + (this.shapeConfig == null ? 43 : this.shapeConfig.hashCode());
        result = result * 59 + (this.blockVolumeSizeInGBs == null ? 43 : this.blockVolumeSizeInGBs.hashCode());
        result = result * 59 + (this.clusterAdminPassword == null ? 43 : this.clusterAdminPassword.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="shape")
        private String shape;
        @JsonProperty(value="shapeConfig")
        private ShapeConfigDetails shapeConfig;
        @JsonProperty(value="blockVolumeSizeInGBs")
        private Long blockVolumeSizeInGBs;
        @JsonProperty(value="clusterAdminPassword")
        private String clusterAdminPassword;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder shape(String shape) {
            this.shape = shape;
            this.__explicitlySet__.add("shape");
            return this;
        }

        public Builder shapeConfig(ShapeConfigDetails shapeConfig) {
            this.shapeConfig = shapeConfig;
            this.__explicitlySet__.add("shapeConfig");
            return this;
        }

        public Builder blockVolumeSizeInGBs(Long blockVolumeSizeInGBs) {
            this.blockVolumeSizeInGBs = blockVolumeSizeInGBs;
            this.__explicitlySet__.add("blockVolumeSizeInGBs");
            return this;
        }

        public Builder clusterAdminPassword(String clusterAdminPassword) {
            this.clusterAdminPassword = clusterAdminPassword;
            this.__explicitlySet__.add("clusterAdminPassword");
            return this;
        }

        public AddCloudSqlDetails build() {
            AddCloudSqlDetails model = new AddCloudSqlDetails(this.shape, this.shapeConfig, this.blockVolumeSizeInGBs, this.clusterAdminPassword);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(AddCloudSqlDetails model) {
            if (model.wasPropertyExplicitlySet("shape")) {
                this.shape(model.getShape());
            }
            if (model.wasPropertyExplicitlySet("shapeConfig")) {
                this.shapeConfig(model.getShapeConfig());
            }
            if (model.wasPropertyExplicitlySet("blockVolumeSizeInGBs")) {
                this.blockVolumeSizeInGBs(model.getBlockVolumeSizeInGBs());
            }
            if (model.wasPropertyExplicitlySet("clusterAdminPassword")) {
                this.clusterAdminPassword(model.getClusterAdminPassword());
            }
            return this;
        }
    }
}

