/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.bds;

import com.oracle.bmc.bds.Bds;
import com.oracle.bmc.bds.model.AutoScalingConfigurationSummary;
import com.oracle.bmc.bds.model.BdsApiKeySummary;
import com.oracle.bmc.bds.model.BdsInstanceSummary;
import com.oracle.bmc.bds.model.BdsMetastoreConfigurationSummary;
import com.oracle.bmc.bds.model.PatchHistorySummary;
import com.oracle.bmc.bds.model.PatchSummary;
import com.oracle.bmc.bds.model.WorkRequest;
import com.oracle.bmc.bds.model.WorkRequestError;
import com.oracle.bmc.bds.model.WorkRequestLogEntry;
import com.oracle.bmc.bds.requests.ListAutoScalingConfigurationsRequest;
import com.oracle.bmc.bds.requests.ListBdsApiKeysRequest;
import com.oracle.bmc.bds.requests.ListBdsInstancesRequest;
import com.oracle.bmc.bds.requests.ListBdsMetastoreConfigurationsRequest;
import com.oracle.bmc.bds.requests.ListPatchHistoriesRequest;
import com.oracle.bmc.bds.requests.ListPatchesRequest;
import com.oracle.bmc.bds.requests.ListWorkRequestErrorsRequest;
import com.oracle.bmc.bds.requests.ListWorkRequestLogsRequest;
import com.oracle.bmc.bds.requests.ListWorkRequestsRequest;
import com.oracle.bmc.bds.responses.ListAutoScalingConfigurationsResponse;
import com.oracle.bmc.bds.responses.ListBdsApiKeysResponse;
import com.oracle.bmc.bds.responses.ListBdsInstancesResponse;
import com.oracle.bmc.bds.responses.ListBdsMetastoreConfigurationsResponse;
import com.oracle.bmc.bds.responses.ListPatchHistoriesResponse;
import com.oracle.bmc.bds.responses.ListPatchesResponse;
import com.oracle.bmc.bds.responses.ListWorkRequestErrorsResponse;
import com.oracle.bmc.bds.responses.ListWorkRequestLogsResponse;
import com.oracle.bmc.bds.responses.ListWorkRequestsResponse;
import com.oracle.bmc.paginator.internal.RequestBuilderAndToken;
import com.oracle.bmc.paginator.internal.ResponseIterable;
import com.oracle.bmc.paginator.internal.ResponseRecordIterable;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;

public class BdsPaginators {
    private final Bds client;

    public BdsPaginators(Bds client) {
        this.client = client;
    }

    public Iterable<ListAutoScalingConfigurationsResponse> listAutoScalingConfigurationsResponseIterator(final ListAutoScalingConfigurationsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListAutoScalingConfigurationsRequest.Builder>(){

            @Override
            public ListAutoScalingConfigurationsRequest.Builder get() {
                return ListAutoScalingConfigurationsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListAutoScalingConfigurationsResponse, String>(){

            @Override
            public String apply(ListAutoScalingConfigurationsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListAutoScalingConfigurationsRequest.Builder>, ListAutoScalingConfigurationsRequest>(){

            @Override
            public ListAutoScalingConfigurationsRequest apply(RequestBuilderAndToken<ListAutoScalingConfigurationsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListAutoScalingConfigurationsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListAutoScalingConfigurationsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListAutoScalingConfigurationsRequest, ListAutoScalingConfigurationsResponse>(){

            @Override
            public ListAutoScalingConfigurationsResponse apply(ListAutoScalingConfigurationsRequest request) {
                return BdsPaginators.this.client.listAutoScalingConfigurations(request);
            }
        });
    }

    public Iterable<AutoScalingConfigurationSummary> listAutoScalingConfigurationsRecordIterator(final ListAutoScalingConfigurationsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListAutoScalingConfigurationsRequest.Builder>(){

            @Override
            public ListAutoScalingConfigurationsRequest.Builder get() {
                return ListAutoScalingConfigurationsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListAutoScalingConfigurationsResponse, String>(){

            @Override
            public String apply(ListAutoScalingConfigurationsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListAutoScalingConfigurationsRequest.Builder>, ListAutoScalingConfigurationsRequest>(){

            @Override
            public ListAutoScalingConfigurationsRequest apply(RequestBuilderAndToken<ListAutoScalingConfigurationsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListAutoScalingConfigurationsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListAutoScalingConfigurationsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListAutoScalingConfigurationsRequest, ListAutoScalingConfigurationsResponse>(){

            @Override
            public ListAutoScalingConfigurationsResponse apply(ListAutoScalingConfigurationsRequest request) {
                return BdsPaginators.this.client.listAutoScalingConfigurations(request);
            }
        }, (Function)new Function<ListAutoScalingConfigurationsResponse, List<AutoScalingConfigurationSummary>>(){

            @Override
            public List<AutoScalingConfigurationSummary> apply(ListAutoScalingConfigurationsResponse response) {
                return response.getItems();
            }
        });
    }

    public Iterable<ListBdsApiKeysResponse> listBdsApiKeysResponseIterator(final ListBdsApiKeysRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListBdsApiKeysRequest.Builder>(){

            @Override
            public ListBdsApiKeysRequest.Builder get() {
                return ListBdsApiKeysRequest.builder().copy(request);
            }
        }, (Function)new Function<ListBdsApiKeysResponse, String>(){

            @Override
            public String apply(ListBdsApiKeysResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListBdsApiKeysRequest.Builder>, ListBdsApiKeysRequest>(){

            @Override
            public ListBdsApiKeysRequest apply(RequestBuilderAndToken<ListBdsApiKeysRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListBdsApiKeysRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListBdsApiKeysRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListBdsApiKeysRequest, ListBdsApiKeysResponse>(){

            @Override
            public ListBdsApiKeysResponse apply(ListBdsApiKeysRequest request) {
                return BdsPaginators.this.client.listBdsApiKeys(request);
            }
        });
    }

    public Iterable<BdsApiKeySummary> listBdsApiKeysRecordIterator(final ListBdsApiKeysRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListBdsApiKeysRequest.Builder>(){

            @Override
            public ListBdsApiKeysRequest.Builder get() {
                return ListBdsApiKeysRequest.builder().copy(request);
            }
        }, (Function)new Function<ListBdsApiKeysResponse, String>(){

            @Override
            public String apply(ListBdsApiKeysResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListBdsApiKeysRequest.Builder>, ListBdsApiKeysRequest>(){

            @Override
            public ListBdsApiKeysRequest apply(RequestBuilderAndToken<ListBdsApiKeysRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListBdsApiKeysRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListBdsApiKeysRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListBdsApiKeysRequest, ListBdsApiKeysResponse>(){

            @Override
            public ListBdsApiKeysResponse apply(ListBdsApiKeysRequest request) {
                return BdsPaginators.this.client.listBdsApiKeys(request);
            }
        }, (Function)new Function<ListBdsApiKeysResponse, List<BdsApiKeySummary>>(){

            @Override
            public List<BdsApiKeySummary> apply(ListBdsApiKeysResponse response) {
                return response.getItems();
            }
        });
    }

    public Iterable<ListBdsInstancesResponse> listBdsInstancesResponseIterator(final ListBdsInstancesRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListBdsInstancesRequest.Builder>(){

            @Override
            public ListBdsInstancesRequest.Builder get() {
                return ListBdsInstancesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListBdsInstancesResponse, String>(){

            @Override
            public String apply(ListBdsInstancesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListBdsInstancesRequest.Builder>, ListBdsInstancesRequest>(){

            @Override
            public ListBdsInstancesRequest apply(RequestBuilderAndToken<ListBdsInstancesRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListBdsInstancesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListBdsInstancesRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListBdsInstancesRequest, ListBdsInstancesResponse>(){

            @Override
            public ListBdsInstancesResponse apply(ListBdsInstancesRequest request) {
                return BdsPaginators.this.client.listBdsInstances(request);
            }
        });
    }

    public Iterable<BdsInstanceSummary> listBdsInstancesRecordIterator(final ListBdsInstancesRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListBdsInstancesRequest.Builder>(){

            @Override
            public ListBdsInstancesRequest.Builder get() {
                return ListBdsInstancesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListBdsInstancesResponse, String>(){

            @Override
            public String apply(ListBdsInstancesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListBdsInstancesRequest.Builder>, ListBdsInstancesRequest>(){

            @Override
            public ListBdsInstancesRequest apply(RequestBuilderAndToken<ListBdsInstancesRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListBdsInstancesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListBdsInstancesRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListBdsInstancesRequest, ListBdsInstancesResponse>(){

            @Override
            public ListBdsInstancesResponse apply(ListBdsInstancesRequest request) {
                return BdsPaginators.this.client.listBdsInstances(request);
            }
        }, (Function)new Function<ListBdsInstancesResponse, List<BdsInstanceSummary>>(){

            @Override
            public List<BdsInstanceSummary> apply(ListBdsInstancesResponse response) {
                return response.getItems();
            }
        });
    }

    public Iterable<ListBdsMetastoreConfigurationsResponse> listBdsMetastoreConfigurationsResponseIterator(final ListBdsMetastoreConfigurationsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListBdsMetastoreConfigurationsRequest.Builder>(){

            @Override
            public ListBdsMetastoreConfigurationsRequest.Builder get() {
                return ListBdsMetastoreConfigurationsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListBdsMetastoreConfigurationsResponse, String>(){

            @Override
            public String apply(ListBdsMetastoreConfigurationsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListBdsMetastoreConfigurationsRequest.Builder>, ListBdsMetastoreConfigurationsRequest>(){

            @Override
            public ListBdsMetastoreConfigurationsRequest apply(RequestBuilderAndToken<ListBdsMetastoreConfigurationsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListBdsMetastoreConfigurationsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListBdsMetastoreConfigurationsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListBdsMetastoreConfigurationsRequest, ListBdsMetastoreConfigurationsResponse>(){

            @Override
            public ListBdsMetastoreConfigurationsResponse apply(ListBdsMetastoreConfigurationsRequest request) {
                return BdsPaginators.this.client.listBdsMetastoreConfigurations(request);
            }
        });
    }

    public Iterable<BdsMetastoreConfigurationSummary> listBdsMetastoreConfigurationsRecordIterator(final ListBdsMetastoreConfigurationsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListBdsMetastoreConfigurationsRequest.Builder>(){

            @Override
            public ListBdsMetastoreConfigurationsRequest.Builder get() {
                return ListBdsMetastoreConfigurationsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListBdsMetastoreConfigurationsResponse, String>(){

            @Override
            public String apply(ListBdsMetastoreConfigurationsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListBdsMetastoreConfigurationsRequest.Builder>, ListBdsMetastoreConfigurationsRequest>(){

            @Override
            public ListBdsMetastoreConfigurationsRequest apply(RequestBuilderAndToken<ListBdsMetastoreConfigurationsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListBdsMetastoreConfigurationsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListBdsMetastoreConfigurationsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListBdsMetastoreConfigurationsRequest, ListBdsMetastoreConfigurationsResponse>(){

            @Override
            public ListBdsMetastoreConfigurationsResponse apply(ListBdsMetastoreConfigurationsRequest request) {
                return BdsPaginators.this.client.listBdsMetastoreConfigurations(request);
            }
        }, (Function)new Function<ListBdsMetastoreConfigurationsResponse, List<BdsMetastoreConfigurationSummary>>(){

            @Override
            public List<BdsMetastoreConfigurationSummary> apply(ListBdsMetastoreConfigurationsResponse response) {
                return response.getItems();
            }
        });
    }

    public Iterable<ListPatchHistoriesResponse> listPatchHistoriesResponseIterator(final ListPatchHistoriesRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListPatchHistoriesRequest.Builder>(){

            @Override
            public ListPatchHistoriesRequest.Builder get() {
                return ListPatchHistoriesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListPatchHistoriesResponse, String>(){

            @Override
            public String apply(ListPatchHistoriesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListPatchHistoriesRequest.Builder>, ListPatchHistoriesRequest>(){

            @Override
            public ListPatchHistoriesRequest apply(RequestBuilderAndToken<ListPatchHistoriesRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListPatchHistoriesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListPatchHistoriesRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListPatchHistoriesRequest, ListPatchHistoriesResponse>(){

            @Override
            public ListPatchHistoriesResponse apply(ListPatchHistoriesRequest request) {
                return BdsPaginators.this.client.listPatchHistories(request);
            }
        });
    }

    public Iterable<PatchHistorySummary> listPatchHistoriesRecordIterator(final ListPatchHistoriesRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListPatchHistoriesRequest.Builder>(){

            @Override
            public ListPatchHistoriesRequest.Builder get() {
                return ListPatchHistoriesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListPatchHistoriesResponse, String>(){

            @Override
            public String apply(ListPatchHistoriesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListPatchHistoriesRequest.Builder>, ListPatchHistoriesRequest>(){

            @Override
            public ListPatchHistoriesRequest apply(RequestBuilderAndToken<ListPatchHistoriesRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListPatchHistoriesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListPatchHistoriesRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListPatchHistoriesRequest, ListPatchHistoriesResponse>(){

            @Override
            public ListPatchHistoriesResponse apply(ListPatchHistoriesRequest request) {
                return BdsPaginators.this.client.listPatchHistories(request);
            }
        }, (Function)new Function<ListPatchHistoriesResponse, List<PatchHistorySummary>>(){

            @Override
            public List<PatchHistorySummary> apply(ListPatchHistoriesResponse response) {
                return response.getItems();
            }
        });
    }

    public Iterable<ListPatchesResponse> listPatchesResponseIterator(final ListPatchesRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListPatchesRequest.Builder>(){

            @Override
            public ListPatchesRequest.Builder get() {
                return ListPatchesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListPatchesResponse, String>(){

            @Override
            public String apply(ListPatchesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListPatchesRequest.Builder>, ListPatchesRequest>(){

            @Override
            public ListPatchesRequest apply(RequestBuilderAndToken<ListPatchesRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListPatchesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListPatchesRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListPatchesRequest, ListPatchesResponse>(){

            @Override
            public ListPatchesResponse apply(ListPatchesRequest request) {
                return BdsPaginators.this.client.listPatches(request);
            }
        });
    }

    public Iterable<PatchSummary> listPatchesRecordIterator(final ListPatchesRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListPatchesRequest.Builder>(){

            @Override
            public ListPatchesRequest.Builder get() {
                return ListPatchesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListPatchesResponse, String>(){

            @Override
            public String apply(ListPatchesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListPatchesRequest.Builder>, ListPatchesRequest>(){

            @Override
            public ListPatchesRequest apply(RequestBuilderAndToken<ListPatchesRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListPatchesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListPatchesRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListPatchesRequest, ListPatchesResponse>(){

            @Override
            public ListPatchesResponse apply(ListPatchesRequest request) {
                return BdsPaginators.this.client.listPatches(request);
            }
        }, (Function)new Function<ListPatchesResponse, List<PatchSummary>>(){

            @Override
            public List<PatchSummary> apply(ListPatchesResponse response) {
                return response.getItems();
            }
        });
    }

    public Iterable<ListWorkRequestErrorsResponse> listWorkRequestErrorsResponseIterator(final ListWorkRequestErrorsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListWorkRequestErrorsRequest.Builder>(){

            @Override
            public ListWorkRequestErrorsRequest.Builder get() {
                return ListWorkRequestErrorsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListWorkRequestErrorsResponse, String>(){

            @Override
            public String apply(ListWorkRequestErrorsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListWorkRequestErrorsRequest.Builder>, ListWorkRequestErrorsRequest>(){

            @Override
            public ListWorkRequestErrorsRequest apply(RequestBuilderAndToken<ListWorkRequestErrorsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListWorkRequestErrorsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListWorkRequestErrorsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListWorkRequestErrorsRequest, ListWorkRequestErrorsResponse>(){

            @Override
            public ListWorkRequestErrorsResponse apply(ListWorkRequestErrorsRequest request) {
                return BdsPaginators.this.client.listWorkRequestErrors(request);
            }
        });
    }

    public Iterable<WorkRequestError> listWorkRequestErrorsRecordIterator(final ListWorkRequestErrorsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListWorkRequestErrorsRequest.Builder>(){

            @Override
            public ListWorkRequestErrorsRequest.Builder get() {
                return ListWorkRequestErrorsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListWorkRequestErrorsResponse, String>(){

            @Override
            public String apply(ListWorkRequestErrorsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListWorkRequestErrorsRequest.Builder>, ListWorkRequestErrorsRequest>(){

            @Override
            public ListWorkRequestErrorsRequest apply(RequestBuilderAndToken<ListWorkRequestErrorsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListWorkRequestErrorsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListWorkRequestErrorsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListWorkRequestErrorsRequest, ListWorkRequestErrorsResponse>(){

            @Override
            public ListWorkRequestErrorsResponse apply(ListWorkRequestErrorsRequest request) {
                return BdsPaginators.this.client.listWorkRequestErrors(request);
            }
        }, (Function)new Function<ListWorkRequestErrorsResponse, List<WorkRequestError>>(){

            @Override
            public List<WorkRequestError> apply(ListWorkRequestErrorsResponse response) {
                return response.getItems();
            }
        });
    }

    public Iterable<ListWorkRequestLogsResponse> listWorkRequestLogsResponseIterator(final ListWorkRequestLogsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListWorkRequestLogsRequest.Builder>(){

            @Override
            public ListWorkRequestLogsRequest.Builder get() {
                return ListWorkRequestLogsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListWorkRequestLogsResponse, String>(){

            @Override
            public String apply(ListWorkRequestLogsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListWorkRequestLogsRequest.Builder>, ListWorkRequestLogsRequest>(){

            @Override
            public ListWorkRequestLogsRequest apply(RequestBuilderAndToken<ListWorkRequestLogsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListWorkRequestLogsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListWorkRequestLogsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListWorkRequestLogsRequest, ListWorkRequestLogsResponse>(){

            @Override
            public ListWorkRequestLogsResponse apply(ListWorkRequestLogsRequest request) {
                return BdsPaginators.this.client.listWorkRequestLogs(request);
            }
        });
    }

    public Iterable<WorkRequestLogEntry> listWorkRequestLogsRecordIterator(final ListWorkRequestLogsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListWorkRequestLogsRequest.Builder>(){

            @Override
            public ListWorkRequestLogsRequest.Builder get() {
                return ListWorkRequestLogsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListWorkRequestLogsResponse, String>(){

            @Override
            public String apply(ListWorkRequestLogsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListWorkRequestLogsRequest.Builder>, ListWorkRequestLogsRequest>(){

            @Override
            public ListWorkRequestLogsRequest apply(RequestBuilderAndToken<ListWorkRequestLogsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListWorkRequestLogsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListWorkRequestLogsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListWorkRequestLogsRequest, ListWorkRequestLogsResponse>(){

            @Override
            public ListWorkRequestLogsResponse apply(ListWorkRequestLogsRequest request) {
                return BdsPaginators.this.client.listWorkRequestLogs(request);
            }
        }, (Function)new Function<ListWorkRequestLogsResponse, List<WorkRequestLogEntry>>(){

            @Override
            public List<WorkRequestLogEntry> apply(ListWorkRequestLogsResponse response) {
                return response.getItems();
            }
        });
    }

    public Iterable<ListWorkRequestsResponse> listWorkRequestsResponseIterator(final ListWorkRequestsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListWorkRequestsRequest.Builder>(){

            @Override
            public ListWorkRequestsRequest.Builder get() {
                return ListWorkRequestsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListWorkRequestsResponse, String>(){

            @Override
            public String apply(ListWorkRequestsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListWorkRequestsRequest.Builder>, ListWorkRequestsRequest>(){

            @Override
            public ListWorkRequestsRequest apply(RequestBuilderAndToken<ListWorkRequestsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListWorkRequestsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListWorkRequestsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListWorkRequestsRequest, ListWorkRequestsResponse>(){

            @Override
            public ListWorkRequestsResponse apply(ListWorkRequestsRequest request) {
                return BdsPaginators.this.client.listWorkRequests(request);
            }
        });
    }

    public Iterable<WorkRequest> listWorkRequestsRecordIterator(final ListWorkRequestsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListWorkRequestsRequest.Builder>(){

            @Override
            public ListWorkRequestsRequest.Builder get() {
                return ListWorkRequestsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListWorkRequestsResponse, String>(){

            @Override
            public String apply(ListWorkRequestsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListWorkRequestsRequest.Builder>, ListWorkRequestsRequest>(){

            @Override
            public ListWorkRequestsRequest apply(RequestBuilderAndToken<ListWorkRequestsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListWorkRequestsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListWorkRequestsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListWorkRequestsRequest, ListWorkRequestsResponse>(){

            @Override
            public ListWorkRequestsResponse apply(ListWorkRequestsRequest request) {
                return BdsPaginators.this.client.listWorkRequests(request);
            }
        }, (Function)new Function<ListWorkRequestsResponse, List<WorkRequest>>(){

            @Override
            public List<WorkRequest> apply(ListWorkRequestsResponse response) {
                return response.getItems();
            }
        });
    }
}

