/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.bastion;

import com.oracle.bmc.bastion.Bastion;
import com.oracle.bmc.bastion.model.BastionLifecycleState;
import com.oracle.bmc.bastion.model.SessionLifecycleState;
import com.oracle.bmc.bastion.requests.GetBastionRequest;
import com.oracle.bmc.bastion.requests.GetSessionRequest;
import com.oracle.bmc.bastion.requests.GetWorkRequestRequest;
import com.oracle.bmc.bastion.responses.GetBastionResponse;
import com.oracle.bmc.bastion.responses.GetSessionResponse;
import com.oracle.bmc.bastion.responses.GetWorkRequestResponse;
import com.oracle.bmc.util.internal.Validate;
import com.oracle.bmc.waiter.BmcGenericWaiter;
import com.oracle.bmc.waiter.DelayStrategy;
import com.oracle.bmc.waiter.TerminationStrategy;
import com.oracle.bmc.waiter.Waiter;
import com.oracle.bmc.waiter.Waiters;
import com.oracle.bmc.waiter.internal.SimpleWaiterImpl;
import java.util.Arrays;
import java.util.HashSet;
import java.util.concurrent.ExecutorService;
import java.util.function.Function;
import java.util.function.Predicate;

public class BastionWaiters {
    private final ExecutorService executorService;
    private final Bastion client;

    public BastionWaiters(ExecutorService executorService, Bastion client) {
        this.executorService = executorService;
        this.client = client;
    }

    public Waiter<GetBastionRequest, GetBastionResponse> forBastion(GetBastionRequest request, BastionLifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forBastion(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetBastionRequest, GetBastionResponse> forBastion(GetBastionRequest request, BastionLifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forBastion(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetBastionRequest, GetBastionResponse> forBastion(GetBastionRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, BastionLifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forBastion(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetBastionRequest, GetBastionResponse> forBastion(BmcGenericWaiter waiter, GetBastionRequest request, BastionLifecycleState ... targetStates) {
        final HashSet<BastionLifecycleState> targetStatesSet = new HashSet<BastionLifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetBastionRequest, GetBastionResponse>(){

            @Override
            public GetBastionResponse apply(GetBastionRequest request) {
                return BastionWaiters.this.client.getBastion(request);
            }
        }, (Predicate)new Predicate<GetBastionResponse>(){

            @Override
            public boolean test(GetBastionResponse response) {
                return targetStatesSet.contains((Object)response.getBastion().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)BastionLifecycleState.Deleted)), (Object)request);
    }

    public Waiter<GetSessionRequest, GetSessionResponse> forSession(GetSessionRequest request, SessionLifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forSession(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetSessionRequest, GetSessionResponse> forSession(GetSessionRequest request, SessionLifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forSession(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetSessionRequest, GetSessionResponse> forSession(GetSessionRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, SessionLifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forSession(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetSessionRequest, GetSessionResponse> forSession(BmcGenericWaiter waiter, GetSessionRequest request, SessionLifecycleState ... targetStates) {
        final HashSet<SessionLifecycleState> targetStatesSet = new HashSet<SessionLifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetSessionRequest, GetSessionResponse>(){

            @Override
            public GetSessionResponse apply(GetSessionRequest request) {
                return BastionWaiters.this.client.getSession(request);
            }
        }, (Predicate)new Predicate<GetSessionResponse>(){

            @Override
            public boolean test(GetSessionResponse response) {
                return targetStatesSet.contains((Object)response.getSession().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)SessionLifecycleState.Deleted)), (Object)request);
    }

    public Waiter<GetWorkRequestRequest, GetWorkRequestResponse> forWorkRequest(GetWorkRequestRequest request) {
        return this.forWorkRequest(Waiters.DEFAULT_POLLING_WAITER, request);
    }

    public Waiter<GetWorkRequestRequest, GetWorkRequestResponse> forWorkRequest(GetWorkRequestRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        return this.forWorkRequest(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request);
    }

    private Waiter<GetWorkRequestRequest, GetWorkRequestResponse> forWorkRequest(BmcGenericWaiter waiter, GetWorkRequestRequest request) {
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetWorkRequestRequest, GetWorkRequestResponse>(){

            @Override
            public GetWorkRequestResponse apply(GetWorkRequestRequest request) {
                return BastionWaiters.this.client.getWorkRequest(request);
            }
        }, (Predicate)new Predicate<GetWorkRequestResponse>(){

            @Override
            public boolean test(GetWorkRequestResponse response) {
                return response.getWorkRequest().getTimeFinished() != null;
            }
        }, false), (Object)request);
    }
}

