/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.autoscaling.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class DeleteAutoScalingPolicyRequest
extends BmcRequest<Void> {
    private String autoScalingConfigurationId;
    private String autoScalingPolicyId;
    private String ifMatch;
    private String opcRequestId;

    public String getAutoScalingConfigurationId() {
        return this.autoScalingConfigurationId;
    }

    public String getAutoScalingPolicyId() {
        return this.autoScalingPolicyId;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().autoScalingConfigurationId(this.autoScalingConfigurationId).autoScalingPolicyId(this.autoScalingPolicyId).ifMatch(this.ifMatch).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",autoScalingConfigurationId=").append(String.valueOf(this.autoScalingConfigurationId));
        sb.append(",autoScalingPolicyId=").append(String.valueOf(this.autoScalingPolicyId));
        sb.append(",ifMatch=").append(String.valueOf(this.ifMatch));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DeleteAutoScalingPolicyRequest)) {
            return false;
        }
        DeleteAutoScalingPolicyRequest other = (DeleteAutoScalingPolicyRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.autoScalingConfigurationId, other.autoScalingConfigurationId) && Objects.equals(this.autoScalingPolicyId, other.autoScalingPolicyId) && Objects.equals(this.ifMatch, other.ifMatch) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.autoScalingConfigurationId == null ? 43 : this.autoScalingConfigurationId.hashCode());
        result = result * 59 + (this.autoScalingPolicyId == null ? 43 : this.autoScalingPolicyId.hashCode());
        result = result * 59 + (this.ifMatch == null ? 43 : this.ifMatch.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<DeleteAutoScalingPolicyRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String autoScalingConfigurationId = null;
        private String autoScalingPolicyId = null;
        private String ifMatch = null;
        private String opcRequestId = null;

        public Builder autoScalingConfigurationId(String autoScalingConfigurationId) {
            this.autoScalingConfigurationId = autoScalingConfigurationId;
            return this;
        }

        public Builder autoScalingPolicyId(String autoScalingPolicyId) {
            this.autoScalingPolicyId = autoScalingPolicyId;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(DeleteAutoScalingPolicyRequest o) {
            this.autoScalingConfigurationId(o.getAutoScalingConfigurationId());
            this.autoScalingPolicyId(o.getAutoScalingPolicyId());
            this.ifMatch(o.getIfMatch());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public DeleteAutoScalingPolicyRequest build() {
            DeleteAutoScalingPolicyRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public DeleteAutoScalingPolicyRequest buildWithoutInvocationCallback() {
            DeleteAutoScalingPolicyRequest request = new DeleteAutoScalingPolicyRequest();
            request.autoScalingConfigurationId = this.autoScalingConfigurationId;
            request.autoScalingPolicyId = this.autoScalingPolicyId;
            request.ifMatch = this.ifMatch;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

