/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.autoscaling.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.autoscaling.model.CreateAutoScalingPolicyDetails;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class CreateAutoScalingPolicyRequest
extends BmcRequest<CreateAutoScalingPolicyDetails> {
    private String autoScalingConfigurationId;
    private CreateAutoScalingPolicyDetails createAutoScalingPolicyDetails;
    private String opcRequestId;
    private String opcRetryToken;

    public String getAutoScalingConfigurationId() {
        return this.autoScalingConfigurationId;
    }

    public CreateAutoScalingPolicyDetails getCreateAutoScalingPolicyDetails() {
        return this.createAutoScalingPolicyDetails;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getOpcRetryToken() {
        return this.opcRetryToken;
    }

    @InternalSdk
    public CreateAutoScalingPolicyDetails getBody$() {
        return this.createAutoScalingPolicyDetails;
    }

    public Builder toBuilder() {
        return new Builder().autoScalingConfigurationId(this.autoScalingConfigurationId).createAutoScalingPolicyDetails(this.createAutoScalingPolicyDetails).opcRequestId(this.opcRequestId).opcRetryToken(this.opcRetryToken);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",autoScalingConfigurationId=").append(String.valueOf(this.autoScalingConfigurationId));
        sb.append(",createAutoScalingPolicyDetails=").append(String.valueOf((Object)this.createAutoScalingPolicyDetails));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",opcRetryToken=").append(String.valueOf(this.opcRetryToken));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CreateAutoScalingPolicyRequest)) {
            return false;
        }
        CreateAutoScalingPolicyRequest other = (CreateAutoScalingPolicyRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.autoScalingConfigurationId, other.autoScalingConfigurationId) && Objects.equals((Object)this.createAutoScalingPolicyDetails, (Object)other.createAutoScalingPolicyDetails) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.opcRetryToken, other.opcRetryToken);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.autoScalingConfigurationId == null ? 43 : this.autoScalingConfigurationId.hashCode());
        result = result * 59 + (this.createAutoScalingPolicyDetails == null ? 43 : this.createAutoScalingPolicyDetails.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.opcRetryToken == null ? 43 : this.opcRetryToken.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<CreateAutoScalingPolicyRequest, CreateAutoScalingPolicyDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String autoScalingConfigurationId = null;
        private CreateAutoScalingPolicyDetails createAutoScalingPolicyDetails = null;
        private String opcRequestId = null;
        private String opcRetryToken = null;

        public Builder autoScalingConfigurationId(String autoScalingConfigurationId) {
            this.autoScalingConfigurationId = autoScalingConfigurationId;
            return this;
        }

        public Builder createAutoScalingPolicyDetails(CreateAutoScalingPolicyDetails createAutoScalingPolicyDetails) {
            this.createAutoScalingPolicyDetails = createAutoScalingPolicyDetails;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder opcRetryToken(String opcRetryToken) {
            this.opcRetryToken = opcRetryToken;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(CreateAutoScalingPolicyRequest o) {
            this.autoScalingConfigurationId(o.getAutoScalingConfigurationId());
            this.createAutoScalingPolicyDetails(o.getCreateAutoScalingPolicyDetails());
            this.opcRequestId(o.getOpcRequestId());
            this.opcRetryToken(o.getOpcRetryToken());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public CreateAutoScalingPolicyRequest build() {
            CreateAutoScalingPolicyRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(CreateAutoScalingPolicyDetails body) {
            this.createAutoScalingPolicyDetails(body);
            return this;
        }

        public CreateAutoScalingPolicyRequest buildWithoutInvocationCallback() {
            CreateAutoScalingPolicyRequest request = new CreateAutoScalingPolicyRequest();
            request.autoScalingConfigurationId = this.autoScalingConfigurationId;
            request.createAutoScalingPolicyDetails = this.createAutoScalingPolicyDetails;
            request.opcRequestId = this.opcRequestId;
            request.opcRetryToken = this.opcRetryToken;
            return request;
        }
    }
}

