/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.audit.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class Response
extends ExplicitlySetBmcModel {
    @JsonProperty(value="status")
    private final String status;
    @JsonProperty(value="responseTime")
    private final Date responseTime;
    @JsonProperty(value="headers")
    private final Map<String, List<String>> headers;
    @JsonProperty(value="payload")
    private final Map<String, Object> payload;
    @JsonProperty(value="message")
    private final String message;

    @Deprecated
    @ConstructorProperties(value={"status", "responseTime", "headers", "payload", "message"})
    public Response(String status, Date responseTime, Map<String, List<String>> headers, Map<String, Object> payload, String message) {
        this.status = status;
        this.responseTime = responseTime;
        this.headers = headers;
        this.payload = payload;
        this.message = message;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getStatus() {
        return this.status;
    }

    public Date getResponseTime() {
        return this.responseTime;
    }

    public Map<String, List<String>> getHeaders() {
        return this.headers;
    }

    public Map<String, Object> getPayload() {
        return this.payload;
    }

    public String getMessage() {
        return this.message;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("Response(");
        sb.append("super=").append(super.toString());
        sb.append("status=").append(String.valueOf(this.status));
        sb.append(", responseTime=").append(String.valueOf(this.responseTime));
        sb.append(", headers=").append(String.valueOf(this.headers));
        sb.append(", payload=").append(String.valueOf(this.payload));
        sb.append(", message=").append(String.valueOf(this.message));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Response)) {
            return false;
        }
        Response other = (Response)((Object)o);
        return Objects.equals(this.status, other.status) && Objects.equals(this.responseTime, other.responseTime) && Objects.equals(this.headers, other.headers) && Objects.equals(this.payload, other.payload) && Objects.equals(this.message, other.message) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.status == null ? 43 : this.status.hashCode());
        result = result * 59 + (this.responseTime == null ? 43 : this.responseTime.hashCode());
        result = result * 59 + (this.headers == null ? 43 : this.headers.hashCode());
        result = result * 59 + (this.payload == null ? 43 : this.payload.hashCode());
        result = result * 59 + (this.message == null ? 43 : this.message.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="status")
        private String status;
        @JsonProperty(value="responseTime")
        private Date responseTime;
        @JsonProperty(value="headers")
        private Map<String, List<String>> headers;
        @JsonProperty(value="payload")
        private Map<String, Object> payload;
        @JsonProperty(value="message")
        private String message;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder status(String status) {
            this.status = status;
            this.__explicitlySet__.add("status");
            return this;
        }

        public Builder responseTime(Date responseTime) {
            this.responseTime = responseTime;
            this.__explicitlySet__.add("responseTime");
            return this;
        }

        public Builder headers(Map<String, List<String>> headers) {
            this.headers = headers;
            this.__explicitlySet__.add("headers");
            return this;
        }

        public Builder payload(Map<String, Object> payload) {
            this.payload = payload;
            this.__explicitlySet__.add("payload");
            return this;
        }

        public Builder message(String message) {
            this.message = message;
            this.__explicitlySet__.add("message");
            return this;
        }

        public Response build() {
            Response model = new Response(this.status, this.responseTime, this.headers, this.payload, this.message);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(Response model) {
            if (model.wasPropertyExplicitlySet("status")) {
                this.status(model.getStatus());
            }
            if (model.wasPropertyExplicitlySet("responseTime")) {
                this.responseTime(model.getResponseTime());
            }
            if (model.wasPropertyExplicitlySet("headers")) {
                this.headers(model.getHeaders());
            }
            if (model.wasPropertyExplicitlySet("payload")) {
                this.payload(model.getPayload());
            }
            if (model.wasPropertyExplicitlySet("message")) {
                this.message(model.getMessage());
            }
            return this;
        }
    }
}

