/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.artifacts.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.artifacts.model.ContainerImageLayer;
import com.oracle.bmc.artifacts.model.ContainerVersion;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class ContainerImage
extends ExplicitlySetBmcModel {
    @JsonProperty(value="compartmentId")
    private final String compartmentId;
    @JsonProperty(value="createdBy")
    private final String createdBy;
    @JsonProperty(value="digest")
    private final String digest;
    @JsonProperty(value="displayName")
    private final String displayName;
    @JsonProperty(value="id")
    private final String id;
    @JsonProperty(value="layers")
    private final List<ContainerImageLayer> layers;
    @JsonProperty(value="layersSizeInBytes")
    private final Long layersSizeInBytes;
    @JsonProperty(value="lifecycleState")
    private final LifecycleState lifecycleState;
    @JsonProperty(value="manifestSizeInBytes")
    private final Integer manifestSizeInBytes;
    @JsonProperty(value="pullCount")
    private final Long pullCount;
    @JsonProperty(value="repositoryId")
    private final String repositoryId;
    @JsonProperty(value="repositoryName")
    private final String repositoryName;
    @JsonProperty(value="timeCreated")
    private final Date timeCreated;
    @JsonProperty(value="timeLastPulled")
    private final Date timeLastPulled;
    @JsonProperty(value="version")
    private final String version;
    @JsonProperty(value="versions")
    private final List<ContainerVersion> versions;

    @Deprecated
    @ConstructorProperties(value={"compartmentId", "createdBy", "digest", "displayName", "id", "layers", "layersSizeInBytes", "lifecycleState", "manifestSizeInBytes", "pullCount", "repositoryId", "repositoryName", "timeCreated", "timeLastPulled", "version", "versions"})
    public ContainerImage(String compartmentId, String createdBy, String digest, String displayName, String id, List<ContainerImageLayer> layers, Long layersSizeInBytes, LifecycleState lifecycleState, Integer manifestSizeInBytes, Long pullCount, String repositoryId, String repositoryName, Date timeCreated, Date timeLastPulled, String version, List<ContainerVersion> versions) {
        this.compartmentId = compartmentId;
        this.createdBy = createdBy;
        this.digest = digest;
        this.displayName = displayName;
        this.id = id;
        this.layers = layers;
        this.layersSizeInBytes = layersSizeInBytes;
        this.lifecycleState = lifecycleState;
        this.manifestSizeInBytes = manifestSizeInBytes;
        this.pullCount = pullCount;
        this.repositoryId = repositoryId;
        this.repositoryName = repositoryName;
        this.timeCreated = timeCreated;
        this.timeLastPulled = timeLastPulled;
        this.version = version;
        this.versions = versions;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public String getCreatedBy() {
        return this.createdBy;
    }

    public String getDigest() {
        return this.digest;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getId() {
        return this.id;
    }

    public List<ContainerImageLayer> getLayers() {
        return this.layers;
    }

    public Long getLayersSizeInBytes() {
        return this.layersSizeInBytes;
    }

    public LifecycleState getLifecycleState() {
        return this.lifecycleState;
    }

    public Integer getManifestSizeInBytes() {
        return this.manifestSizeInBytes;
    }

    public Long getPullCount() {
        return this.pullCount;
    }

    public String getRepositoryId() {
        return this.repositoryId;
    }

    public String getRepositoryName() {
        return this.repositoryName;
    }

    public Date getTimeCreated() {
        return this.timeCreated;
    }

    public Date getTimeLastPulled() {
        return this.timeLastPulled;
    }

    public String getVersion() {
        return this.version;
    }

    public List<ContainerVersion> getVersions() {
        return this.versions;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("ContainerImage(");
        sb.append("super=").append(super.toString());
        sb.append("compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(", createdBy=").append(String.valueOf(this.createdBy));
        sb.append(", digest=").append(String.valueOf(this.digest));
        sb.append(", displayName=").append(String.valueOf(this.displayName));
        sb.append(", id=").append(String.valueOf(this.id));
        sb.append(", layers=").append(String.valueOf(this.layers));
        sb.append(", layersSizeInBytes=").append(String.valueOf(this.layersSizeInBytes));
        sb.append(", lifecycleState=").append(String.valueOf((Object)this.lifecycleState));
        sb.append(", manifestSizeInBytes=").append(String.valueOf(this.manifestSizeInBytes));
        sb.append(", pullCount=").append(String.valueOf(this.pullCount));
        sb.append(", repositoryId=").append(String.valueOf(this.repositoryId));
        sb.append(", repositoryName=").append(String.valueOf(this.repositoryName));
        sb.append(", timeCreated=").append(String.valueOf(this.timeCreated));
        sb.append(", timeLastPulled=").append(String.valueOf(this.timeLastPulled));
        sb.append(", version=").append(String.valueOf(this.version));
        sb.append(", versions=").append(String.valueOf(this.versions));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ContainerImage)) {
            return false;
        }
        ContainerImage other = (ContainerImage)((Object)o);
        return Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals(this.createdBy, other.createdBy) && Objects.equals(this.digest, other.digest) && Objects.equals(this.displayName, other.displayName) && Objects.equals(this.id, other.id) && Objects.equals(this.layers, other.layers) && Objects.equals(this.layersSizeInBytes, other.layersSizeInBytes) && Objects.equals((Object)this.lifecycleState, (Object)other.lifecycleState) && Objects.equals(this.manifestSizeInBytes, other.manifestSizeInBytes) && Objects.equals(this.pullCount, other.pullCount) && Objects.equals(this.repositoryId, other.repositoryId) && Objects.equals(this.repositoryName, other.repositoryName) && Objects.equals(this.timeCreated, other.timeCreated) && Objects.equals(this.timeLastPulled, other.timeLastPulled) && Objects.equals(this.version, other.version) && Objects.equals(this.versions, other.versions) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.createdBy == null ? 43 : this.createdBy.hashCode());
        result = result * 59 + (this.digest == null ? 43 : this.digest.hashCode());
        result = result * 59 + (this.displayName == null ? 43 : this.displayName.hashCode());
        result = result * 59 + (this.id == null ? 43 : this.id.hashCode());
        result = result * 59 + (this.layers == null ? 43 : this.layers.hashCode());
        result = result * 59 + (this.layersSizeInBytes == null ? 43 : this.layersSizeInBytes.hashCode());
        result = result * 59 + (this.lifecycleState == null ? 43 : this.lifecycleState.hashCode());
        result = result * 59 + (this.manifestSizeInBytes == null ? 43 : this.manifestSizeInBytes.hashCode());
        result = result * 59 + (this.pullCount == null ? 43 : this.pullCount.hashCode());
        result = result * 59 + (this.repositoryId == null ? 43 : this.repositoryId.hashCode());
        result = result * 59 + (this.repositoryName == null ? 43 : this.repositoryName.hashCode());
        result = result * 59 + (this.timeCreated == null ? 43 : this.timeCreated.hashCode());
        result = result * 59 + (this.timeLastPulled == null ? 43 : this.timeLastPulled.hashCode());
        result = result * 59 + (this.version == null ? 43 : this.version.hashCode());
        result = result * 59 + (this.versions == null ? 43 : this.versions.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum LifecycleState implements BmcEnum
    {
        Available("AVAILABLE"),
        Deleted("DELETED"),
        Deleting("DELETING"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, LifecycleState> map;

        private LifecycleState(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static LifecycleState create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'LifecycleState', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(LifecycleState.class);
            map = new HashMap<String, LifecycleState>();
            for (LifecycleState v : LifecycleState.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="compartmentId")
        private String compartmentId;
        @JsonProperty(value="createdBy")
        private String createdBy;
        @JsonProperty(value="digest")
        private String digest;
        @JsonProperty(value="displayName")
        private String displayName;
        @JsonProperty(value="id")
        private String id;
        @JsonProperty(value="layers")
        private List<ContainerImageLayer> layers;
        @JsonProperty(value="layersSizeInBytes")
        private Long layersSizeInBytes;
        @JsonProperty(value="lifecycleState")
        private LifecycleState lifecycleState;
        @JsonProperty(value="manifestSizeInBytes")
        private Integer manifestSizeInBytes;
        @JsonProperty(value="pullCount")
        private Long pullCount;
        @JsonProperty(value="repositoryId")
        private String repositoryId;
        @JsonProperty(value="repositoryName")
        private String repositoryName;
        @JsonProperty(value="timeCreated")
        private Date timeCreated;
        @JsonProperty(value="timeLastPulled")
        private Date timeLastPulled;
        @JsonProperty(value="version")
        private String version;
        @JsonProperty(value="versions")
        private List<ContainerVersion> versions;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            this.__explicitlySet__.add("compartmentId");
            return this;
        }

        public Builder createdBy(String createdBy) {
            this.createdBy = createdBy;
            this.__explicitlySet__.add("createdBy");
            return this;
        }

        public Builder digest(String digest) {
            this.digest = digest;
            this.__explicitlySet__.add("digest");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.__explicitlySet__.add("displayName");
            return this;
        }

        public Builder id(String id) {
            this.id = id;
            this.__explicitlySet__.add("id");
            return this;
        }

        public Builder layers(List<ContainerImageLayer> layers) {
            this.layers = layers;
            this.__explicitlySet__.add("layers");
            return this;
        }

        public Builder layersSizeInBytes(Long layersSizeInBytes) {
            this.layersSizeInBytes = layersSizeInBytes;
            this.__explicitlySet__.add("layersSizeInBytes");
            return this;
        }

        public Builder lifecycleState(LifecycleState lifecycleState) {
            this.lifecycleState = lifecycleState;
            this.__explicitlySet__.add("lifecycleState");
            return this;
        }

        public Builder manifestSizeInBytes(Integer manifestSizeInBytes) {
            this.manifestSizeInBytes = manifestSizeInBytes;
            this.__explicitlySet__.add("manifestSizeInBytes");
            return this;
        }

        public Builder pullCount(Long pullCount) {
            this.pullCount = pullCount;
            this.__explicitlySet__.add("pullCount");
            return this;
        }

        public Builder repositoryId(String repositoryId) {
            this.repositoryId = repositoryId;
            this.__explicitlySet__.add("repositoryId");
            return this;
        }

        public Builder repositoryName(String repositoryName) {
            this.repositoryName = repositoryName;
            this.__explicitlySet__.add("repositoryName");
            return this;
        }

        public Builder timeCreated(Date timeCreated) {
            this.timeCreated = timeCreated;
            this.__explicitlySet__.add("timeCreated");
            return this;
        }

        public Builder timeLastPulled(Date timeLastPulled) {
            this.timeLastPulled = timeLastPulled;
            this.__explicitlySet__.add("timeLastPulled");
            return this;
        }

        public Builder version(String version) {
            this.version = version;
            this.__explicitlySet__.add("version");
            return this;
        }

        public Builder versions(List<ContainerVersion> versions) {
            this.versions = versions;
            this.__explicitlySet__.add("versions");
            return this;
        }

        public ContainerImage build() {
            ContainerImage model = new ContainerImage(this.compartmentId, this.createdBy, this.digest, this.displayName, this.id, this.layers, this.layersSizeInBytes, this.lifecycleState, this.manifestSizeInBytes, this.pullCount, this.repositoryId, this.repositoryName, this.timeCreated, this.timeLastPulled, this.version, this.versions);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(ContainerImage model) {
            if (model.wasPropertyExplicitlySet("compartmentId")) {
                this.compartmentId(model.getCompartmentId());
            }
            if (model.wasPropertyExplicitlySet("createdBy")) {
                this.createdBy(model.getCreatedBy());
            }
            if (model.wasPropertyExplicitlySet("digest")) {
                this.digest(model.getDigest());
            }
            if (model.wasPropertyExplicitlySet("displayName")) {
                this.displayName(model.getDisplayName());
            }
            if (model.wasPropertyExplicitlySet("id")) {
                this.id(model.getId());
            }
            if (model.wasPropertyExplicitlySet("layers")) {
                this.layers(model.getLayers());
            }
            if (model.wasPropertyExplicitlySet("layersSizeInBytes")) {
                this.layersSizeInBytes(model.getLayersSizeInBytes());
            }
            if (model.wasPropertyExplicitlySet("lifecycleState")) {
                this.lifecycleState(model.getLifecycleState());
            }
            if (model.wasPropertyExplicitlySet("manifestSizeInBytes")) {
                this.manifestSizeInBytes(model.getManifestSizeInBytes());
            }
            if (model.wasPropertyExplicitlySet("pullCount")) {
                this.pullCount(model.getPullCount());
            }
            if (model.wasPropertyExplicitlySet("repositoryId")) {
                this.repositoryId(model.getRepositoryId());
            }
            if (model.wasPropertyExplicitlySet("repositoryName")) {
                this.repositoryName(model.getRepositoryName());
            }
            if (model.wasPropertyExplicitlySet("timeCreated")) {
                this.timeCreated(model.getTimeCreated());
            }
            if (model.wasPropertyExplicitlySet("timeLastPulled")) {
                this.timeLastPulled(model.getTimeLastPulled());
            }
            if (model.wasPropertyExplicitlySet("version")) {
                this.version(model.getVersion());
            }
            if (model.wasPropertyExplicitlySet("versions")) {
                this.versions(model.getVersions());
            }
            return this;
        }
    }
}

