/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.applicationmigration.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class ImportManifest
extends ExplicitlySetBmcModel {
    @JsonProperty(value="version")
    private final String version;
    @JsonProperty(value="exportType")
    private final String exportType;
    @JsonProperty(value="exportDetails")
    private final Object exportDetails;
    @JsonProperty(value="timestamp")
    private final Date timestamp;
    @JsonProperty(value="md5")
    private final String md5;
    @JsonProperty(value="signature")
    private final String signature;

    @Deprecated
    @ConstructorProperties(value={"version", "exportType", "exportDetails", "timestamp", "md5", "signature"})
    public ImportManifest(String version, String exportType, Object exportDetails, Date timestamp, String md5, String signature) {
        this.version = version;
        this.exportType = exportType;
        this.exportDetails = exportDetails;
        this.timestamp = timestamp;
        this.md5 = md5;
        this.signature = signature;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getVersion() {
        return this.version;
    }

    public String getExportType() {
        return this.exportType;
    }

    public Object getExportDetails() {
        return this.exportDetails;
    }

    public Date getTimestamp() {
        return this.timestamp;
    }

    public String getMd5() {
        return this.md5;
    }

    public String getSignature() {
        return this.signature;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("ImportManifest(");
        sb.append("super=").append(super.toString());
        sb.append("version=").append(String.valueOf(this.version));
        sb.append(", exportType=").append(String.valueOf(this.exportType));
        sb.append(", exportDetails=").append(String.valueOf(this.exportDetails));
        sb.append(", timestamp=").append(String.valueOf(this.timestamp));
        sb.append(", md5=").append(String.valueOf(this.md5));
        sb.append(", signature=").append(String.valueOf(this.signature));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ImportManifest)) {
            return false;
        }
        ImportManifest other = (ImportManifest)((Object)o);
        return Objects.equals(this.version, other.version) && Objects.equals(this.exportType, other.exportType) && Objects.equals(this.exportDetails, other.exportDetails) && Objects.equals(this.timestamp, other.timestamp) && Objects.equals(this.md5, other.md5) && Objects.equals(this.signature, other.signature) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.version == null ? 43 : this.version.hashCode());
        result = result * 59 + (this.exportType == null ? 43 : this.exportType.hashCode());
        result = result * 59 + (this.exportDetails == null ? 43 : this.exportDetails.hashCode());
        result = result * 59 + (this.timestamp == null ? 43 : this.timestamp.hashCode());
        result = result * 59 + (this.md5 == null ? 43 : this.md5.hashCode());
        result = result * 59 + (this.signature == null ? 43 : this.signature.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="version")
        private String version;
        @JsonProperty(value="exportType")
        private String exportType;
        @JsonProperty(value="exportDetails")
        private Object exportDetails;
        @JsonProperty(value="timestamp")
        private Date timestamp;
        @JsonProperty(value="md5")
        private String md5;
        @JsonProperty(value="signature")
        private String signature;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder version(String version) {
            this.version = version;
            this.__explicitlySet__.add("version");
            return this;
        }

        public Builder exportType(String exportType) {
            this.exportType = exportType;
            this.__explicitlySet__.add("exportType");
            return this;
        }

        public Builder exportDetails(Object exportDetails) {
            this.exportDetails = exportDetails;
            this.__explicitlySet__.add("exportDetails");
            return this;
        }

        public Builder timestamp(Date timestamp) {
            this.timestamp = timestamp;
            this.__explicitlySet__.add("timestamp");
            return this;
        }

        public Builder md5(String md5) {
            this.md5 = md5;
            this.__explicitlySet__.add("md5");
            return this;
        }

        public Builder signature(String signature) {
            this.signature = signature;
            this.__explicitlySet__.add("signature");
            return this;
        }

        public ImportManifest build() {
            ImportManifest model = new ImportManifest(this.version, this.exportType, this.exportDetails, this.timestamp, this.md5, this.signature);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(ImportManifest model) {
            if (model.wasPropertyExplicitlySet("version")) {
                this.version(model.getVersion());
            }
            if (model.wasPropertyExplicitlySet("exportType")) {
                this.exportType(model.getExportType());
            }
            if (model.wasPropertyExplicitlySet("exportDetails")) {
                this.exportDetails(model.getExportDetails());
            }
            if (model.wasPropertyExplicitlySet("timestamp")) {
                this.timestamp(model.getTimestamp());
            }
            if (model.wasPropertyExplicitlySet("md5")) {
                this.md5(model.getMd5());
            }
            if (model.wasPropertyExplicitlySet("signature")) {
                this.signature(model.getSignature());
            }
            return this;
        }
    }
}

