/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.applicationmigration;

import com.oracle.bmc.applicationmigration.ApplicationMigration;
import com.oracle.bmc.applicationmigration.model.MigrationLifecycleStates;
import com.oracle.bmc.applicationmigration.model.SourceLifecycleStates;
import com.oracle.bmc.applicationmigration.requests.GetMigrationRequest;
import com.oracle.bmc.applicationmigration.requests.GetSourceRequest;
import com.oracle.bmc.applicationmigration.requests.GetWorkRequestRequest;
import com.oracle.bmc.applicationmigration.responses.GetMigrationResponse;
import com.oracle.bmc.applicationmigration.responses.GetSourceResponse;
import com.oracle.bmc.applicationmigration.responses.GetWorkRequestResponse;
import com.oracle.bmc.util.internal.Validate;
import com.oracle.bmc.waiter.BmcGenericWaiter;
import com.oracle.bmc.waiter.DelayStrategy;
import com.oracle.bmc.waiter.TerminationStrategy;
import com.oracle.bmc.waiter.Waiter;
import com.oracle.bmc.waiter.Waiters;
import com.oracle.bmc.waiter.internal.SimpleWaiterImpl;
import java.util.Arrays;
import java.util.HashSet;
import java.util.concurrent.ExecutorService;
import java.util.function.Function;
import java.util.function.Predicate;

public class ApplicationMigrationWaiters {
    private final ExecutorService executorService;
    private final ApplicationMigration client;

    public ApplicationMigrationWaiters(ExecutorService executorService, ApplicationMigration client) {
        this.executorService = executorService;
        this.client = client;
    }

    public Waiter<GetMigrationRequest, GetMigrationResponse> forMigration(GetMigrationRequest request, MigrationLifecycleStates ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forMigration(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetMigrationRequest, GetMigrationResponse> forMigration(GetMigrationRequest request, MigrationLifecycleStates targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forMigration(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetMigrationRequest, GetMigrationResponse> forMigration(GetMigrationRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, MigrationLifecycleStates ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forMigration(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetMigrationRequest, GetMigrationResponse> forMigration(BmcGenericWaiter waiter, GetMigrationRequest request, MigrationLifecycleStates ... targetStates) {
        final HashSet<MigrationLifecycleStates> targetStatesSet = new HashSet<MigrationLifecycleStates>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetMigrationRequest, GetMigrationResponse>(){

            @Override
            public GetMigrationResponse apply(GetMigrationRequest request) {
                return ApplicationMigrationWaiters.this.client.getMigration(request);
            }
        }, (Predicate)new Predicate<GetMigrationResponse>(){

            @Override
            public boolean test(GetMigrationResponse response) {
                return targetStatesSet.contains((Object)response.getMigration().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)MigrationLifecycleStates.Deleted)), (Object)request);
    }

    public Waiter<GetSourceRequest, GetSourceResponse> forSource(GetSourceRequest request, SourceLifecycleStates ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forSource(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetSourceRequest, GetSourceResponse> forSource(GetSourceRequest request, SourceLifecycleStates targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forSource(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetSourceRequest, GetSourceResponse> forSource(GetSourceRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, SourceLifecycleStates ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forSource(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetSourceRequest, GetSourceResponse> forSource(BmcGenericWaiter waiter, GetSourceRequest request, SourceLifecycleStates ... targetStates) {
        final HashSet<SourceLifecycleStates> targetStatesSet = new HashSet<SourceLifecycleStates>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetSourceRequest, GetSourceResponse>(){

            @Override
            public GetSourceResponse apply(GetSourceRequest request) {
                return ApplicationMigrationWaiters.this.client.getSource(request);
            }
        }, (Predicate)new Predicate<GetSourceResponse>(){

            @Override
            public boolean test(GetSourceResponse response) {
                return targetStatesSet.contains((Object)response.getSource().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)SourceLifecycleStates.Deleted)), (Object)request);
    }

    public Waiter<GetWorkRequestRequest, GetWorkRequestResponse> forWorkRequest(GetWorkRequestRequest request) {
        return this.forWorkRequest(Waiters.DEFAULT_POLLING_WAITER, request);
    }

    public Waiter<GetWorkRequestRequest, GetWorkRequestResponse> forWorkRequest(GetWorkRequestRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        return this.forWorkRequest(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request);
    }

    private Waiter<GetWorkRequestRequest, GetWorkRequestResponse> forWorkRequest(BmcGenericWaiter waiter, GetWorkRequestRequest request) {
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetWorkRequestRequest, GetWorkRequestResponse>(){

            @Override
            public GetWorkRequestResponse apply(GetWorkRequestRequest request) {
                return ApplicationMigrationWaiters.this.client.getWorkRequest(request);
            }
        }, (Predicate)new Predicate<GetWorkRequestResponse>(){

            @Override
            public boolean test(GetWorkRequestResponse response) {
                return response.getWorkRequest().getTimeFinished() != null;
            }
        }, false), (Object)request);
    }
}

