/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.apmtraces.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.apmtraces.model.QueryDetails;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Date;
import java.util.Objects;

public class QueryRequest
extends BmcRequest<QueryDetails> {
    private String apmDomainId;
    private Date timeSpanStartedGreaterThanOrEqualTo;
    private Date timeSpanStartedLessThan;
    private QueryDetails queryDetails;
    private String opcRequestId;
    private Integer limit;
    private String page;

    public String getApmDomainId() {
        return this.apmDomainId;
    }

    public Date getTimeSpanStartedGreaterThanOrEqualTo() {
        return this.timeSpanStartedGreaterThanOrEqualTo;
    }

    public Date getTimeSpanStartedLessThan() {
        return this.timeSpanStartedLessThan;
    }

    public QueryDetails getQueryDetails() {
        return this.queryDetails;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public String getPage() {
        return this.page;
    }

    @InternalSdk
    public QueryDetails getBody$() {
        return this.queryDetails;
    }

    public Builder toBuilder() {
        return new Builder().apmDomainId(this.apmDomainId).timeSpanStartedGreaterThanOrEqualTo(this.timeSpanStartedGreaterThanOrEqualTo).timeSpanStartedLessThan(this.timeSpanStartedLessThan).queryDetails(this.queryDetails).opcRequestId(this.opcRequestId).limit(this.limit).page(this.page);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",apmDomainId=").append(String.valueOf(this.apmDomainId));
        sb.append(",timeSpanStartedGreaterThanOrEqualTo=").append(String.valueOf(this.timeSpanStartedGreaterThanOrEqualTo));
        sb.append(",timeSpanStartedLessThan=").append(String.valueOf(this.timeSpanStartedLessThan));
        sb.append(",queryDetails=").append(String.valueOf((Object)this.queryDetails));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",limit=").append(String.valueOf(this.limit));
        sb.append(",page=").append(String.valueOf(this.page));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof QueryRequest)) {
            return false;
        }
        QueryRequest other = (QueryRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.apmDomainId, other.apmDomainId) && Objects.equals(this.timeSpanStartedGreaterThanOrEqualTo, other.timeSpanStartedGreaterThanOrEqualTo) && Objects.equals(this.timeSpanStartedLessThan, other.timeSpanStartedLessThan) && Objects.equals((Object)this.queryDetails, (Object)other.queryDetails) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.limit, other.limit) && Objects.equals(this.page, other.page);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.apmDomainId == null ? 43 : this.apmDomainId.hashCode());
        result = result * 59 + (this.timeSpanStartedGreaterThanOrEqualTo == null ? 43 : this.timeSpanStartedGreaterThanOrEqualTo.hashCode());
        result = result * 59 + (this.timeSpanStartedLessThan == null ? 43 : this.timeSpanStartedLessThan.hashCode());
        result = result * 59 + (this.queryDetails == null ? 43 : this.queryDetails.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.limit == null ? 43 : this.limit.hashCode());
        result = result * 59 + (this.page == null ? 43 : this.page.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<QueryRequest, QueryDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String apmDomainId = null;
        private Date timeSpanStartedGreaterThanOrEqualTo = null;
        private Date timeSpanStartedLessThan = null;
        private QueryDetails queryDetails = null;
        private String opcRequestId = null;
        private Integer limit = null;
        private String page = null;

        public Builder apmDomainId(String apmDomainId) {
            this.apmDomainId = apmDomainId;
            return this;
        }

        public Builder timeSpanStartedGreaterThanOrEqualTo(Date timeSpanStartedGreaterThanOrEqualTo) {
            this.timeSpanStartedGreaterThanOrEqualTo = timeSpanStartedGreaterThanOrEqualTo;
            return this;
        }

        public Builder timeSpanStartedLessThan(Date timeSpanStartedLessThan) {
            this.timeSpanStartedLessThan = timeSpanStartedLessThan;
            return this;
        }

        public Builder queryDetails(QueryDetails queryDetails) {
            this.queryDetails = queryDetails;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(QueryRequest o) {
            this.apmDomainId(o.getApmDomainId());
            this.timeSpanStartedGreaterThanOrEqualTo(o.getTimeSpanStartedGreaterThanOrEqualTo());
            this.timeSpanStartedLessThan(o.getTimeSpanStartedLessThan());
            this.queryDetails(o.getQueryDetails());
            this.opcRequestId(o.getOpcRequestId());
            this.limit(o.getLimit());
            this.page(o.getPage());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public QueryRequest build() {
            QueryRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(QueryDetails body) {
            this.queryDetails(body);
            return this;
        }

        public QueryRequest buildWithoutInvocationCallback() {
            QueryRequest request = new QueryRequest();
            request.apmDomainId = this.apmDomainId;
            request.timeSpanStartedGreaterThanOrEqualTo = this.timeSpanStartedGreaterThanOrEqualTo;
            request.timeSpanStartedLessThan = this.timeSpanStartedLessThan;
            request.queryDetails = this.queryDetails;
            request.opcRequestId = this.opcRequestId;
            request.limit = this.limit;
            request.page = this.page;
            return request;
        }
    }
}

