/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.apmtraces.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class QueryResultRowTypeSummary
extends ExplicitlySetBmcModel {
    @JsonProperty(value="dataType")
    private final String dataType;
    @JsonProperty(value="unit")
    private final String unit;
    @JsonProperty(value="displayName")
    private final String displayName;
    @JsonProperty(value="expression")
    private final String expression;
    @JsonProperty(value="queryResultRowTypeSummaries")
    private final List<QueryResultRowTypeSummary> queryResultRowTypeSummaries;

    @Deprecated
    @ConstructorProperties(value={"dataType", "unit", "displayName", "expression", "queryResultRowTypeSummaries"})
    public QueryResultRowTypeSummary(String dataType, String unit, String displayName, String expression, List<QueryResultRowTypeSummary> queryResultRowTypeSummaries) {
        this.dataType = dataType;
        this.unit = unit;
        this.displayName = displayName;
        this.expression = expression;
        this.queryResultRowTypeSummaries = queryResultRowTypeSummaries;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getDataType() {
        return this.dataType;
    }

    public String getUnit() {
        return this.unit;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getExpression() {
        return this.expression;
    }

    public List<QueryResultRowTypeSummary> getQueryResultRowTypeSummaries() {
        return this.queryResultRowTypeSummaries;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("QueryResultRowTypeSummary(");
        sb.append("super=").append(super.toString());
        sb.append("dataType=").append(String.valueOf(this.dataType));
        sb.append(", unit=").append(String.valueOf(this.unit));
        sb.append(", displayName=").append(String.valueOf(this.displayName));
        sb.append(", expression=").append(String.valueOf(this.expression));
        sb.append(", queryResultRowTypeSummaries=").append(String.valueOf(this.queryResultRowTypeSummaries));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof QueryResultRowTypeSummary)) {
            return false;
        }
        QueryResultRowTypeSummary other = (QueryResultRowTypeSummary)((Object)o);
        return Objects.equals(this.dataType, other.dataType) && Objects.equals(this.unit, other.unit) && Objects.equals(this.displayName, other.displayName) && Objects.equals(this.expression, other.expression) && Objects.equals(this.queryResultRowTypeSummaries, other.queryResultRowTypeSummaries) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.dataType == null ? 43 : this.dataType.hashCode());
        result = result * 59 + (this.unit == null ? 43 : this.unit.hashCode());
        result = result * 59 + (this.displayName == null ? 43 : this.displayName.hashCode());
        result = result * 59 + (this.expression == null ? 43 : this.expression.hashCode());
        result = result * 59 + (this.queryResultRowTypeSummaries == null ? 43 : this.queryResultRowTypeSummaries.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="dataType")
        private String dataType;
        @JsonProperty(value="unit")
        private String unit;
        @JsonProperty(value="displayName")
        private String displayName;
        @JsonProperty(value="expression")
        private String expression;
        @JsonProperty(value="queryResultRowTypeSummaries")
        private List<QueryResultRowTypeSummary> queryResultRowTypeSummaries;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder dataType(String dataType) {
            this.dataType = dataType;
            this.__explicitlySet__.add("dataType");
            return this;
        }

        public Builder unit(String unit) {
            this.unit = unit;
            this.__explicitlySet__.add("unit");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.__explicitlySet__.add("displayName");
            return this;
        }

        public Builder expression(String expression) {
            this.expression = expression;
            this.__explicitlySet__.add("expression");
            return this;
        }

        public Builder queryResultRowTypeSummaries(List<QueryResultRowTypeSummary> queryResultRowTypeSummaries) {
            this.queryResultRowTypeSummaries = queryResultRowTypeSummaries;
            this.__explicitlySet__.add("queryResultRowTypeSummaries");
            return this;
        }

        public QueryResultRowTypeSummary build() {
            QueryResultRowTypeSummary model = new QueryResultRowTypeSummary(this.dataType, this.unit, this.displayName, this.expression, this.queryResultRowTypeSummaries);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(QueryResultRowTypeSummary model) {
            if (model.wasPropertyExplicitlySet("dataType")) {
                this.dataType(model.getDataType());
            }
            if (model.wasPropertyExplicitlySet("unit")) {
                this.unit(model.getUnit());
            }
            if (model.wasPropertyExplicitlySet("displayName")) {
                this.displayName(model.getDisplayName());
            }
            if (model.wasPropertyExplicitlySet("expression")) {
                this.expression(model.getExpression());
            }
            if (model.wasPropertyExplicitlySet("queryResultRowTypeSummaries")) {
                this.queryResultRowTypeSummaries(model.getQueryResultRowTypeSummaries());
            }
            return this;
        }
    }
}

