/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.apmtraces.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.apmtraces.model.StackTraceElement;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class AggregatedStackTrace
extends ExplicitlySetBmcModel {
    @JsonProperty(value="stackTraceElement")
    private final StackTraceElement stackTraceElement;
    @JsonProperty(value="children")
    private final List<AggregatedStackTrace> children;

    @Deprecated
    @ConstructorProperties(value={"stackTraceElement", "children"})
    public AggregatedStackTrace(StackTraceElement stackTraceElement, List<AggregatedStackTrace> children) {
        this.stackTraceElement = stackTraceElement;
        this.children = children;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public StackTraceElement getStackTraceElement() {
        return this.stackTraceElement;
    }

    public List<AggregatedStackTrace> getChildren() {
        return this.children;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("AggregatedStackTrace(");
        sb.append("super=").append(super.toString());
        sb.append("stackTraceElement=").append(String.valueOf((Object)this.stackTraceElement));
        sb.append(", children=").append(String.valueOf(this.children));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AggregatedStackTrace)) {
            return false;
        }
        AggregatedStackTrace other = (AggregatedStackTrace)((Object)o);
        return Objects.equals((Object)this.stackTraceElement, (Object)other.stackTraceElement) && Objects.equals(this.children, other.children) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.stackTraceElement == null ? 43 : this.stackTraceElement.hashCode());
        result = result * 59 + (this.children == null ? 43 : this.children.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="stackTraceElement")
        private StackTraceElement stackTraceElement;
        @JsonProperty(value="children")
        private List<AggregatedStackTrace> children;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder stackTraceElement(StackTraceElement stackTraceElement) {
            this.stackTraceElement = stackTraceElement;
            this.__explicitlySet__.add("stackTraceElement");
            return this;
        }

        public Builder children(List<AggregatedStackTrace> children) {
            this.children = children;
            this.__explicitlySet__.add("children");
            return this;
        }

        public AggregatedStackTrace build() {
            AggregatedStackTrace model = new AggregatedStackTrace(this.stackTraceElement, this.children);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(AggregatedStackTrace model) {
            if (model.wasPropertyExplicitlySet("stackTraceElement")) {
                this.stackTraceElement(model.getStackTraceElement());
            }
            if (model.wasPropertyExplicitlySet("children")) {
                this.children(model.getChildren());
            }
            return this;
        }
    }
}

