/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.apmsynthetics.requests;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.apmsynthetics.model.MonitorStatus;
import com.oracle.bmc.apmsynthetics.model.SortOrders;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class ListMonitorsRequest
extends BmcRequest<Void> {
    private String apmDomainId;
    private String displayName;
    private String scriptId;
    private String vantagePoint;
    private String monitorType;
    private MonitorStatus status;
    private Integer limit;
    private String page;
    private SortOrders sortOrder;
    private SortBy sortBy;
    private String opcRequestId;

    public String getApmDomainId() {
        return this.apmDomainId;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getScriptId() {
        return this.scriptId;
    }

    public String getVantagePoint() {
        return this.vantagePoint;
    }

    public String getMonitorType() {
        return this.monitorType;
    }

    public MonitorStatus getStatus() {
        return this.status;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public String getPage() {
        return this.page;
    }

    public SortOrders getSortOrder() {
        return this.sortOrder;
    }

    public SortBy getSortBy() {
        return this.sortBy;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().apmDomainId(this.apmDomainId).displayName(this.displayName).scriptId(this.scriptId).vantagePoint(this.vantagePoint).monitorType(this.monitorType).status(this.status).limit(this.limit).page(this.page).sortOrder(this.sortOrder).sortBy(this.sortBy).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",apmDomainId=").append(String.valueOf(this.apmDomainId));
        sb.append(",displayName=").append(String.valueOf(this.displayName));
        sb.append(",scriptId=").append(String.valueOf(this.scriptId));
        sb.append(",vantagePoint=").append(String.valueOf(this.vantagePoint));
        sb.append(",monitorType=").append(String.valueOf(this.monitorType));
        sb.append(",status=").append(String.valueOf((Object)this.status));
        sb.append(",limit=").append(String.valueOf(this.limit));
        sb.append(",page=").append(String.valueOf(this.page));
        sb.append(",sortOrder=").append(String.valueOf((Object)this.sortOrder));
        sb.append(",sortBy=").append(String.valueOf((Object)this.sortBy));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ListMonitorsRequest)) {
            return false;
        }
        ListMonitorsRequest other = (ListMonitorsRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.apmDomainId, other.apmDomainId) && Objects.equals(this.displayName, other.displayName) && Objects.equals(this.scriptId, other.scriptId) && Objects.equals(this.vantagePoint, other.vantagePoint) && Objects.equals(this.monitorType, other.monitorType) && Objects.equals((Object)this.status, (Object)other.status) && Objects.equals(this.limit, other.limit) && Objects.equals(this.page, other.page) && Objects.equals((Object)this.sortOrder, (Object)other.sortOrder) && Objects.equals((Object)this.sortBy, (Object)other.sortBy) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.apmDomainId == null ? 43 : this.apmDomainId.hashCode());
        result = result * 59 + (this.displayName == null ? 43 : this.displayName.hashCode());
        result = result * 59 + (this.scriptId == null ? 43 : this.scriptId.hashCode());
        result = result * 59 + (this.vantagePoint == null ? 43 : this.vantagePoint.hashCode());
        result = result * 59 + (this.monitorType == null ? 43 : this.monitorType.hashCode());
        result = result * 59 + (this.status == null ? 43 : this.status.hashCode());
        result = result * 59 + (this.limit == null ? 43 : this.limit.hashCode());
        result = result * 59 + (this.page == null ? 43 : this.page.hashCode());
        result = result * 59 + (this.sortOrder == null ? 43 : this.sortOrder.hashCode());
        result = result * 59 + (this.sortBy == null ? 43 : this.sortBy.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<ListMonitorsRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String apmDomainId = null;
        private String displayName = null;
        private String scriptId = null;
        private String vantagePoint = null;
        private String monitorType = null;
        private MonitorStatus status = null;
        private Integer limit = null;
        private String page = null;
        private SortOrders sortOrder = null;
        private SortBy sortBy = null;
        private String opcRequestId = null;

        public Builder apmDomainId(String apmDomainId) {
            this.apmDomainId = apmDomainId;
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public Builder scriptId(String scriptId) {
            this.scriptId = scriptId;
            return this;
        }

        public Builder vantagePoint(String vantagePoint) {
            this.vantagePoint = vantagePoint;
            return this;
        }

        public Builder monitorType(String monitorType) {
            this.monitorType = monitorType;
            return this;
        }

        public Builder status(MonitorStatus status) {
            this.status = status;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder sortOrder(SortOrders sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        public Builder sortBy(SortBy sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ListMonitorsRequest o) {
            this.apmDomainId(o.getApmDomainId());
            this.displayName(o.getDisplayName());
            this.scriptId(o.getScriptId());
            this.vantagePoint(o.getVantagePoint());
            this.monitorType(o.getMonitorType());
            this.status(o.getStatus());
            this.limit(o.getLimit());
            this.page(o.getPage());
            this.sortOrder(o.getSortOrder());
            this.sortBy(o.getSortBy());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ListMonitorsRequest build() {
            ListMonitorsRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public ListMonitorsRequest buildWithoutInvocationCallback() {
            ListMonitorsRequest request = new ListMonitorsRequest();
            request.apmDomainId = this.apmDomainId;
            request.displayName = this.displayName;
            request.scriptId = this.scriptId;
            request.vantagePoint = this.vantagePoint;
            request.monitorType = this.monitorType;
            request.status = this.status;
            request.limit = this.limit;
            request.page = this.page;
            request.sortOrder = this.sortOrder;
            request.sortBy = this.sortBy;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }

    public static enum SortBy implements BmcEnum
    {
        DisplayName("displayName"),
        TimeCreated("timeCreated"),
        TimeUpdated("timeUpdated"),
        Status("status"),
        MonitorType("monitorType");

        private final String value;
        private static Map<String, SortBy> map;

        private SortBy(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SortBy create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SortBy: " + key);
        }

        static {
            map = new HashMap<String, SortBy>();
            for (SortBy v : SortBy.values()) {
                map.put(v.getValue(), v);
            }
        }
    }
}

