/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.apmsynthetics.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class GetMonitorResultRequest
extends BmcRequest<Void> {
    private String apmDomainId;
    private String monitorId;
    private String vantagePoint;
    private String resultType;
    private String resultContentType;
    private String executionTime;
    private String opcRequestId;

    public String getApmDomainId() {
        return this.apmDomainId;
    }

    public String getMonitorId() {
        return this.monitorId;
    }

    public String getVantagePoint() {
        return this.vantagePoint;
    }

    public String getResultType() {
        return this.resultType;
    }

    public String getResultContentType() {
        return this.resultContentType;
    }

    public String getExecutionTime() {
        return this.executionTime;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().apmDomainId(this.apmDomainId).monitorId(this.monitorId).vantagePoint(this.vantagePoint).resultType(this.resultType).resultContentType(this.resultContentType).executionTime(this.executionTime).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",apmDomainId=").append(String.valueOf(this.apmDomainId));
        sb.append(",monitorId=").append(String.valueOf(this.monitorId));
        sb.append(",vantagePoint=").append(String.valueOf(this.vantagePoint));
        sb.append(",resultType=").append(String.valueOf(this.resultType));
        sb.append(",resultContentType=").append(String.valueOf(this.resultContentType));
        sb.append(",executionTime=").append(String.valueOf(this.executionTime));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetMonitorResultRequest)) {
            return false;
        }
        GetMonitorResultRequest other = (GetMonitorResultRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.apmDomainId, other.apmDomainId) && Objects.equals(this.monitorId, other.monitorId) && Objects.equals(this.vantagePoint, other.vantagePoint) && Objects.equals(this.resultType, other.resultType) && Objects.equals(this.resultContentType, other.resultContentType) && Objects.equals(this.executionTime, other.executionTime) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.apmDomainId == null ? 43 : this.apmDomainId.hashCode());
        result = result * 59 + (this.monitorId == null ? 43 : this.monitorId.hashCode());
        result = result * 59 + (this.vantagePoint == null ? 43 : this.vantagePoint.hashCode());
        result = result * 59 + (this.resultType == null ? 43 : this.resultType.hashCode());
        result = result * 59 + (this.resultContentType == null ? 43 : this.resultContentType.hashCode());
        result = result * 59 + (this.executionTime == null ? 43 : this.executionTime.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<GetMonitorResultRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String apmDomainId = null;
        private String monitorId = null;
        private String vantagePoint = null;
        private String resultType = null;
        private String resultContentType = null;
        private String executionTime = null;
        private String opcRequestId = null;

        public Builder apmDomainId(String apmDomainId) {
            this.apmDomainId = apmDomainId;
            return this;
        }

        public Builder monitorId(String monitorId) {
            this.monitorId = monitorId;
            return this;
        }

        public Builder vantagePoint(String vantagePoint) {
            this.vantagePoint = vantagePoint;
            return this;
        }

        public Builder resultType(String resultType) {
            this.resultType = resultType;
            return this;
        }

        public Builder resultContentType(String resultContentType) {
            this.resultContentType = resultContentType;
            return this;
        }

        public Builder executionTime(String executionTime) {
            this.executionTime = executionTime;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetMonitorResultRequest o) {
            this.apmDomainId(o.getApmDomainId());
            this.monitorId(o.getMonitorId());
            this.vantagePoint(o.getVantagePoint());
            this.resultType(o.getResultType());
            this.resultContentType(o.getResultContentType());
            this.executionTime(o.getExecutionTime());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetMonitorResultRequest build() {
            GetMonitorResultRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public GetMonitorResultRequest buildWithoutInvocationCallback() {
            GetMonitorResultRequest request = new GetMonitorResultRequest();
            request.apmDomainId = this.apmDomainId;
            request.monitorId = this.monitorId;
            request.vantagePoint = this.vantagePoint;
            request.resultType = this.resultType;
            request.resultContentType = this.resultContentType;
            request.executionTime = this.executionTime;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

