/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.apmsynthetics.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.apmsynthetics.model.Header;
import com.oracle.bmc.apmsynthetics.model.OAuthSchemes;
import com.oracle.bmc.apmsynthetics.model.RequestMethods;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class RequestAuthenticationDetails
extends ExplicitlySetBmcModel {
    @JsonProperty(value="oauthScheme")
    private final OAuthSchemes oauthScheme;
    @JsonProperty(value="authUserName")
    private final String authUserName;
    @JsonProperty(value="authUserPassword")
    private final String authUserPassword;
    @JsonProperty(value="authToken")
    private final String authToken;
    @JsonProperty(value="authUrl")
    private final String authUrl;
    @JsonProperty(value="authHeaders")
    private final List<Header> authHeaders;
    @JsonProperty(value="authRequestMethod")
    private final RequestMethods authRequestMethod;
    @JsonProperty(value="authRequestPostBody")
    private final String authRequestPostBody;

    @Deprecated
    @ConstructorProperties(value={"oauthScheme", "authUserName", "authUserPassword", "authToken", "authUrl", "authHeaders", "authRequestMethod", "authRequestPostBody"})
    public RequestAuthenticationDetails(OAuthSchemes oauthScheme, String authUserName, String authUserPassword, String authToken, String authUrl, List<Header> authHeaders, RequestMethods authRequestMethod, String authRequestPostBody) {
        this.oauthScheme = oauthScheme;
        this.authUserName = authUserName;
        this.authUserPassword = authUserPassword;
        this.authToken = authToken;
        this.authUrl = authUrl;
        this.authHeaders = authHeaders;
        this.authRequestMethod = authRequestMethod;
        this.authRequestPostBody = authRequestPostBody;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public OAuthSchemes getOauthScheme() {
        return this.oauthScheme;
    }

    public String getAuthUserName() {
        return this.authUserName;
    }

    public String getAuthUserPassword() {
        return this.authUserPassword;
    }

    public String getAuthToken() {
        return this.authToken;
    }

    public String getAuthUrl() {
        return this.authUrl;
    }

    public List<Header> getAuthHeaders() {
        return this.authHeaders;
    }

    public RequestMethods getAuthRequestMethod() {
        return this.authRequestMethod;
    }

    public String getAuthRequestPostBody() {
        return this.authRequestPostBody;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("RequestAuthenticationDetails(");
        sb.append("super=").append(super.toString());
        sb.append("oauthScheme=").append(String.valueOf((Object)this.oauthScheme));
        sb.append(", authUserName=").append(String.valueOf(this.authUserName));
        sb.append(", authUserPassword=").append(String.valueOf(this.authUserPassword));
        sb.append(", authToken=").append(String.valueOf(this.authToken));
        sb.append(", authUrl=").append(String.valueOf(this.authUrl));
        sb.append(", authHeaders=").append(String.valueOf(this.authHeaders));
        sb.append(", authRequestMethod=").append(String.valueOf((Object)this.authRequestMethod));
        sb.append(", authRequestPostBody=").append(String.valueOf(this.authRequestPostBody));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RequestAuthenticationDetails)) {
            return false;
        }
        RequestAuthenticationDetails other = (RequestAuthenticationDetails)((Object)o);
        return Objects.equals((Object)this.oauthScheme, (Object)other.oauthScheme) && Objects.equals(this.authUserName, other.authUserName) && Objects.equals(this.authUserPassword, other.authUserPassword) && Objects.equals(this.authToken, other.authToken) && Objects.equals(this.authUrl, other.authUrl) && Objects.equals(this.authHeaders, other.authHeaders) && Objects.equals((Object)this.authRequestMethod, (Object)other.authRequestMethod) && Objects.equals(this.authRequestPostBody, other.authRequestPostBody) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.oauthScheme == null ? 43 : this.oauthScheme.hashCode());
        result = result * 59 + (this.authUserName == null ? 43 : this.authUserName.hashCode());
        result = result * 59 + (this.authUserPassword == null ? 43 : this.authUserPassword.hashCode());
        result = result * 59 + (this.authToken == null ? 43 : this.authToken.hashCode());
        result = result * 59 + (this.authUrl == null ? 43 : this.authUrl.hashCode());
        result = result * 59 + (this.authHeaders == null ? 43 : this.authHeaders.hashCode());
        result = result * 59 + (this.authRequestMethod == null ? 43 : this.authRequestMethod.hashCode());
        result = result * 59 + (this.authRequestPostBody == null ? 43 : this.authRequestPostBody.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="oauthScheme")
        private OAuthSchemes oauthScheme;
        @JsonProperty(value="authUserName")
        private String authUserName;
        @JsonProperty(value="authUserPassword")
        private String authUserPassword;
        @JsonProperty(value="authToken")
        private String authToken;
        @JsonProperty(value="authUrl")
        private String authUrl;
        @JsonProperty(value="authHeaders")
        private List<Header> authHeaders;
        @JsonProperty(value="authRequestMethod")
        private RequestMethods authRequestMethod;
        @JsonProperty(value="authRequestPostBody")
        private String authRequestPostBody;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder oauthScheme(OAuthSchemes oauthScheme) {
            this.oauthScheme = oauthScheme;
            this.__explicitlySet__.add("oauthScheme");
            return this;
        }

        public Builder authUserName(String authUserName) {
            this.authUserName = authUserName;
            this.__explicitlySet__.add("authUserName");
            return this;
        }

        public Builder authUserPassword(String authUserPassword) {
            this.authUserPassword = authUserPassword;
            this.__explicitlySet__.add("authUserPassword");
            return this;
        }

        public Builder authToken(String authToken) {
            this.authToken = authToken;
            this.__explicitlySet__.add("authToken");
            return this;
        }

        public Builder authUrl(String authUrl) {
            this.authUrl = authUrl;
            this.__explicitlySet__.add("authUrl");
            return this;
        }

        public Builder authHeaders(List<Header> authHeaders) {
            this.authHeaders = authHeaders;
            this.__explicitlySet__.add("authHeaders");
            return this;
        }

        public Builder authRequestMethod(RequestMethods authRequestMethod) {
            this.authRequestMethod = authRequestMethod;
            this.__explicitlySet__.add("authRequestMethod");
            return this;
        }

        public Builder authRequestPostBody(String authRequestPostBody) {
            this.authRequestPostBody = authRequestPostBody;
            this.__explicitlySet__.add("authRequestPostBody");
            return this;
        }

        public RequestAuthenticationDetails build() {
            RequestAuthenticationDetails model = new RequestAuthenticationDetails(this.oauthScheme, this.authUserName, this.authUserPassword, this.authToken, this.authUrl, this.authHeaders, this.authRequestMethod, this.authRequestPostBody);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(RequestAuthenticationDetails model) {
            if (model.wasPropertyExplicitlySet("oauthScheme")) {
                this.oauthScheme(model.getOauthScheme());
            }
            if (model.wasPropertyExplicitlySet("authUserName")) {
                this.authUserName(model.getAuthUserName());
            }
            if (model.wasPropertyExplicitlySet("authUserPassword")) {
                this.authUserPassword(model.getAuthUserPassword());
            }
            if (model.wasPropertyExplicitlySet("authToken")) {
                this.authToken(model.getAuthToken());
            }
            if (model.wasPropertyExplicitlySet("authUrl")) {
                this.authUrl(model.getAuthUrl());
            }
            if (model.wasPropertyExplicitlySet("authHeaders")) {
                this.authHeaders(model.getAuthHeaders());
            }
            if (model.wasPropertyExplicitlySet("authRequestMethod")) {
                this.authRequestMethod(model.getAuthRequestMethod());
            }
            if (model.wasPropertyExplicitlySet("authRequestPostBody")) {
                this.authRequestPostBody(model.getAuthRequestPostBody());
            }
            return this;
        }
    }
}

