/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.apmconfig.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.apmconfig.model.ValidateSpanFilterPatternDetails;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class ValidateSpanFilterPatternRequest
extends BmcRequest<ValidateSpanFilterPatternDetails> {
    private String apmDomainId;
    private ValidateSpanFilterPatternDetails validateSpanFilterPatternDetails;
    private String opcRequestId;

    public String getApmDomainId() {
        return this.apmDomainId;
    }

    public ValidateSpanFilterPatternDetails getValidateSpanFilterPatternDetails() {
        return this.validateSpanFilterPatternDetails;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    @InternalSdk
    public ValidateSpanFilterPatternDetails getBody$() {
        return this.validateSpanFilterPatternDetails;
    }

    public Builder toBuilder() {
        return new Builder().apmDomainId(this.apmDomainId).validateSpanFilterPatternDetails(this.validateSpanFilterPatternDetails).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",apmDomainId=").append(String.valueOf(this.apmDomainId));
        sb.append(",validateSpanFilterPatternDetails=").append(String.valueOf((Object)this.validateSpanFilterPatternDetails));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ValidateSpanFilterPatternRequest)) {
            return false;
        }
        ValidateSpanFilterPatternRequest other = (ValidateSpanFilterPatternRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.apmDomainId, other.apmDomainId) && Objects.equals((Object)this.validateSpanFilterPatternDetails, (Object)other.validateSpanFilterPatternDetails) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.apmDomainId == null ? 43 : this.apmDomainId.hashCode());
        result = result * 59 + (this.validateSpanFilterPatternDetails == null ? 43 : this.validateSpanFilterPatternDetails.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<ValidateSpanFilterPatternRequest, ValidateSpanFilterPatternDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String apmDomainId = null;
        private ValidateSpanFilterPatternDetails validateSpanFilterPatternDetails = null;
        private String opcRequestId = null;

        public Builder apmDomainId(String apmDomainId) {
            this.apmDomainId = apmDomainId;
            return this;
        }

        public Builder validateSpanFilterPatternDetails(ValidateSpanFilterPatternDetails validateSpanFilterPatternDetails) {
            this.validateSpanFilterPatternDetails = validateSpanFilterPatternDetails;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ValidateSpanFilterPatternRequest o) {
            this.apmDomainId(o.getApmDomainId());
            this.validateSpanFilterPatternDetails(o.getValidateSpanFilterPatternDetails());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ValidateSpanFilterPatternRequest build() {
            ValidateSpanFilterPatternRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(ValidateSpanFilterPatternDetails body) {
            this.validateSpanFilterPatternDetails(body);
            return this;
        }

        public ValidateSpanFilterPatternRequest buildWithoutInvocationCallback() {
            ValidateSpanFilterPatternRequest request = new ValidateSpanFilterPatternRequest();
            request.apmDomainId = this.apmDomainId;
            request.validateSpanFilterPatternDetails = this.validateSpanFilterPatternDetails;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

