/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.apmconfig;

import com.oracle.bmc.apmconfig.Config;
import com.oracle.bmc.apmconfig.model.ConfigSummary;
import com.oracle.bmc.apmconfig.requests.ListConfigsRequest;
import com.oracle.bmc.apmconfig.responses.ListConfigsResponse;
import com.oracle.bmc.paginator.internal.RequestBuilderAndToken;
import com.oracle.bmc.paginator.internal.ResponseIterable;
import com.oracle.bmc.paginator.internal.ResponseRecordIterable;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;

public class ConfigPaginators {
    private final Config client;

    public ConfigPaginators(Config client) {
        this.client = client;
    }

    public Iterable<ListConfigsResponse> listConfigsResponseIterator(final ListConfigsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListConfigsRequest.Builder>(){

            @Override
            public ListConfigsRequest.Builder get() {
                return ListConfigsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListConfigsResponse, String>(){

            @Override
            public String apply(ListConfigsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListConfigsRequest.Builder>, ListConfigsRequest>(){

            @Override
            public ListConfigsRequest apply(RequestBuilderAndToken<ListConfigsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListConfigsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListConfigsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListConfigsRequest, ListConfigsResponse>(){

            @Override
            public ListConfigsResponse apply(ListConfigsRequest request) {
                return ConfigPaginators.this.client.listConfigs(request);
            }
        });
    }

    public Iterable<ConfigSummary> listConfigsRecordIterator(final ListConfigsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListConfigsRequest.Builder>(){

            @Override
            public ListConfigsRequest.Builder get() {
                return ListConfigsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListConfigsResponse, String>(){

            @Override
            public String apply(ListConfigsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListConfigsRequest.Builder>, ListConfigsRequest>(){

            @Override
            public ListConfigsRequest apply(RequestBuilderAndToken<ListConfigsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListConfigsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListConfigsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListConfigsRequest, ListConfigsResponse>(){

            @Override
            public ListConfigsResponse apply(ListConfigsRequest request) {
                return ConfigPaginators.this.client.listConfigs(request);
            }
        }, (Function)new Function<ListConfigsResponse, List<ConfigSummary>>(){

            @Override
            public List<ConfigSummary> apply(ListConfigsResponse response) {
                return response.getConfigCollection().getItems();
            }
        });
    }
}

