/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.apigateway.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.apigateway.model.UpdateSubscriberDetails;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class UpdateSubscriberRequest
extends BmcRequest<UpdateSubscriberDetails> {
    private String subscriberId;
    private UpdateSubscriberDetails updateSubscriberDetails;
    private String ifMatch;
    private String opcRequestId;

    public String getSubscriberId() {
        return this.subscriberId;
    }

    public UpdateSubscriberDetails getUpdateSubscriberDetails() {
        return this.updateSubscriberDetails;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    @InternalSdk
    public UpdateSubscriberDetails getBody$() {
        return this.updateSubscriberDetails;
    }

    public Builder toBuilder() {
        return new Builder().subscriberId(this.subscriberId).updateSubscriberDetails(this.updateSubscriberDetails).ifMatch(this.ifMatch).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",subscriberId=").append(String.valueOf(this.subscriberId));
        sb.append(",updateSubscriberDetails=").append(String.valueOf((Object)this.updateSubscriberDetails));
        sb.append(",ifMatch=").append(String.valueOf(this.ifMatch));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UpdateSubscriberRequest)) {
            return false;
        }
        UpdateSubscriberRequest other = (UpdateSubscriberRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.subscriberId, other.subscriberId) && Objects.equals((Object)this.updateSubscriberDetails, (Object)other.updateSubscriberDetails) && Objects.equals(this.ifMatch, other.ifMatch) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.subscriberId == null ? 43 : this.subscriberId.hashCode());
        result = result * 59 + (this.updateSubscriberDetails == null ? 43 : this.updateSubscriberDetails.hashCode());
        result = result * 59 + (this.ifMatch == null ? 43 : this.ifMatch.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<UpdateSubscriberRequest, UpdateSubscriberDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String subscriberId = null;
        private UpdateSubscriberDetails updateSubscriberDetails = null;
        private String ifMatch = null;
        private String opcRequestId = null;

        public Builder subscriberId(String subscriberId) {
            this.subscriberId = subscriberId;
            return this;
        }

        public Builder updateSubscriberDetails(UpdateSubscriberDetails updateSubscriberDetails) {
            this.updateSubscriberDetails = updateSubscriberDetails;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(UpdateSubscriberRequest o) {
            this.subscriberId(o.getSubscriberId());
            this.updateSubscriberDetails(o.getUpdateSubscriberDetails());
            this.ifMatch(o.getIfMatch());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public UpdateSubscriberRequest build() {
            UpdateSubscriberRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(UpdateSubscriberDetails body) {
            this.updateSubscriberDetails(body);
            return this;
        }

        public UpdateSubscriberRequest buildWithoutInvocationCallback() {
            UpdateSubscriberRequest request = new UpdateSubscriberRequest();
            request.subscriberId = this.subscriberId;
            request.updateSubscriberDetails = this.updateSubscriberDetails;
            request.ifMatch = this.ifMatch;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

