/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.apigateway.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.apigateway.model.WorkRequest;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class WorkRequestSummary
extends ExplicitlySetBmcModel {
    @JsonProperty(value="operationType")
    private final WorkRequest.OperationType operationType;
    @JsonProperty(value="status")
    private final WorkRequest.Status status;
    @JsonProperty(value="workRequestId")
    private final String workRequestId;
    @JsonProperty(value="compartmentId")
    private final String compartmentId;
    @JsonProperty(value="percentComplete")
    private final Float percentComplete;
    @JsonProperty(value="timeAccepted")
    private final Date timeAccepted;
    @JsonProperty(value="timeStarted")
    private final Date timeStarted;
    @JsonProperty(value="timeFinished")
    private final Date timeFinished;

    @Deprecated
    @ConstructorProperties(value={"operationType", "status", "workRequestId", "compartmentId", "percentComplete", "timeAccepted", "timeStarted", "timeFinished"})
    public WorkRequestSummary(WorkRequest.OperationType operationType, WorkRequest.Status status, String workRequestId, String compartmentId, Float percentComplete, Date timeAccepted, Date timeStarted, Date timeFinished) {
        this.operationType = operationType;
        this.status = status;
        this.workRequestId = workRequestId;
        this.compartmentId = compartmentId;
        this.percentComplete = percentComplete;
        this.timeAccepted = timeAccepted;
        this.timeStarted = timeStarted;
        this.timeFinished = timeFinished;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public WorkRequest.OperationType getOperationType() {
        return this.operationType;
    }

    public WorkRequest.Status getStatus() {
        return this.status;
    }

    public String getWorkRequestId() {
        return this.workRequestId;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public Float getPercentComplete() {
        return this.percentComplete;
    }

    public Date getTimeAccepted() {
        return this.timeAccepted;
    }

    public Date getTimeStarted() {
        return this.timeStarted;
    }

    public Date getTimeFinished() {
        return this.timeFinished;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("WorkRequestSummary(");
        sb.append("super=").append(super.toString());
        sb.append("operationType=").append(String.valueOf((Object)this.operationType));
        sb.append(", status=").append(String.valueOf((Object)this.status));
        sb.append(", workRequestId=").append(String.valueOf(this.workRequestId));
        sb.append(", compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(", percentComplete=").append(String.valueOf(this.percentComplete));
        sb.append(", timeAccepted=").append(String.valueOf(this.timeAccepted));
        sb.append(", timeStarted=").append(String.valueOf(this.timeStarted));
        sb.append(", timeFinished=").append(String.valueOf(this.timeFinished));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof WorkRequestSummary)) {
            return false;
        }
        WorkRequestSummary other = (WorkRequestSummary)((Object)o);
        return Objects.equals((Object)this.operationType, (Object)other.operationType) && Objects.equals((Object)this.status, (Object)other.status) && Objects.equals(this.workRequestId, other.workRequestId) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals(this.percentComplete, other.percentComplete) && Objects.equals(this.timeAccepted, other.timeAccepted) && Objects.equals(this.timeStarted, other.timeStarted) && Objects.equals(this.timeFinished, other.timeFinished) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.operationType == null ? 43 : this.operationType.hashCode());
        result = result * 59 + (this.status == null ? 43 : this.status.hashCode());
        result = result * 59 + (this.workRequestId == null ? 43 : this.workRequestId.hashCode());
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.percentComplete == null ? 43 : this.percentComplete.hashCode());
        result = result * 59 + (this.timeAccepted == null ? 43 : this.timeAccepted.hashCode());
        result = result * 59 + (this.timeStarted == null ? 43 : this.timeStarted.hashCode());
        result = result * 59 + (this.timeFinished == null ? 43 : this.timeFinished.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="operationType")
        private WorkRequest.OperationType operationType;
        @JsonProperty(value="status")
        private WorkRequest.Status status;
        @JsonProperty(value="workRequestId")
        private String workRequestId;
        @JsonProperty(value="compartmentId")
        private String compartmentId;
        @JsonProperty(value="percentComplete")
        private Float percentComplete;
        @JsonProperty(value="timeAccepted")
        private Date timeAccepted;
        @JsonProperty(value="timeStarted")
        private Date timeStarted;
        @JsonProperty(value="timeFinished")
        private Date timeFinished;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder operationType(WorkRequest.OperationType operationType) {
            this.operationType = operationType;
            this.__explicitlySet__.add("operationType");
            return this;
        }

        public Builder status(WorkRequest.Status status) {
            this.status = status;
            this.__explicitlySet__.add("status");
            return this;
        }

        public Builder workRequestId(String workRequestId) {
            this.workRequestId = workRequestId;
            this.__explicitlySet__.add("workRequestId");
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            this.__explicitlySet__.add("compartmentId");
            return this;
        }

        public Builder percentComplete(Float percentComplete) {
            this.percentComplete = percentComplete;
            this.__explicitlySet__.add("percentComplete");
            return this;
        }

        public Builder timeAccepted(Date timeAccepted) {
            this.timeAccepted = timeAccepted;
            this.__explicitlySet__.add("timeAccepted");
            return this;
        }

        public Builder timeStarted(Date timeStarted) {
            this.timeStarted = timeStarted;
            this.__explicitlySet__.add("timeStarted");
            return this;
        }

        public Builder timeFinished(Date timeFinished) {
            this.timeFinished = timeFinished;
            this.__explicitlySet__.add("timeFinished");
            return this;
        }

        public WorkRequestSummary build() {
            WorkRequestSummary model = new WorkRequestSummary(this.operationType, this.status, this.workRequestId, this.compartmentId, this.percentComplete, this.timeAccepted, this.timeStarted, this.timeFinished);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(WorkRequestSummary model) {
            if (model.wasPropertyExplicitlySet("operationType")) {
                this.operationType(model.getOperationType());
            }
            if (model.wasPropertyExplicitlySet("status")) {
                this.status(model.getStatus());
            }
            if (model.wasPropertyExplicitlySet("workRequestId")) {
                this.workRequestId(model.getWorkRequestId());
            }
            if (model.wasPropertyExplicitlySet("compartmentId")) {
                this.compartmentId(model.getCompartmentId());
            }
            if (model.wasPropertyExplicitlySet("percentComplete")) {
                this.percentComplete(model.getPercentComplete());
            }
            if (model.wasPropertyExplicitlySet("timeAccepted")) {
                this.timeAccepted(model.getTimeAccepted());
            }
            if (model.wasPropertyExplicitlySet("timeStarted")) {
                this.timeStarted(model.getTimeStarted());
            }
            if (model.wasPropertyExplicitlySet("timeFinished")) {
                this.timeFinished(model.getTimeFinished());
            }
            return this;
        }
    }
}

