/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.apigateway.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.apigateway.model.JsonWebKey;
import com.oracle.bmc.apigateway.model.PemEncodedPublicKey;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="format", defaultImpl=StaticPublicKey.class)
@JsonSubTypes(value={@JsonSubTypes.Type(value=JsonWebKey.class, name="JSON_WEB_KEY"), @JsonSubTypes.Type(value=PemEncodedPublicKey.class, name="PEM")})
@JsonFilter(value="explicitlySetFilter")
public class StaticPublicKey
extends ExplicitlySetBmcModel {
    @JsonProperty(value="kid")
    private final String kid;

    @Deprecated
    @ConstructorProperties(value={"kid"})
    protected StaticPublicKey(String kid) {
        this.kid = kid;
    }

    public String getKid() {
        return this.kid;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("StaticPublicKey(");
        sb.append("super=").append(super.toString());
        sb.append("kid=").append(String.valueOf(this.kid));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof StaticPublicKey)) {
            return false;
        }
        StaticPublicKey other = (StaticPublicKey)((Object)o);
        return Objects.equals(this.kid, other.kid) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.kid == null ? 43 : this.kid.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum Format implements BmcEnum
    {
        JsonWebKey("JSON_WEB_KEY"),
        Pem("PEM"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, Format> map;

        private Format(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Format create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'Format', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(Format.class);
            map = new HashMap<String, Format>();
            for (Format v : Format.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }
}

