/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.apigateway.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.apigateway.model.AuthenticationPolicy;
import com.oracle.bmc.apigateway.model.JsonWebTokenClaim;
import com.oracle.bmc.apigateway.model.PublicKeySet;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="type")
@JsonFilter(value="explicitlySetFilter")
public final class JwtAuthenticationPolicy
extends AuthenticationPolicy {
    @JsonProperty(value="tokenHeader")
    private final String tokenHeader;
    @JsonProperty(value="tokenQueryParam")
    private final String tokenQueryParam;
    @JsonProperty(value="tokenAuthScheme")
    private final String tokenAuthScheme;
    @JsonProperty(value="maxClockSkewInSeconds")
    private final Float maxClockSkewInSeconds;
    @JsonProperty(value="issuers")
    private final List<String> issuers;
    @JsonProperty(value="audiences")
    private final List<String> audiences;
    @JsonProperty(value="verifyClaims")
    private final List<JsonWebTokenClaim> verifyClaims;
    @JsonProperty(value="publicKeys")
    private final PublicKeySet publicKeys;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public JwtAuthenticationPolicy(Boolean isAnonymousAccessAllowed, String tokenHeader, String tokenQueryParam, String tokenAuthScheme, Float maxClockSkewInSeconds, List<String> issuers, List<String> audiences, List<JsonWebTokenClaim> verifyClaims, PublicKeySet publicKeys) {
        super(isAnonymousAccessAllowed);
        this.tokenHeader = tokenHeader;
        this.tokenQueryParam = tokenQueryParam;
        this.tokenAuthScheme = tokenAuthScheme;
        this.maxClockSkewInSeconds = maxClockSkewInSeconds;
        this.issuers = issuers;
        this.audiences = audiences;
        this.verifyClaims = verifyClaims;
        this.publicKeys = publicKeys;
    }

    public String getTokenHeader() {
        return this.tokenHeader;
    }

    public String getTokenQueryParam() {
        return this.tokenQueryParam;
    }

    public String getTokenAuthScheme() {
        return this.tokenAuthScheme;
    }

    public Float getMaxClockSkewInSeconds() {
        return this.maxClockSkewInSeconds;
    }

    public List<String> getIssuers() {
        return this.issuers;
    }

    public List<String> getAudiences() {
        return this.audiences;
    }

    public List<JsonWebTokenClaim> getVerifyClaims() {
        return this.verifyClaims;
    }

    public PublicKeySet getPublicKeys() {
        return this.publicKeys;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("JwtAuthenticationPolicy(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", tokenHeader=").append(String.valueOf(this.tokenHeader));
        sb.append(", tokenQueryParam=").append(String.valueOf(this.tokenQueryParam));
        sb.append(", tokenAuthScheme=").append(String.valueOf(this.tokenAuthScheme));
        sb.append(", maxClockSkewInSeconds=").append(String.valueOf(this.maxClockSkewInSeconds));
        sb.append(", issuers=").append(String.valueOf(this.issuers));
        sb.append(", audiences=").append(String.valueOf(this.audiences));
        sb.append(", verifyClaims=").append(String.valueOf(this.verifyClaims));
        sb.append(", publicKeys=").append(String.valueOf((Object)this.publicKeys));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof JwtAuthenticationPolicy)) {
            return false;
        }
        JwtAuthenticationPolicy other = (JwtAuthenticationPolicy)((Object)o);
        return Objects.equals(this.tokenHeader, other.tokenHeader) && Objects.equals(this.tokenQueryParam, other.tokenQueryParam) && Objects.equals(this.tokenAuthScheme, other.tokenAuthScheme) && Objects.equals(this.maxClockSkewInSeconds, other.maxClockSkewInSeconds) && Objects.equals(this.issuers, other.issuers) && Objects.equals(this.audiences, other.audiences) && Objects.equals(this.verifyClaims, other.verifyClaims) && Objects.equals((Object)this.publicKeys, (Object)other.publicKeys) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.tokenHeader == null ? 43 : this.tokenHeader.hashCode());
        result = result * 59 + (this.tokenQueryParam == null ? 43 : this.tokenQueryParam.hashCode());
        result = result * 59 + (this.tokenAuthScheme == null ? 43 : this.tokenAuthScheme.hashCode());
        result = result * 59 + (this.maxClockSkewInSeconds == null ? 43 : this.maxClockSkewInSeconds.hashCode());
        result = result * 59 + (this.issuers == null ? 43 : this.issuers.hashCode());
        result = result * 59 + (this.audiences == null ? 43 : this.audiences.hashCode());
        result = result * 59 + (this.verifyClaims == null ? 43 : this.verifyClaims.hashCode());
        result = result * 59 + (this.publicKeys == null ? 43 : this.publicKeys.hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="isAnonymousAccessAllowed")
        private Boolean isAnonymousAccessAllowed;
        @JsonProperty(value="tokenHeader")
        private String tokenHeader;
        @JsonProperty(value="tokenQueryParam")
        private String tokenQueryParam;
        @JsonProperty(value="tokenAuthScheme")
        private String tokenAuthScheme;
        @JsonProperty(value="maxClockSkewInSeconds")
        private Float maxClockSkewInSeconds;
        @JsonProperty(value="issuers")
        private List<String> issuers;
        @JsonProperty(value="audiences")
        private List<String> audiences;
        @JsonProperty(value="verifyClaims")
        private List<JsonWebTokenClaim> verifyClaims;
        @JsonProperty(value="publicKeys")
        private PublicKeySet publicKeys;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder isAnonymousAccessAllowed(Boolean isAnonymousAccessAllowed) {
            this.isAnonymousAccessAllowed = isAnonymousAccessAllowed;
            this.__explicitlySet__.add("isAnonymousAccessAllowed");
            return this;
        }

        public Builder tokenHeader(String tokenHeader) {
            this.tokenHeader = tokenHeader;
            this.__explicitlySet__.add("tokenHeader");
            return this;
        }

        public Builder tokenQueryParam(String tokenQueryParam) {
            this.tokenQueryParam = tokenQueryParam;
            this.__explicitlySet__.add("tokenQueryParam");
            return this;
        }

        public Builder tokenAuthScheme(String tokenAuthScheme) {
            this.tokenAuthScheme = tokenAuthScheme;
            this.__explicitlySet__.add("tokenAuthScheme");
            return this;
        }

        public Builder maxClockSkewInSeconds(Float maxClockSkewInSeconds) {
            this.maxClockSkewInSeconds = maxClockSkewInSeconds;
            this.__explicitlySet__.add("maxClockSkewInSeconds");
            return this;
        }

        public Builder issuers(List<String> issuers) {
            this.issuers = issuers;
            this.__explicitlySet__.add("issuers");
            return this;
        }

        public Builder audiences(List<String> audiences) {
            this.audiences = audiences;
            this.__explicitlySet__.add("audiences");
            return this;
        }

        public Builder verifyClaims(List<JsonWebTokenClaim> verifyClaims) {
            this.verifyClaims = verifyClaims;
            this.__explicitlySet__.add("verifyClaims");
            return this;
        }

        public Builder publicKeys(PublicKeySet publicKeys) {
            this.publicKeys = publicKeys;
            this.__explicitlySet__.add("publicKeys");
            return this;
        }

        public JwtAuthenticationPolicy build() {
            JwtAuthenticationPolicy model = new JwtAuthenticationPolicy(this.isAnonymousAccessAllowed, this.tokenHeader, this.tokenQueryParam, this.tokenAuthScheme, this.maxClockSkewInSeconds, this.issuers, this.audiences, this.verifyClaims, this.publicKeys);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(JwtAuthenticationPolicy model) {
            if (model.wasPropertyExplicitlySet("isAnonymousAccessAllowed")) {
                this.isAnonymousAccessAllowed(model.getIsAnonymousAccessAllowed());
            }
            if (model.wasPropertyExplicitlySet("tokenHeader")) {
                this.tokenHeader(model.getTokenHeader());
            }
            if (model.wasPropertyExplicitlySet("tokenQueryParam")) {
                this.tokenQueryParam(model.getTokenQueryParam());
            }
            if (model.wasPropertyExplicitlySet("tokenAuthScheme")) {
                this.tokenAuthScheme(model.getTokenAuthScheme());
            }
            if (model.wasPropertyExplicitlySet("maxClockSkewInSeconds")) {
                this.maxClockSkewInSeconds(model.getMaxClockSkewInSeconds());
            }
            if (model.wasPropertyExplicitlySet("issuers")) {
                this.issuers(model.getIssuers());
            }
            if (model.wasPropertyExplicitlySet("audiences")) {
                this.audiences(model.getAudiences());
            }
            if (model.wasPropertyExplicitlySet("verifyClaims")) {
                this.verifyClaims(model.getVerifyClaims());
            }
            if (model.wasPropertyExplicitlySet("publicKeys")) {
                this.publicKeys(model.getPublicKeys());
            }
            return this;
        }
    }
}

