/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.apigateway.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.apigateway.model.StaticPublicKey;
import com.oracle.bmc.http.internal.BmcEnum;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="format")
@JsonFilter(value="explicitlySetFilter")
public final class JsonWebKey
extends StaticPublicKey {
    @JsonProperty(value="kty")
    private final Kty kty;
    @JsonProperty(value="use")
    private final Use use;
    @JsonProperty(value="key_ops")
    private final List<KeyOps> keyOps;
    @JsonProperty(value="alg")
    private final String alg;
    @JsonProperty(value="n")
    private final String n;
    @JsonProperty(value="e")
    private final String e;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public JsonWebKey(String kid, Kty kty, Use use, List<KeyOps> keyOps, String alg, String n, String e) {
        super(kid);
        this.kty = kty;
        this.use = use;
        this.keyOps = keyOps;
        this.alg = alg;
        this.n = n;
        this.e = e;
    }

    public Kty getKty() {
        return this.kty;
    }

    public Use getUse() {
        return this.use;
    }

    public List<KeyOps> getKeyOps() {
        return this.keyOps;
    }

    public String getAlg() {
        return this.alg;
    }

    public String getN() {
        return this.n;
    }

    public String getE() {
        return this.e;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("JsonWebKey(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", kty=").append(String.valueOf((Object)this.kty));
        sb.append(", use=").append(String.valueOf((Object)this.use));
        sb.append(", keyOps=").append(String.valueOf(this.keyOps));
        sb.append(", alg=").append(String.valueOf(this.alg));
        sb.append(", n=").append(String.valueOf(this.n));
        sb.append(", e=").append(String.valueOf(this.e));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof JsonWebKey)) {
            return false;
        }
        JsonWebKey other = (JsonWebKey)((Object)o);
        return Objects.equals((Object)this.kty, (Object)other.kty) && Objects.equals((Object)this.use, (Object)other.use) && Objects.equals(this.keyOps, other.keyOps) && Objects.equals(this.alg, other.alg) && Objects.equals(this.n, other.n) && Objects.equals(this.e, other.e) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.kty == null ? 43 : this.kty.hashCode());
        result = result * 59 + (this.use == null ? 43 : this.use.hashCode());
        result = result * 59 + (this.keyOps == null ? 43 : this.keyOps.hashCode());
        result = result * 59 + (this.alg == null ? 43 : this.alg.hashCode());
        result = result * 59 + (this.n == null ? 43 : this.n.hashCode());
        result = result * 59 + (this.e == null ? 43 : this.e.hashCode());
        return result;
    }

    public static enum KeyOps implements BmcEnum
    {
        Verify("verify"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, KeyOps> map;

        private KeyOps(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static KeyOps create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'KeyOps', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(KeyOps.class);
            map = new HashMap<String, KeyOps>();
            for (KeyOps v : KeyOps.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum Use implements BmcEnum
    {
        Sig("sig"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, Use> map;

        private Use(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Use create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'Use', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(Use.class);
            map = new HashMap<String, Use>();
            for (Use v : Use.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum Kty implements BmcEnum
    {
        Rsa("RSA"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, Kty> map;

        private Kty(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Kty create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'Kty', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(Kty.class);
            map = new HashMap<String, Kty>();
            for (Kty v : Kty.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="kid")
        private String kid;
        @JsonProperty(value="kty")
        private Kty kty;
        @JsonProperty(value="use")
        private Use use;
        @JsonProperty(value="key_ops")
        private List<KeyOps> keyOps;
        @JsonProperty(value="alg")
        private String alg;
        @JsonProperty(value="n")
        private String n;
        @JsonProperty(value="e")
        private String e;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder kid(String kid) {
            this.kid = kid;
            this.__explicitlySet__.add("kid");
            return this;
        }

        public Builder kty(Kty kty) {
            this.kty = kty;
            this.__explicitlySet__.add("kty");
            return this;
        }

        public Builder use(Use use) {
            this.use = use;
            this.__explicitlySet__.add("use");
            return this;
        }

        public Builder keyOps(List<KeyOps> keyOps) {
            this.keyOps = keyOps;
            this.__explicitlySet__.add("keyOps");
            return this;
        }

        public Builder alg(String alg) {
            this.alg = alg;
            this.__explicitlySet__.add("alg");
            return this;
        }

        public Builder n(String n) {
            this.n = n;
            this.__explicitlySet__.add("n");
            return this;
        }

        public Builder e(String e) {
            this.e = e;
            this.__explicitlySet__.add("e");
            return this;
        }

        public JsonWebKey build() {
            JsonWebKey model = new JsonWebKey(this.kid, this.kty, this.use, this.keyOps, this.alg, this.n, this.e);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(JsonWebKey model) {
            if (model.wasPropertyExplicitlySet("kid")) {
                this.kid(model.getKid());
            }
            if (model.wasPropertyExplicitlySet("kty")) {
                this.kty(model.getKty());
            }
            if (model.wasPropertyExplicitlySet("use")) {
                this.use(model.getUse());
            }
            if (model.wasPropertyExplicitlySet("keyOps")) {
                this.keyOps(model.getKeyOps());
            }
            if (model.wasPropertyExplicitlySet("alg")) {
                this.alg(model.getAlg());
            }
            if (model.wasPropertyExplicitlySet("n")) {
                this.n(model.getN());
            }
            if (model.wasPropertyExplicitlySet("e")) {
                this.e(model.getE());
            }
            return this;
        }
    }
}

