/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.apigateway.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.apigateway.model.Quota;
import com.oracle.bmc.apigateway.model.RateLimit;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class EntitlementSummary
extends ExplicitlySetBmcModel {
    @JsonProperty(value="name")
    private final String name;
    @JsonProperty(value="description")
    private final String description;
    @JsonProperty(value="rateLimit")
    private final RateLimit rateLimit;
    @JsonProperty(value="quota")
    private final Quota quota;

    @Deprecated
    @ConstructorProperties(value={"name", "description", "rateLimit", "quota"})
    public EntitlementSummary(String name, String description, RateLimit rateLimit, Quota quota) {
        this.name = name;
        this.description = description;
        this.rateLimit = rateLimit;
        this.quota = quota;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public RateLimit getRateLimit() {
        return this.rateLimit;
    }

    public Quota getQuota() {
        return this.quota;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("EntitlementSummary(");
        sb.append("super=").append(super.toString());
        sb.append("name=").append(String.valueOf(this.name));
        sb.append(", description=").append(String.valueOf(this.description));
        sb.append(", rateLimit=").append(String.valueOf((Object)this.rateLimit));
        sb.append(", quota=").append(String.valueOf((Object)this.quota));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof EntitlementSummary)) {
            return false;
        }
        EntitlementSummary other = (EntitlementSummary)((Object)o);
        return Objects.equals(this.name, other.name) && Objects.equals(this.description, other.description) && Objects.equals((Object)this.rateLimit, (Object)other.rateLimit) && Objects.equals((Object)this.quota, (Object)other.quota) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.name == null ? 43 : this.name.hashCode());
        result = result * 59 + (this.description == null ? 43 : this.description.hashCode());
        result = result * 59 + (this.rateLimit == null ? 43 : this.rateLimit.hashCode());
        result = result * 59 + (this.quota == null ? 43 : this.quota.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="name")
        private String name;
        @JsonProperty(value="description")
        private String description;
        @JsonProperty(value="rateLimit")
        private RateLimit rateLimit;
        @JsonProperty(value="quota")
        private Quota quota;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder name(String name) {
            this.name = name;
            this.__explicitlySet__.add("name");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.__explicitlySet__.add("description");
            return this;
        }

        public Builder rateLimit(RateLimit rateLimit) {
            this.rateLimit = rateLimit;
            this.__explicitlySet__.add("rateLimit");
            return this;
        }

        public Builder quota(Quota quota) {
            this.quota = quota;
            this.__explicitlySet__.add("quota");
            return this;
        }

        public EntitlementSummary build() {
            EntitlementSummary model = new EntitlementSummary(this.name, this.description, this.rateLimit, this.quota);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(EntitlementSummary model) {
            if (model.wasPropertyExplicitlySet("name")) {
                this.name(model.getName());
            }
            if (model.wasPropertyExplicitlySet("description")) {
                this.description(model.getDescription());
            }
            if (model.wasPropertyExplicitlySet("rateLimit")) {
                this.rateLimit(model.getRateLimit());
            }
            if (model.wasPropertyExplicitlySet("quota")) {
                this.quota(model.getQuota());
            }
            return this;
        }
    }
}

