/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.apigateway.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.apigateway.model.ApiValidationDetail;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class ApiValidationDetails
extends ExplicitlySetBmcModel {
    @JsonProperty(value="details")
    private final List<ApiValidationDetail> details;
    @JsonProperty(value="name")
    private final String name;
    @JsonProperty(value="result")
    private final Result result;

    @Deprecated
    @ConstructorProperties(value={"details", "name", "result"})
    public ApiValidationDetails(List<ApiValidationDetail> details, String name, Result result) {
        this.details = details;
        this.name = name;
        this.result = result;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public List<ApiValidationDetail> getDetails() {
        return this.details;
    }

    public String getName() {
        return this.name;
    }

    public Result getResult() {
        return this.result;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("ApiValidationDetails(");
        sb.append("super=").append(super.toString());
        sb.append("details=").append(String.valueOf(this.details));
        sb.append(", name=").append(String.valueOf(this.name));
        sb.append(", result=").append(String.valueOf((Object)this.result));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ApiValidationDetails)) {
            return false;
        }
        ApiValidationDetails other = (ApiValidationDetails)((Object)o);
        return Objects.equals(this.details, other.details) && Objects.equals(this.name, other.name) && Objects.equals((Object)this.result, (Object)other.result) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.details == null ? 43 : this.details.hashCode());
        result = result * 59 + (this.name == null ? 43 : this.name.hashCode());
        result = result * 59 + (this.result == null ? 43 : this.result.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum Result implements BmcEnum
    {
        Error("ERROR"),
        Warning("WARNING"),
        Ok("OK"),
        Failed("FAILED"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, Result> map;

        private Result(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Result create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'Result', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(Result.class);
            map = new HashMap<String, Result>();
            for (Result v : Result.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="details")
        private List<ApiValidationDetail> details;
        @JsonProperty(value="name")
        private String name;
        @JsonProperty(value="result")
        private Result result;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder details(List<ApiValidationDetail> details) {
            this.details = details;
            this.__explicitlySet__.add("details");
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            this.__explicitlySet__.add("name");
            return this;
        }

        public Builder result(Result result) {
            this.result = result;
            this.__explicitlySet__.add("result");
            return this;
        }

        public ApiValidationDetails build() {
            ApiValidationDetails model = new ApiValidationDetails(this.details, this.name, this.result);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(ApiValidationDetails model) {
            if (model.wasPropertyExplicitlySet("details")) {
                this.details(model.getDetails());
            }
            if (model.wasPropertyExplicitlySet("name")) {
                this.name(model.getName());
            }
            if (model.wasPropertyExplicitlySet("result")) {
                this.result(model.getResult());
            }
            return this;
        }
    }
}

