/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.apigateway.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.apigateway.model.BodyValidationRequestPolicy;
import com.oracle.bmc.apigateway.model.CorsPolicy;
import com.oracle.bmc.apigateway.model.HeaderTransformationPolicy;
import com.oracle.bmc.apigateway.model.HeaderValidationRequestPolicy;
import com.oracle.bmc.apigateway.model.QueryParameterTransformationPolicy;
import com.oracle.bmc.apigateway.model.QueryParameterValidationRequestPolicy;
import com.oracle.bmc.apigateway.model.ResponseCacheLookupPolicy;
import com.oracle.bmc.apigateway.model.RouteAuthorizationPolicy;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class ApiSpecificationRouteRequestPolicies
extends ExplicitlySetBmcModel {
    @JsonProperty(value="authorization")
    private final RouteAuthorizationPolicy authorization;
    @JsonProperty(value="cors")
    private final CorsPolicy cors;
    @JsonProperty(value="queryParameterValidations")
    private final QueryParameterValidationRequestPolicy queryParameterValidations;
    @JsonProperty(value="headerValidations")
    private final HeaderValidationRequestPolicy headerValidations;
    @JsonProperty(value="bodyValidation")
    private final BodyValidationRequestPolicy bodyValidation;
    @JsonProperty(value="headerTransformations")
    private final HeaderTransformationPolicy headerTransformations;
    @JsonProperty(value="queryParameterTransformations")
    private final QueryParameterTransformationPolicy queryParameterTransformations;
    @JsonProperty(value="responseCacheLookup")
    private final ResponseCacheLookupPolicy responseCacheLookup;

    @Deprecated
    @ConstructorProperties(value={"authorization", "cors", "queryParameterValidations", "headerValidations", "bodyValidation", "headerTransformations", "queryParameterTransformations", "responseCacheLookup"})
    public ApiSpecificationRouteRequestPolicies(RouteAuthorizationPolicy authorization, CorsPolicy cors, QueryParameterValidationRequestPolicy queryParameterValidations, HeaderValidationRequestPolicy headerValidations, BodyValidationRequestPolicy bodyValidation, HeaderTransformationPolicy headerTransformations, QueryParameterTransformationPolicy queryParameterTransformations, ResponseCacheLookupPolicy responseCacheLookup) {
        this.authorization = authorization;
        this.cors = cors;
        this.queryParameterValidations = queryParameterValidations;
        this.headerValidations = headerValidations;
        this.bodyValidation = bodyValidation;
        this.headerTransformations = headerTransformations;
        this.queryParameterTransformations = queryParameterTransformations;
        this.responseCacheLookup = responseCacheLookup;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public RouteAuthorizationPolicy getAuthorization() {
        return this.authorization;
    }

    public CorsPolicy getCors() {
        return this.cors;
    }

    public QueryParameterValidationRequestPolicy getQueryParameterValidations() {
        return this.queryParameterValidations;
    }

    public HeaderValidationRequestPolicy getHeaderValidations() {
        return this.headerValidations;
    }

    public BodyValidationRequestPolicy getBodyValidation() {
        return this.bodyValidation;
    }

    public HeaderTransformationPolicy getHeaderTransformations() {
        return this.headerTransformations;
    }

    public QueryParameterTransformationPolicy getQueryParameterTransformations() {
        return this.queryParameterTransformations;
    }

    public ResponseCacheLookupPolicy getResponseCacheLookup() {
        return this.responseCacheLookup;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("ApiSpecificationRouteRequestPolicies(");
        sb.append("super=").append(super.toString());
        sb.append("authorization=").append(String.valueOf((Object)this.authorization));
        sb.append(", cors=").append(String.valueOf((Object)this.cors));
        sb.append(", queryParameterValidations=").append(String.valueOf((Object)this.queryParameterValidations));
        sb.append(", headerValidations=").append(String.valueOf((Object)this.headerValidations));
        sb.append(", bodyValidation=").append(String.valueOf((Object)this.bodyValidation));
        sb.append(", headerTransformations=").append(String.valueOf((Object)this.headerTransformations));
        sb.append(", queryParameterTransformations=").append(String.valueOf((Object)this.queryParameterTransformations));
        sb.append(", responseCacheLookup=").append(String.valueOf((Object)this.responseCacheLookup));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ApiSpecificationRouteRequestPolicies)) {
            return false;
        }
        ApiSpecificationRouteRequestPolicies other = (ApiSpecificationRouteRequestPolicies)((Object)o);
        return Objects.equals((Object)this.authorization, (Object)other.authorization) && Objects.equals((Object)this.cors, (Object)other.cors) && Objects.equals((Object)this.queryParameterValidations, (Object)other.queryParameterValidations) && Objects.equals((Object)this.headerValidations, (Object)other.headerValidations) && Objects.equals((Object)this.bodyValidation, (Object)other.bodyValidation) && Objects.equals((Object)this.headerTransformations, (Object)other.headerTransformations) && Objects.equals((Object)this.queryParameterTransformations, (Object)other.queryParameterTransformations) && Objects.equals((Object)this.responseCacheLookup, (Object)other.responseCacheLookup) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.authorization == null ? 43 : this.authorization.hashCode());
        result = result * 59 + (this.cors == null ? 43 : this.cors.hashCode());
        result = result * 59 + (this.queryParameterValidations == null ? 43 : this.queryParameterValidations.hashCode());
        result = result * 59 + (this.headerValidations == null ? 43 : this.headerValidations.hashCode());
        result = result * 59 + (this.bodyValidation == null ? 43 : this.bodyValidation.hashCode());
        result = result * 59 + (this.headerTransformations == null ? 43 : this.headerTransformations.hashCode());
        result = result * 59 + (this.queryParameterTransformations == null ? 43 : this.queryParameterTransformations.hashCode());
        result = result * 59 + (this.responseCacheLookup == null ? 43 : this.responseCacheLookup.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="authorization")
        private RouteAuthorizationPolicy authorization;
        @JsonProperty(value="cors")
        private CorsPolicy cors;
        @JsonProperty(value="queryParameterValidations")
        private QueryParameterValidationRequestPolicy queryParameterValidations;
        @JsonProperty(value="headerValidations")
        private HeaderValidationRequestPolicy headerValidations;
        @JsonProperty(value="bodyValidation")
        private BodyValidationRequestPolicy bodyValidation;
        @JsonProperty(value="headerTransformations")
        private HeaderTransformationPolicy headerTransformations;
        @JsonProperty(value="queryParameterTransformations")
        private QueryParameterTransformationPolicy queryParameterTransformations;
        @JsonProperty(value="responseCacheLookup")
        private ResponseCacheLookupPolicy responseCacheLookup;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder authorization(RouteAuthorizationPolicy authorization) {
            this.authorization = authorization;
            this.__explicitlySet__.add("authorization");
            return this;
        }

        public Builder cors(CorsPolicy cors) {
            this.cors = cors;
            this.__explicitlySet__.add("cors");
            return this;
        }

        public Builder queryParameterValidations(QueryParameterValidationRequestPolicy queryParameterValidations) {
            this.queryParameterValidations = queryParameterValidations;
            this.__explicitlySet__.add("queryParameterValidations");
            return this;
        }

        public Builder headerValidations(HeaderValidationRequestPolicy headerValidations) {
            this.headerValidations = headerValidations;
            this.__explicitlySet__.add("headerValidations");
            return this;
        }

        public Builder bodyValidation(BodyValidationRequestPolicy bodyValidation) {
            this.bodyValidation = bodyValidation;
            this.__explicitlySet__.add("bodyValidation");
            return this;
        }

        public Builder headerTransformations(HeaderTransformationPolicy headerTransformations) {
            this.headerTransformations = headerTransformations;
            this.__explicitlySet__.add("headerTransformations");
            return this;
        }

        public Builder queryParameterTransformations(QueryParameterTransformationPolicy queryParameterTransformations) {
            this.queryParameterTransformations = queryParameterTransformations;
            this.__explicitlySet__.add("queryParameterTransformations");
            return this;
        }

        public Builder responseCacheLookup(ResponseCacheLookupPolicy responseCacheLookup) {
            this.responseCacheLookup = responseCacheLookup;
            this.__explicitlySet__.add("responseCacheLookup");
            return this;
        }

        public ApiSpecificationRouteRequestPolicies build() {
            ApiSpecificationRouteRequestPolicies model = new ApiSpecificationRouteRequestPolicies(this.authorization, this.cors, this.queryParameterValidations, this.headerValidations, this.bodyValidation, this.headerTransformations, this.queryParameterTransformations, this.responseCacheLookup);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(ApiSpecificationRouteRequestPolicies model) {
            if (model.wasPropertyExplicitlySet("authorization")) {
                this.authorization(model.getAuthorization());
            }
            if (model.wasPropertyExplicitlySet("cors")) {
                this.cors(model.getCors());
            }
            if (model.wasPropertyExplicitlySet("queryParameterValidations")) {
                this.queryParameterValidations(model.getQueryParameterValidations());
            }
            if (model.wasPropertyExplicitlySet("headerValidations")) {
                this.headerValidations(model.getHeaderValidations());
            }
            if (model.wasPropertyExplicitlySet("bodyValidation")) {
                this.bodyValidation(model.getBodyValidation());
            }
            if (model.wasPropertyExplicitlySet("headerTransformations")) {
                this.headerTransformations(model.getHeaderTransformations());
            }
            if (model.wasPropertyExplicitlySet("queryParameterTransformations")) {
                this.queryParameterTransformations(model.getQueryParameterTransformations());
            }
            if (model.wasPropertyExplicitlySet("responseCacheLookup")) {
                this.responseCacheLookup(model.getResponseCacheLookup());
            }
            return this;
        }
    }
}

