/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.apigateway.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.apigateway.model.JsonWebTokenClaim;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class AdditionalValidationPolicy
extends ExplicitlySetBmcModel {
    @JsonProperty(value="issuers")
    private final List<String> issuers;
    @JsonProperty(value="audiences")
    private final List<String> audiences;
    @JsonProperty(value="verifyClaims")
    private final List<JsonWebTokenClaim> verifyClaims;

    @Deprecated
    @ConstructorProperties(value={"issuers", "audiences", "verifyClaims"})
    public AdditionalValidationPolicy(List<String> issuers, List<String> audiences, List<JsonWebTokenClaim> verifyClaims) {
        this.issuers = issuers;
        this.audiences = audiences;
        this.verifyClaims = verifyClaims;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public List<String> getIssuers() {
        return this.issuers;
    }

    public List<String> getAudiences() {
        return this.audiences;
    }

    public List<JsonWebTokenClaim> getVerifyClaims() {
        return this.verifyClaims;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("AdditionalValidationPolicy(");
        sb.append("super=").append(super.toString());
        sb.append("issuers=").append(String.valueOf(this.issuers));
        sb.append(", audiences=").append(String.valueOf(this.audiences));
        sb.append(", verifyClaims=").append(String.valueOf(this.verifyClaims));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AdditionalValidationPolicy)) {
            return false;
        }
        AdditionalValidationPolicy other = (AdditionalValidationPolicy)((Object)o);
        return Objects.equals(this.issuers, other.issuers) && Objects.equals(this.audiences, other.audiences) && Objects.equals(this.verifyClaims, other.verifyClaims) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.issuers == null ? 43 : this.issuers.hashCode());
        result = result * 59 + (this.audiences == null ? 43 : this.audiences.hashCode());
        result = result * 59 + (this.verifyClaims == null ? 43 : this.verifyClaims.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="issuers")
        private List<String> issuers;
        @JsonProperty(value="audiences")
        private List<String> audiences;
        @JsonProperty(value="verifyClaims")
        private List<JsonWebTokenClaim> verifyClaims;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder issuers(List<String> issuers) {
            this.issuers = issuers;
            this.__explicitlySet__.add("issuers");
            return this;
        }

        public Builder audiences(List<String> audiences) {
            this.audiences = audiences;
            this.__explicitlySet__.add("audiences");
            return this;
        }

        public Builder verifyClaims(List<JsonWebTokenClaim> verifyClaims) {
            this.verifyClaims = verifyClaims;
            this.__explicitlySet__.add("verifyClaims");
            return this;
        }

        public AdditionalValidationPolicy build() {
            AdditionalValidationPolicy model = new AdditionalValidationPolicy(this.issuers, this.audiences, this.verifyClaims);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(AdditionalValidationPolicy model) {
            if (model.wasPropertyExplicitlySet("issuers")) {
                this.issuers(model.getIssuers());
            }
            if (model.wasPropertyExplicitlySet("audiences")) {
                this.audiences(model.getAudiences());
            }
            if (model.wasPropertyExplicitlySet("verifyClaims")) {
                this.verifyClaims(model.getVerifyClaims());
            }
            return this;
        }
    }
}

