/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.apigateway;

import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.apigateway.UsagePlans;
import com.oracle.bmc.apigateway.UsagePlansAsyncClient;
import com.oracle.bmc.apigateway.UsagePlansPaginators;
import com.oracle.bmc.apigateway.UsagePlansWaiters;
import com.oracle.bmc.apigateway.model.UsagePlan;
import com.oracle.bmc.apigateway.model.UsagePlanCollection;
import com.oracle.bmc.apigateway.requests.ChangeUsagePlanCompartmentRequest;
import com.oracle.bmc.apigateway.requests.CreateUsagePlanRequest;
import com.oracle.bmc.apigateway.requests.DeleteUsagePlanRequest;
import com.oracle.bmc.apigateway.requests.GetUsagePlanRequest;
import com.oracle.bmc.apigateway.requests.ListUsagePlansRequest;
import com.oracle.bmc.apigateway.requests.UpdateUsagePlanRequest;
import com.oracle.bmc.apigateway.responses.ChangeUsagePlanCompartmentResponse;
import com.oracle.bmc.apigateway.responses.CreateUsagePlanResponse;
import com.oracle.bmc.apigateway.responses.DeleteUsagePlanResponse;
import com.oracle.bmc.apigateway.responses.GetUsagePlanResponse;
import com.oracle.bmc.apigateway.responses.ListUsagePlansResponse;
import com.oracle.bmc.apigateway.responses.UpdateUsagePlanResponse;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.common.ClientBuilderBase;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.client.Method;
import com.oracle.bmc.http.internal.BaseSyncClient;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.internal.ClientThreadFactory;
import com.oracle.bmc.util.CircuitBreakerUtils;
import com.oracle.bmc.util.internal.Validate;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UsagePlansClient
extends BaseSyncClient
implements UsagePlans {
    public static final Service SERVICE = Services.serviceBuilder().serviceName("USAGEPLANS").serviceEndpointPrefix("").serviceEndpointTemplate("https://apigateway.{region}.oci.{secondLevelDomain}").build();
    private static final Logger LOG = LoggerFactory.getLogger(UsagePlansAsyncClient.class);
    private final UsagePlansWaiters waiters;
    private final UsagePlansPaginators paginators;

    private UsagePlansClient(ClientBuilderBase<?, ?> builder, AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ExecutorService executorService) {
        super(builder, authenticationDetailsProvider, CircuitBreakerUtils.DEFAULT_CIRCUIT_BREAKER_CONFIGURATION);
        if (executorService == null) {
            ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(50, 50, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), (ThreadFactory)ClientThreadFactory.builder().isDaemon(true).nameFormat("UsagePlans-waiters-%d").build());
            threadPoolExecutor.allowCoreThreadTimeOut(true);
            executorService = threadPoolExecutor;
        }
        this.waiters = new UsagePlansWaiters(executorService, this);
        this.paginators = new UsagePlansPaginators(this);
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setRegion(Region region) {
        super.setRegion(region);
    }

    @Override
    public void setRegion(String regionId) {
        super.setRegion(regionId);
    }

    @Override
    public ChangeUsagePlanCompartmentResponse changeUsagePlanCompartment(ChangeUsagePlanCompartmentRequest request) {
        Validate.notBlank((String)request.getUsagePlanId(), (String)"usagePlanId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangeUsagePlanCompartmentDetails(), "changeUsagePlanCompartmentDetails is required");
        return (ChangeUsagePlanCompartmentResponse)this.clientCall(request, ChangeUsagePlanCompartmentResponse::builder).logger(LOG, "changeUsagePlanCompartment").serviceDetails("UsagePlans", "ChangeUsagePlanCompartment", "https://docs.oracle.com/iaas/api/#/en/api-gateway/20190501/UsagePlan/ChangeUsagePlanCompartment").method(Method.POST).requestBuilder(ChangeUsagePlanCompartmentRequest::builder).basePath("/20190501").appendPathParam("usagePlans").appendPathParam(request.getUsagePlanId()).appendPathParam("actions").appendPathParam("changeCompartment").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("opc-work-request-id", ChangeUsagePlanCompartmentResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", ChangeUsagePlanCompartmentResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public CreateUsagePlanResponse createUsagePlan(CreateUsagePlanRequest request) {
        Objects.requireNonNull(request.getCreateUsagePlanDetails(), "createUsagePlanDetails is required");
        return (CreateUsagePlanResponse)this.clientCall(request, CreateUsagePlanResponse::builder).logger(LOG, "createUsagePlan").serviceDetails("UsagePlans", "CreateUsagePlan", "").method(Method.POST).requestBuilder(CreateUsagePlanRequest::builder).basePath("/20190501").appendPathParam("usagePlans").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(UsagePlan.class, CreateUsagePlanResponse.Builder::usagePlan).handleResponseHeaderString("etag", CreateUsagePlanResponse.Builder::etag).handleResponseHeaderString("opc-work-request-id", CreateUsagePlanResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", CreateUsagePlanResponse.Builder::opcRequestId).handleResponseHeaderString("location", CreateUsagePlanResponse.Builder::location).operationUsesDefaultRetries().callSync();
    }

    @Override
    public DeleteUsagePlanResponse deleteUsagePlan(DeleteUsagePlanRequest request) {
        Validate.notBlank((String)request.getUsagePlanId(), (String)"usagePlanId must not be blank", (Object[])new Object[0]);
        return (DeleteUsagePlanResponse)this.clientCall(request, DeleteUsagePlanResponse::builder).logger(LOG, "deleteUsagePlan").serviceDetails("UsagePlans", "DeleteUsagePlan", "https://docs.oracle.com/iaas/api/#/en/api-gateway/20190501/UsagePlan/DeleteUsagePlan").method(Method.DELETE).requestBuilder(DeleteUsagePlanRequest::builder).basePath("/20190501").appendPathParam("usagePlans").appendPathParam(request.getUsagePlanId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-work-request-id", DeleteUsagePlanResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", DeleteUsagePlanResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetUsagePlanResponse getUsagePlan(GetUsagePlanRequest request) {
        Validate.notBlank((String)request.getUsagePlanId(), (String)"usagePlanId must not be blank", (Object[])new Object[0]);
        return (GetUsagePlanResponse)this.clientCall(request, GetUsagePlanResponse::builder).logger(LOG, "getUsagePlan").serviceDetails("UsagePlans", "GetUsagePlan", "https://docs.oracle.com/iaas/api/#/en/api-gateway/20190501/UsagePlan/GetUsagePlan").method(Method.GET).requestBuilder(GetUsagePlanRequest::builder).basePath("/20190501").appendPathParam("usagePlans").appendPathParam(request.getUsagePlanId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(UsagePlan.class, GetUsagePlanResponse.Builder::usagePlan).handleResponseHeaderString("etag", GetUsagePlanResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetUsagePlanResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public ListUsagePlansResponse listUsagePlans(ListUsagePlansRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (ListUsagePlansResponse)this.clientCall(request, ListUsagePlansResponse::builder).logger(LOG, "listUsagePlans").serviceDetails("UsagePlans", "ListUsagePlans", "https://docs.oracle.com/iaas/api/#/en/api-gateway/20190501/UsagePlan/ListUsagePlans").method(Method.GET).requestBuilder(ListUsagePlansRequest::builder).basePath("/20190501").appendPathParam("usagePlans").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(UsagePlanCollection.class, ListUsagePlansResponse.Builder::usagePlanCollection).handleResponseHeaderString("opc-request-id", ListUsagePlansResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListUsagePlansResponse.Builder::opcNextPage).handleResponseHeaderString("opc-prev-page", ListUsagePlansResponse.Builder::opcPrevPage).operationUsesDefaultRetries().callSync();
    }

    @Override
    public UpdateUsagePlanResponse updateUsagePlan(UpdateUsagePlanRequest request) {
        Validate.notBlank((String)request.getUsagePlanId(), (String)"usagePlanId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateUsagePlanDetails(), "updateUsagePlanDetails is required");
        return (UpdateUsagePlanResponse)this.clientCall(request, UpdateUsagePlanResponse::builder).logger(LOG, "updateUsagePlan").serviceDetails("UsagePlans", "UpdateUsagePlan", "https://docs.oracle.com/iaas/api/#/en/api-gateway/20190501/UsagePlan/UpdateUsagePlan").method(Method.PUT).requestBuilder(UpdateUsagePlanRequest::builder).basePath("/20190501").appendPathParam("usagePlans").appendPathParam(request.getUsagePlanId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("opc-work-request-id", UpdateUsagePlanResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", UpdateUsagePlanResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public UsagePlansWaiters getWaiters() {
        return this.waiters;
    }

    @Override
    public UsagePlansPaginators getPaginators() {
        return this.paginators;
    }

    @Deprecated
    public UsagePlansClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this((ClientBuilderBase<?, ?>)UsagePlansClient.builder(), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public UsagePlansClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(UsagePlansClient.builder().configuration(configuration), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public UsagePlansClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this(((Builder)UsagePlansClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public UsagePlansClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(((Builder)((Builder)UsagePlansClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory), authenticationDetailsProvider, null);
    }

    @Deprecated
    public UsagePlansClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(((Builder)((Builder)((Builder)UsagePlansClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators), authenticationDetailsProvider, null);
    }

    @Deprecated
    public UsagePlansClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)UsagePlansClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint), authenticationDetailsProvider, null);
    }

    @Deprecated
    public UsagePlansClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)UsagePlansClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider, null);
    }

    @Deprecated
    public UsagePlansClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint, ExecutorService executorService) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)UsagePlansClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider, executorService);
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, UsagePlansClient> {
        private ExecutorService executorService;

        private Builder(Service service) {
            super(service);
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public Builder executorService(ExecutorService executorService) {
            this.executorService = executorService;
            return this;
        }

        public UsagePlansClient build(@Nonnull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            return new UsagePlansClient((ClientBuilderBase)this, authenticationDetailsProvider, this.executorService);
        }
    }
}

