/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.apigateway;

import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.apigateway.SubscribersAsync;
import com.oracle.bmc.apigateway.model.Subscriber;
import com.oracle.bmc.apigateway.model.SubscriberCollection;
import com.oracle.bmc.apigateway.requests.ChangeSubscriberCompartmentRequest;
import com.oracle.bmc.apigateway.requests.CreateSubscriberRequest;
import com.oracle.bmc.apigateway.requests.DeleteSubscriberRequest;
import com.oracle.bmc.apigateway.requests.GetSubscriberRequest;
import com.oracle.bmc.apigateway.requests.ListSubscribersRequest;
import com.oracle.bmc.apigateway.requests.UpdateSubscriberRequest;
import com.oracle.bmc.apigateway.responses.ChangeSubscriberCompartmentResponse;
import com.oracle.bmc.apigateway.responses.CreateSubscriberResponse;
import com.oracle.bmc.apigateway.responses.DeleteSubscriberResponse;
import com.oracle.bmc.apigateway.responses.GetSubscriberResponse;
import com.oracle.bmc.apigateway.responses.ListSubscribersResponse;
import com.oracle.bmc.apigateway.responses.UpdateSubscriberResponse;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.common.ClientBuilderBase;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.client.Method;
import com.oracle.bmc.http.internal.BaseAsyncClient;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.responses.AsyncHandler;
import com.oracle.bmc.util.internal.Validate;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Future;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubscribersAsyncClient
extends BaseAsyncClient
implements SubscribersAsync {
    public static final Service SERVICE = Services.serviceBuilder().serviceName("SUBSCRIBERS").serviceEndpointPrefix("").serviceEndpointTemplate("https://apigateway.{region}.oci.{secondLevelDomain}").build();
    private static final Logger LOG = LoggerFactory.getLogger(SubscribersAsyncClient.class);

    private SubscribersAsyncClient(ClientBuilderBase<?, ?> builder, AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
        super(builder, authenticationDetailsProvider);
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setRegion(Region region) {
        super.setRegion(region);
    }

    @Override
    public void setRegion(String regionId) {
        super.setRegion(regionId);
    }

    @Override
    public Future<ChangeSubscriberCompartmentResponse> changeSubscriberCompartment(ChangeSubscriberCompartmentRequest request, AsyncHandler<ChangeSubscriberCompartmentRequest, ChangeSubscriberCompartmentResponse> handler) {
        Validate.notBlank((String)request.getSubscriberId(), (String)"subscriberId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangeSubscriberCompartmentDetails(), "changeSubscriberCompartmentDetails is required");
        return this.clientCall(request, ChangeSubscriberCompartmentResponse::builder).logger(LOG, "changeSubscriberCompartment").serviceDetails("Subscribers", "ChangeSubscriberCompartment", "https://docs.oracle.com/iaas/api/#/en/api-gateway/20190501/Subscriber/ChangeSubscriberCompartment").method(Method.POST).requestBuilder(ChangeSubscriberCompartmentRequest::builder).basePath("/20190501").appendPathParam("subscribers").appendPathParam(request.getSubscriberId()).appendPathParam("actions").appendPathParam("changeCompartment").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("opc-work-request-id", ChangeSubscriberCompartmentResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", ChangeSubscriberCompartmentResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<CreateSubscriberResponse> createSubscriber(CreateSubscriberRequest request, AsyncHandler<CreateSubscriberRequest, CreateSubscriberResponse> handler) {
        Objects.requireNonNull(request.getCreateSubscriberDetails(), "createSubscriberDetails is required");
        return this.clientCall(request, CreateSubscriberResponse::builder).logger(LOG, "createSubscriber").serviceDetails("Subscribers", "CreateSubscriber", "").method(Method.POST).requestBuilder(CreateSubscriberRequest::builder).basePath("/20190501").appendPathParam("subscribers").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(Subscriber.class, CreateSubscriberResponse.Builder::subscriber).handleResponseHeaderString("etag", CreateSubscriberResponse.Builder::etag).handleResponseHeaderString("opc-work-request-id", CreateSubscriberResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", CreateSubscriberResponse.Builder::opcRequestId).handleResponseHeaderString("location", CreateSubscriberResponse.Builder::location).callAsync(handler);
    }

    @Override
    public Future<DeleteSubscriberResponse> deleteSubscriber(DeleteSubscriberRequest request, AsyncHandler<DeleteSubscriberRequest, DeleteSubscriberResponse> handler) {
        Validate.notBlank((String)request.getSubscriberId(), (String)"subscriberId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, DeleteSubscriberResponse::builder).logger(LOG, "deleteSubscriber").serviceDetails("Subscribers", "DeleteSubscriber", "https://docs.oracle.com/iaas/api/#/en/api-gateway/20190501/Subscriber/DeleteSubscriber").method(Method.DELETE).requestBuilder(DeleteSubscriberRequest::builder).basePath("/20190501").appendPathParam("subscribers").appendPathParam(request.getSubscriberId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-work-request-id", DeleteSubscriberResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", DeleteSubscriberResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetSubscriberResponse> getSubscriber(GetSubscriberRequest request, AsyncHandler<GetSubscriberRequest, GetSubscriberResponse> handler) {
        Validate.notBlank((String)request.getSubscriberId(), (String)"subscriberId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetSubscriberResponse::builder).logger(LOG, "getSubscriber").serviceDetails("Subscribers", "GetSubscriber", "https://docs.oracle.com/iaas/api/#/en/api-gateway/20190501/Subscriber/GetSubscriber").method(Method.GET).requestBuilder(GetSubscriberRequest::builder).basePath("/20190501").appendPathParam("subscribers").appendPathParam(request.getSubscriberId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(Subscriber.class, GetSubscriberResponse.Builder::subscriber).handleResponseHeaderString("etag", GetSubscriberResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetSubscriberResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ListSubscribersResponse> listSubscribers(ListSubscribersRequest request, AsyncHandler<ListSubscribersRequest, ListSubscribersResponse> handler) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return this.clientCall(request, ListSubscribersResponse::builder).logger(LOG, "listSubscribers").serviceDetails("Subscribers", "ListSubscribers", "https://docs.oracle.com/iaas/api/#/en/api-gateway/20190501/Subscriber/ListSubscribers").method(Method.GET).requestBuilder(ListSubscribersRequest::builder).basePath("/20190501").appendPathParam("subscribers").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(SubscriberCollection.class, ListSubscribersResponse.Builder::subscriberCollection).handleResponseHeaderString("opc-request-id", ListSubscribersResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListSubscribersResponse.Builder::opcNextPage).handleResponseHeaderString("opc-prev-page", ListSubscribersResponse.Builder::opcPrevPage).callAsync(handler);
    }

    @Override
    public Future<UpdateSubscriberResponse> updateSubscriber(UpdateSubscriberRequest request, AsyncHandler<UpdateSubscriberRequest, UpdateSubscriberResponse> handler) {
        Validate.notBlank((String)request.getSubscriberId(), (String)"subscriberId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateSubscriberDetails(), "updateSubscriberDetails is required");
        return this.clientCall(request, UpdateSubscriberResponse::builder).logger(LOG, "updateSubscriber").serviceDetails("Subscribers", "UpdateSubscriber", "https://docs.oracle.com/iaas/api/#/en/api-gateway/20190501/Subscriber/UpdateSubscriber").method(Method.PUT).requestBuilder(UpdateSubscriberRequest::builder).basePath("/20190501").appendPathParam("subscribers").appendPathParam(request.getSubscriberId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("opc-work-request-id", UpdateSubscriberResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", UpdateSubscriberResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Deprecated
    public SubscribersAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this((ClientBuilderBase<?, ?>)SubscribersAsyncClient.builder(), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public SubscribersAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(SubscribersAsyncClient.builder().configuration(configuration), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public SubscribersAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this(((Builder)SubscribersAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public SubscribersAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(((Builder)((Builder)SubscribersAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory), authenticationDetailsProvider);
    }

    @Deprecated
    public SubscribersAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(((Builder)((Builder)((Builder)SubscribersAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators), authenticationDetailsProvider);
    }

    @Deprecated
    public SubscribersAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)SubscribersAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint), authenticationDetailsProvider);
    }

    @Deprecated
    public SubscribersAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)SubscribersAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider);
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, SubscribersAsyncClient> {
        private Builder(Service service) {
            super(service);
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public SubscribersAsyncClient build(@Nonnull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            return new SubscribersAsyncClient((ClientBuilderBase)this, authenticationDetailsProvider);
        }
    }
}

