/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.apigateway;

import com.oracle.bmc.apigateway.Deployment;
import com.oracle.bmc.apigateway.model.DeploymentSummary;
import com.oracle.bmc.apigateway.requests.ListDeploymentsRequest;
import com.oracle.bmc.apigateway.responses.ListDeploymentsResponse;
import com.oracle.bmc.paginator.internal.RequestBuilderAndToken;
import com.oracle.bmc.paginator.internal.ResponseIterable;
import com.oracle.bmc.paginator.internal.ResponseRecordIterable;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;

public class DeploymentPaginators {
    private final Deployment client;

    public DeploymentPaginators(Deployment client) {
        this.client = client;
    }

    public Iterable<ListDeploymentsResponse> listDeploymentsResponseIterator(final ListDeploymentsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListDeploymentsRequest.Builder>(){

            @Override
            public ListDeploymentsRequest.Builder get() {
                return ListDeploymentsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListDeploymentsResponse, String>(){

            @Override
            public String apply(ListDeploymentsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListDeploymentsRequest.Builder>, ListDeploymentsRequest>(){

            @Override
            public ListDeploymentsRequest apply(RequestBuilderAndToken<ListDeploymentsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListDeploymentsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListDeploymentsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListDeploymentsRequest, ListDeploymentsResponse>(){

            @Override
            public ListDeploymentsResponse apply(ListDeploymentsRequest request) {
                return DeploymentPaginators.this.client.listDeployments(request);
            }
        });
    }

    public Iterable<DeploymentSummary> listDeploymentsRecordIterator(final ListDeploymentsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListDeploymentsRequest.Builder>(){

            @Override
            public ListDeploymentsRequest.Builder get() {
                return ListDeploymentsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListDeploymentsResponse, String>(){

            @Override
            public String apply(ListDeploymentsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListDeploymentsRequest.Builder>, ListDeploymentsRequest>(){

            @Override
            public ListDeploymentsRequest apply(RequestBuilderAndToken<ListDeploymentsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListDeploymentsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListDeploymentsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListDeploymentsRequest, ListDeploymentsResponse>(){

            @Override
            public ListDeploymentsResponse apply(ListDeploymentsRequest request) {
                return DeploymentPaginators.this.client.listDeployments(request);
            }
        }, (Function)new Function<ListDeploymentsResponse, List<DeploymentSummary>>(){

            @Override
            public List<DeploymentSummary> apply(ListDeploymentsResponse response) {
                return response.getDeploymentCollection().getItems();
            }
        });
    }
}

