/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.announcementsservice.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class GetAnnouncementUserStatusRequest
extends BmcRequest<Void> {
    private String announcementId;
    private String opcRequestId;

    public String getAnnouncementId() {
        return this.announcementId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().announcementId(this.announcementId).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",announcementId=").append(String.valueOf(this.announcementId));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetAnnouncementUserStatusRequest)) {
            return false;
        }
        GetAnnouncementUserStatusRequest other = (GetAnnouncementUserStatusRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.announcementId, other.announcementId) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.announcementId == null ? 43 : this.announcementId.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<GetAnnouncementUserStatusRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String announcementId = null;
        private String opcRequestId = null;

        public Builder announcementId(String announcementId) {
            this.announcementId = announcementId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetAnnouncementUserStatusRequest o) {
            this.announcementId(o.getAnnouncementId());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetAnnouncementUserStatusRequest build() {
            GetAnnouncementUserStatusRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public GetAnnouncementUserStatusRequest buildWithoutInvocationCallback() {
            GetAnnouncementUserStatusRequest request = new GetAnnouncementUserStatusRequest();
            request.announcementId = this.announcementId;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

