/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.announcementsservice.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.announcementsservice.model.AffectedResource;
import com.oracle.bmc.announcementsservice.model.BaseAnnouncement;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="type")
@JsonFilter(value="explicitlySetFilter")
public final class Announcement
extends BaseAnnouncement {
    @JsonProperty(value="description")
    private final String description;
    @JsonProperty(value="additionalInformation")
    private final String additionalInformation;
    @JsonProperty(value="affectedResources")
    private final List<AffectedResource> affectedResources;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public Announcement(String id, String referenceTicketNumber, String summary, String timeOneTitle, BaseAnnouncement.TimeOneType timeOneType, Date timeOneValue, String timeTwoTitle, BaseAnnouncement.TimeTwoType timeTwoType, Date timeTwoValue, List<String> services, List<String> affectedRegions, BaseAnnouncement.AnnouncementType announcementType, BaseAnnouncement.LifecycleState lifecycleState, Boolean isBanner, Date timeCreated, Date timeUpdated, String environmentName, BaseAnnouncement.PlatformType platformType, String description, String additionalInformation, List<AffectedResource> affectedResources) {
        super(id, referenceTicketNumber, summary, timeOneTitle, timeOneType, timeOneValue, timeTwoTitle, timeTwoType, timeTwoValue, services, affectedRegions, announcementType, lifecycleState, isBanner, timeCreated, timeUpdated, environmentName, platformType);
        this.description = description;
        this.additionalInformation = additionalInformation;
        this.affectedResources = affectedResources;
    }

    public String getDescription() {
        return this.description;
    }

    public String getAdditionalInformation() {
        return this.additionalInformation;
    }

    public List<AffectedResource> getAffectedResources() {
        return this.affectedResources;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("Announcement(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", description=").append(String.valueOf(this.description));
        sb.append(", additionalInformation=").append(String.valueOf(this.additionalInformation));
        sb.append(", affectedResources=").append(String.valueOf(this.affectedResources));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Announcement)) {
            return false;
        }
        Announcement other = (Announcement)((Object)o);
        return Objects.equals(this.description, other.description) && Objects.equals(this.additionalInformation, other.additionalInformation) && Objects.equals(this.affectedResources, other.affectedResources) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.description == null ? 43 : this.description.hashCode());
        result = result * 59 + (this.additionalInformation == null ? 43 : this.additionalInformation.hashCode());
        result = result * 59 + (this.affectedResources == null ? 43 : this.affectedResources.hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="id")
        private String id;
        @JsonProperty(value="referenceTicketNumber")
        private String referenceTicketNumber;
        @JsonProperty(value="summary")
        private String summary;
        @JsonProperty(value="timeOneTitle")
        private String timeOneTitle;
        @JsonProperty(value="timeOneType")
        private BaseAnnouncement.TimeOneType timeOneType;
        @JsonProperty(value="timeOneValue")
        private Date timeOneValue;
        @JsonProperty(value="timeTwoTitle")
        private String timeTwoTitle;
        @JsonProperty(value="timeTwoType")
        private BaseAnnouncement.TimeTwoType timeTwoType;
        @JsonProperty(value="timeTwoValue")
        private Date timeTwoValue;
        @JsonProperty(value="services")
        private List<String> services;
        @JsonProperty(value="affectedRegions")
        private List<String> affectedRegions;
        @JsonProperty(value="announcementType")
        private BaseAnnouncement.AnnouncementType announcementType;
        @JsonProperty(value="lifecycleState")
        private BaseAnnouncement.LifecycleState lifecycleState;
        @JsonProperty(value="isBanner")
        private Boolean isBanner;
        @JsonProperty(value="timeCreated")
        private Date timeCreated;
        @JsonProperty(value="timeUpdated")
        private Date timeUpdated;
        @JsonProperty(value="environmentName")
        private String environmentName;
        @JsonProperty(value="platformType")
        private BaseAnnouncement.PlatformType platformType;
        @JsonProperty(value="description")
        private String description;
        @JsonProperty(value="additionalInformation")
        private String additionalInformation;
        @JsonProperty(value="affectedResources")
        private List<AffectedResource> affectedResources;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder id(String id) {
            this.id = id;
            this.__explicitlySet__.add("id");
            return this;
        }

        public Builder referenceTicketNumber(String referenceTicketNumber) {
            this.referenceTicketNumber = referenceTicketNumber;
            this.__explicitlySet__.add("referenceTicketNumber");
            return this;
        }

        public Builder summary(String summary) {
            this.summary = summary;
            this.__explicitlySet__.add("summary");
            return this;
        }

        public Builder timeOneTitle(String timeOneTitle) {
            this.timeOneTitle = timeOneTitle;
            this.__explicitlySet__.add("timeOneTitle");
            return this;
        }

        public Builder timeOneType(BaseAnnouncement.TimeOneType timeOneType) {
            this.timeOneType = timeOneType;
            this.__explicitlySet__.add("timeOneType");
            return this;
        }

        public Builder timeOneValue(Date timeOneValue) {
            this.timeOneValue = timeOneValue;
            this.__explicitlySet__.add("timeOneValue");
            return this;
        }

        public Builder timeTwoTitle(String timeTwoTitle) {
            this.timeTwoTitle = timeTwoTitle;
            this.__explicitlySet__.add("timeTwoTitle");
            return this;
        }

        public Builder timeTwoType(BaseAnnouncement.TimeTwoType timeTwoType) {
            this.timeTwoType = timeTwoType;
            this.__explicitlySet__.add("timeTwoType");
            return this;
        }

        public Builder timeTwoValue(Date timeTwoValue) {
            this.timeTwoValue = timeTwoValue;
            this.__explicitlySet__.add("timeTwoValue");
            return this;
        }

        public Builder services(List<String> services) {
            this.services = services;
            this.__explicitlySet__.add("services");
            return this;
        }

        public Builder affectedRegions(List<String> affectedRegions) {
            this.affectedRegions = affectedRegions;
            this.__explicitlySet__.add("affectedRegions");
            return this;
        }

        public Builder announcementType(BaseAnnouncement.AnnouncementType announcementType) {
            this.announcementType = announcementType;
            this.__explicitlySet__.add("announcementType");
            return this;
        }

        public Builder lifecycleState(BaseAnnouncement.LifecycleState lifecycleState) {
            this.lifecycleState = lifecycleState;
            this.__explicitlySet__.add("lifecycleState");
            return this;
        }

        public Builder isBanner(Boolean isBanner) {
            this.isBanner = isBanner;
            this.__explicitlySet__.add("isBanner");
            return this;
        }

        public Builder timeCreated(Date timeCreated) {
            this.timeCreated = timeCreated;
            this.__explicitlySet__.add("timeCreated");
            return this;
        }

        public Builder timeUpdated(Date timeUpdated) {
            this.timeUpdated = timeUpdated;
            this.__explicitlySet__.add("timeUpdated");
            return this;
        }

        public Builder environmentName(String environmentName) {
            this.environmentName = environmentName;
            this.__explicitlySet__.add("environmentName");
            return this;
        }

        public Builder platformType(BaseAnnouncement.PlatformType platformType) {
            this.platformType = platformType;
            this.__explicitlySet__.add("platformType");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.__explicitlySet__.add("description");
            return this;
        }

        public Builder additionalInformation(String additionalInformation) {
            this.additionalInformation = additionalInformation;
            this.__explicitlySet__.add("additionalInformation");
            return this;
        }

        public Builder affectedResources(List<AffectedResource> affectedResources) {
            this.affectedResources = affectedResources;
            this.__explicitlySet__.add("affectedResources");
            return this;
        }

        public Announcement build() {
            Announcement model = new Announcement(this.id, this.referenceTicketNumber, this.summary, this.timeOneTitle, this.timeOneType, this.timeOneValue, this.timeTwoTitle, this.timeTwoType, this.timeTwoValue, this.services, this.affectedRegions, this.announcementType, this.lifecycleState, this.isBanner, this.timeCreated, this.timeUpdated, this.environmentName, this.platformType, this.description, this.additionalInformation, this.affectedResources);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(Announcement model) {
            if (model.wasPropertyExplicitlySet("id")) {
                this.id(model.getId());
            }
            if (model.wasPropertyExplicitlySet("referenceTicketNumber")) {
                this.referenceTicketNumber(model.getReferenceTicketNumber());
            }
            if (model.wasPropertyExplicitlySet("summary")) {
                this.summary(model.getSummary());
            }
            if (model.wasPropertyExplicitlySet("timeOneTitle")) {
                this.timeOneTitle(model.getTimeOneTitle());
            }
            if (model.wasPropertyExplicitlySet("timeOneType")) {
                this.timeOneType(model.getTimeOneType());
            }
            if (model.wasPropertyExplicitlySet("timeOneValue")) {
                this.timeOneValue(model.getTimeOneValue());
            }
            if (model.wasPropertyExplicitlySet("timeTwoTitle")) {
                this.timeTwoTitle(model.getTimeTwoTitle());
            }
            if (model.wasPropertyExplicitlySet("timeTwoType")) {
                this.timeTwoType(model.getTimeTwoType());
            }
            if (model.wasPropertyExplicitlySet("timeTwoValue")) {
                this.timeTwoValue(model.getTimeTwoValue());
            }
            if (model.wasPropertyExplicitlySet("services")) {
                this.services(model.getServices());
            }
            if (model.wasPropertyExplicitlySet("affectedRegions")) {
                this.affectedRegions(model.getAffectedRegions());
            }
            if (model.wasPropertyExplicitlySet("announcementType")) {
                this.announcementType(model.getAnnouncementType());
            }
            if (model.wasPropertyExplicitlySet("lifecycleState")) {
                this.lifecycleState(model.getLifecycleState());
            }
            if (model.wasPropertyExplicitlySet("isBanner")) {
                this.isBanner(model.getIsBanner());
            }
            if (model.wasPropertyExplicitlySet("timeCreated")) {
                this.timeCreated(model.getTimeCreated());
            }
            if (model.wasPropertyExplicitlySet("timeUpdated")) {
                this.timeUpdated(model.getTimeUpdated());
            }
            if (model.wasPropertyExplicitlySet("environmentName")) {
                this.environmentName(model.getEnvironmentName());
            }
            if (model.wasPropertyExplicitlySet("platformType")) {
                this.platformType(model.getPlatformType());
            }
            if (model.wasPropertyExplicitlySet("description")) {
                this.description(model.getDescription());
            }
            if (model.wasPropertyExplicitlySet("additionalInformation")) {
                this.additionalInformation(model.getAdditionalInformation());
            }
            if (model.wasPropertyExplicitlySet("affectedResources")) {
                this.affectedResources(model.getAffectedResources());
            }
            return this;
        }
    }
}

