/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.announcementsservice;

import com.oracle.bmc.announcementsservice.AnnouncementSubscription;
import com.oracle.bmc.announcementsservice.model.AnnouncementSubscription;
import com.oracle.bmc.announcementsservice.requests.GetAnnouncementSubscriptionRequest;
import com.oracle.bmc.announcementsservice.responses.GetAnnouncementSubscriptionResponse;
import com.oracle.bmc.util.internal.Validate;
import com.oracle.bmc.waiter.BmcGenericWaiter;
import com.oracle.bmc.waiter.DelayStrategy;
import com.oracle.bmc.waiter.TerminationStrategy;
import com.oracle.bmc.waiter.Waiter;
import com.oracle.bmc.waiter.Waiters;
import com.oracle.bmc.waiter.internal.SimpleWaiterImpl;
import java.util.Arrays;
import java.util.HashSet;
import java.util.concurrent.ExecutorService;
import java.util.function.Function;
import java.util.function.Predicate;

public class AnnouncementSubscriptionWaiters {
    private final ExecutorService executorService;
    private final AnnouncementSubscription client;

    public AnnouncementSubscriptionWaiters(ExecutorService executorService, AnnouncementSubscription client) {
        this.executorService = executorService;
        this.client = client;
    }

    public Waiter<GetAnnouncementSubscriptionRequest, GetAnnouncementSubscriptionResponse> forAnnouncementSubscription(GetAnnouncementSubscriptionRequest request, AnnouncementSubscription.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forAnnouncementSubscription(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetAnnouncementSubscriptionRequest, GetAnnouncementSubscriptionResponse> forAnnouncementSubscription(GetAnnouncementSubscriptionRequest request, AnnouncementSubscription.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forAnnouncementSubscription(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetAnnouncementSubscriptionRequest, GetAnnouncementSubscriptionResponse> forAnnouncementSubscription(GetAnnouncementSubscriptionRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, AnnouncementSubscription.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forAnnouncementSubscription(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetAnnouncementSubscriptionRequest, GetAnnouncementSubscriptionResponse> forAnnouncementSubscription(BmcGenericWaiter waiter, GetAnnouncementSubscriptionRequest request, AnnouncementSubscription.LifecycleState ... targetStates) {
        final HashSet<AnnouncementSubscription.LifecycleState> targetStatesSet = new HashSet<AnnouncementSubscription.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetAnnouncementSubscriptionRequest, GetAnnouncementSubscriptionResponse>(){

            @Override
            public GetAnnouncementSubscriptionResponse apply(GetAnnouncementSubscriptionRequest request) {
                return AnnouncementSubscriptionWaiters.this.client.getAnnouncementSubscription(request);
            }
        }, (Predicate)new Predicate<GetAnnouncementSubscriptionResponse>(){

            @Override
            public boolean test(GetAnnouncementSubscriptionResponse response) {
                return targetStatesSet.contains((Object)response.getAnnouncementSubscription().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)AnnouncementSubscription.LifecycleState.Deleted)), (Object)request);
    }
}

