/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.analytics.requests;

import com.oracle.bmc.analytics.model.SortOrder;
import com.oracle.bmc.analytics.model.WorkRequestResourceType;
import com.oracle.bmc.analytics.model.WorkRequestSortBy;
import com.oracle.bmc.analytics.model.WorkRequestStatus;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

public class ListWorkRequestsRequest
extends BmcRequest<Void> {
    private String compartmentId;
    private String resourceId;
    private WorkRequestResourceType resourceType;
    private List<WorkRequestStatus> status;
    private Integer limit;
    private String page;
    private WorkRequestSortBy sortBy;
    private SortOrder sortOrder;
    private String opcRequestId;

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public String getResourceId() {
        return this.resourceId;
    }

    public WorkRequestResourceType getResourceType() {
        return this.resourceType;
    }

    public List<WorkRequestStatus> getStatus() {
        return this.status;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public String getPage() {
        return this.page;
    }

    public WorkRequestSortBy getSortBy() {
        return this.sortBy;
    }

    public SortOrder getSortOrder() {
        return this.sortOrder;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().compartmentId(this.compartmentId).resourceId(this.resourceId).resourceType(this.resourceType).status(this.status).limit(this.limit).page(this.page).sortBy(this.sortBy).sortOrder(this.sortOrder).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(",resourceId=").append(String.valueOf(this.resourceId));
        sb.append(",resourceType=").append(String.valueOf((Object)this.resourceType));
        sb.append(",status=").append(String.valueOf(this.status));
        sb.append(",limit=").append(String.valueOf(this.limit));
        sb.append(",page=").append(String.valueOf(this.page));
        sb.append(",sortBy=").append(String.valueOf((Object)this.sortBy));
        sb.append(",sortOrder=").append(String.valueOf((Object)this.sortOrder));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ListWorkRequestsRequest)) {
            return false;
        }
        ListWorkRequestsRequest other = (ListWorkRequestsRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals(this.resourceId, other.resourceId) && Objects.equals((Object)this.resourceType, (Object)other.resourceType) && Objects.equals(this.status, other.status) && Objects.equals(this.limit, other.limit) && Objects.equals(this.page, other.page) && Objects.equals((Object)this.sortBy, (Object)other.sortBy) && Objects.equals((Object)this.sortOrder, (Object)other.sortOrder) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.resourceId == null ? 43 : this.resourceId.hashCode());
        result = result * 59 + (this.resourceType == null ? 43 : this.resourceType.hashCode());
        result = result * 59 + (this.status == null ? 43 : this.status.hashCode());
        result = result * 59 + (this.limit == null ? 43 : this.limit.hashCode());
        result = result * 59 + (this.page == null ? 43 : this.page.hashCode());
        result = result * 59 + (this.sortBy == null ? 43 : this.sortBy.hashCode());
        result = result * 59 + (this.sortOrder == null ? 43 : this.sortOrder.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<ListWorkRequestsRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String compartmentId = null;
        private String resourceId = null;
        private WorkRequestResourceType resourceType = null;
        private List<WorkRequestStatus> status = null;
        private Integer limit = null;
        private String page = null;
        private WorkRequestSortBy sortBy = null;
        private SortOrder sortOrder = null;
        private String opcRequestId = null;

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            return this;
        }

        public Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        public Builder resourceType(WorkRequestResourceType resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        public Builder status(List<WorkRequestStatus> status) {
            this.status = status;
            return this;
        }

        public Builder status(WorkRequestStatus singularValue) {
            return this.status(Arrays.asList(singularValue));
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder sortBy(WorkRequestSortBy sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        public Builder sortOrder(SortOrder sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ListWorkRequestsRequest o) {
            this.compartmentId(o.getCompartmentId());
            this.resourceId(o.getResourceId());
            this.resourceType(o.getResourceType());
            this.status(o.getStatus());
            this.limit(o.getLimit());
            this.page(o.getPage());
            this.sortBy(o.getSortBy());
            this.sortOrder(o.getSortOrder());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ListWorkRequestsRequest build() {
            ListWorkRequestsRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public ListWorkRequestsRequest buildWithoutInvocationCallback() {
            ListWorkRequestsRequest request = new ListWorkRequestsRequest();
            request.compartmentId = this.compartmentId;
            request.resourceId = this.resourceId;
            request.resourceType = this.resourceType;
            request.status = this.status;
            request.limit = this.limit;
            request.page = this.page;
            request.sortBy = this.sortBy;
            request.sortOrder = this.sortOrder;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

